; ---------------- BLASTER2.ASM ------------------
; BlasterSound BBS intro. Hope you like it, Mikel!
; ------------------------------------------------
; Written by Iguana in 1994.
; Design and text writer by Jare.
; Snowfaller and Adlib player by JCAB.
; Tune by COI.
; Font by unknown (Hi unknown! Howya doing?).
; ------------------------------------------------
;    The original idea comes from one of the first
; ASM routines that JCAB and I coded, long ago, on
; the ZX Spectrum. We liked the way it looked, and
; as it seems that this year we will not have snow
; in our city, we brought the concept back. :-)
;    I had never thought that a screen had so many
; pixels. Just wait until it fills completely!
; ------------------------------------------------

NFLAKES = 2000
SCRW    = 80
SIZEX   = 640
SIZEY   = 480
SIZESCR = SCRW*SIZEY
TEXTY   = 400

TCCLEAR   = 0FFFEh
TCRESTART = 0FFFFh

TFLAKE STRUC
    addr  DW ?
    mask  DB ?
    yvel  DB ?
    erase DB ?
ENDS

SetBorder MACRO r,g,b
        PUSH    DX AX
        MOV     DX,3C8h
        XOR     AL,AL
        OUT     DX,AL
        INC     DX
        MOV     AL,r
        OUT     DX,AL
        MOV     AL,g
        OUT     DX,AL
        MOV     AL,b
        OUT     DX,AL
        POP     AX DX
ENDM



; 
;     Here comes the code.                                             
; 

        MODEL TINY
        LOCALS @@
        CODESEG
        ORG 100h
        JUMPS
Start:
        JMP RealStart                   ; Filler for JCAB's compressor.
FillStart:
        DB 99+(OFFSET Start-OFFSET FillStart) DUP (0)
                                        ; It takes 99 bytes; Wow!

RealStart:
        MOV     AX,CS
        MOV     ES,AX
        MOV     DX,AX
        CMP     AX,7000h
        JNC     SHORT @@novga
        ADD     AX,1000h
        MOV     SS,AX
        MOV     SP,0FFFEh
        XOR     BX,BX
        MOV     AX,01A00h
        INT     10h
        CMP     BL,7
        JC      SHORT @@novga
        CMP     BL,0Dh
        JC      SHORT VGAYes
    @@novga:
        MOV     DX,OFFSET VgaMsg
MessageExit:
        MOV     AH,9
        INT     21h
        MOV     AX,4C00h
        INT     21h

VGAYes:
        CLD
        CALL    SetupVideoMode
        MOV     DI,OFFSET ZeroStart
        MOV     CX,ZeroLength
        XOR     AX,AX
        REP STOSB

        MOV     DX,SS
        MOV     ES,DX
        XOR     DI,DI
        MOV     CX,7F00h
        REP STOSW
        MOV     DX,CS
        MOV     ES,DX

        MOV     DI,OFFSET ScrOffs
        MOV     CX,SIZEY
    @@sl1:
         STOSW
         ADD    AX,SCRW
         LOOP   SHORT @@sl1

        ;SetBorder 63,0,63
        MOV     BL,FontNChars
        MOV     DI,OFFSET FontOffs
        MOV     SI,OFFSET FontTable
        MOV     AX,OFFSET FontData
    @@fl1:
         STOSW
         XOR    CX,CX
         MOV    CL,[SI]
         INC    SI
     @@fl2:
          ADD    AX,12
          LOOP   @@fl2
         DEC    BL
         JNZ    SHORT @@fl1

         MOV    ES,[VGASeg]
         XOR    DI,DI
         MOV    CX,SIZESCR/2
         XOR    AX,AX
         REP STOSW

         DEC    AX
         MOV    CX,SCRW*6/2
    @@evlp:
          MOV   WORD PTR SS:[DI],AX
          STOSW
          LOOP  SHORT @@evlp

        CALL    WriteBlaster

        CALL    MPU_Reset
        CALL    ADL_Reset
        CALL    ADL_StartSong
        CALL    InitTimer

MainLoop:
        MOV     AX,1234h
    @@timlp:
         CMP    AX,[TimerCounter]
         JZ     SHORT @@timlp
        MOV     AX,[TimerCounter]
        MOV     WORD PTR CS:[@@timlp-2],AX

        ;SetBorder 0,0,63
        CALL    DoFlakes

        ;SetBorder 0,63,0
        CALL    DoWriter
        CALL    DoWriter
        CALL    DoWriter
        ;SetBorder 63,0,0
        XOR     AX,AX
        MOV     ES,AX
        MOV     AX,ES:[41Ah]            ; Tran's way to kbhit().
        CMP     AX,ES:[41Ch]            ; Sure it's better than INT 16h.
        JZ      MainLoop

        XOR     AX,AX
        INT     16h

    @@bye:
        CALL    DoneTimer
        CALL    RestoreSystemTime
        CALL    ADL_Reset
        CALL    MPU_Reset
        MOV     AX,3
        INT     10h
        MOV     DX,OFFSET ByeMsg
        JMP     MessageExit

; =======================================

SetupVideoMode:
        MOV     AX,11h          ; VGA 640x480x16
        INT     10h

        CLI
        MOV     DX,3DAh         ; Now use a linear palette, DACs 0-15.
        IN      AL,DX
        MOV     DX,3C0h         ; Mode control register,
        MOV     AL,10h
        OUT     DX,AL
        INC     DX
        IN      AL,DX           ; Read it.
        DEC     DX
        MOV     AH,AL
        MOV     DX,3DAh
        IN      AL,DX
        MOV     DX,3C0h
        MOV     AL,10h
        OUT     DX,AL
        MOV     AL,AH           ; Force get bits p4&p5 from reg #14.
        OR      AL,80h
        OUT     DX,AL

        MOV     AL,14h
        OUT     DX,AL
        XOR     AL,AL
        OUT     DX,AL           ; Force DAC index bits p4-p7 == 0.

        MOV     CX,16
        XOR     AL,AL
    @@pl1:
         OUT    DX,AL           ; Output index.
         OUT    DX,AL           ; Output value. Value == index.
         INC    AL
         LOOP   SHORT @@pl1

        MOV     AL,34h          ; Redo it, activating the VGA along.
        OUT     DX,AL
        XOR     AL,AL
        OUT     DX,AL           ; Force DAC index bits p4-p7 == 0.

        MOV     CX,16*3         ; Time to output the palette.
        MOV     DX,3C8h
        XOR     AL,AL
        OUT     DX,AL
        INC     DX
        MOV     SI,OFFSET Palette
     @@pl2:
         LODSB
         OUT    DX,AL
         LOOP   SHORT @@pl2
        STI
        RET

; =======================================
; Returns random AX.

GetRandomNumber:
        MOV     AX,[RandSeed]
        MOV     BX,[RandSeed2]
        MOV     BP,[RandSeed3]
        ADD     AX,0a137h
        ADD     BX,63f7h
        ADD     BP,784Ah
        ROL     AX,2
        MOV     [RandSeed],AX
        ADD     BX,AX
        ROR     BX,1
        MOV     [RandSeed2],BX
        SUB     BP,BX
        XOR     AX,BP
        MOV     [RandSeed3],BP
        ADD     AX,BX
        RET

; =======================================
; Returns in AX a number between 1 and 3.

GetRandomNumber3:
        CALL    GetRandomNumber
        OR      AX,AX
        JZ      SHORT GetRandomNumber3
   @@rl1:
        TEST    AL,3
        JNZ     SHORT @@ret
        SHR     AX,2
        JZ      SHORT GetRandomNumber3
        JMP     SHORT @@rl1
   @@ret:
        AND     AX,3
        RET

; =======================================
; Return a number in the range 0-639

GetRandomNumber640:
        CALL    GetRandomNumber
        AND     AX,1023
        CMP     AX,SIZEX
        JNC     SHORT GetRandomNumber640
        RET

; =======================================
; Rotate an addr(DI) and mask(AH) by a one bit(AL=-1,0,1)

RotMask:
        AND     AL,AL
        JS      SHORT RotMaskLeft
        JNZ     SHORT RotMaskRight
        RET

RotMaskRight:
        ROR     AH,1
        ADC     DI,0
        RET

RotMaskLeft:
        ROL     AH,1
        SBB     DI,0
        RET 

; =======================================

DoFlakes:
        MOV     ES,[VGASeg]
        MOV     SI,OFFSET Flakes
        MOV     [nnew],0
        MOV     AX,[MaxFlakes]
        ADD     AX,1
        CMP     AX,NFLAKES
        JC      SHORT @@fc1
         MOV    AX,NFLAKES
   @@fc1:
        MOV     [MaxFlakes],AX
        MOV     [FlakeCounter],AX

        MOV     DX,3CEh
        MOV     AL,4
        OUT     DX,AL
        INC     DX
        MOV     AL,3                    ; Read from plane 3
        OUT     DX,AL
        DEC     DX

        MOV     AL,5
        OUT     DX,AL
        INC     DX
        IN      AL,DX
        AND     AL,0FCh                 ; Write mode 0
        OUT     DX,AL
        DEC     DX
        MOV     AL,8                    ; Bitmask
        OUT     DX,AL
        INC     DX
        MOV     AL,0FFh
        OUT     DX,AL

        MOV     DX,3C4h
        MOV     AL,2
        OUT     DX,AL
        INC     DX
        MOV     AL,08h                  ; Write to plane 3.
        OUT     DX,AL

  @@loop:
        MOV     AL,yvel[SI]
        OR      AL,AL
        JNZ     SHORT @@doflake
         CMP    [nnew],10
         JNC    @@next
         CALL   GetRandomNumber640
         MOV    CL,AL
         AND    CL,7
         MOV    BL,80h
         SHR    BL,CL
         MOV    mask[SI],BL
         MOV    CL,3
         SHR    AX,CL
         MOV    addr[SI],AX
         CALL   GetRandomNumber
         AND    AX,3
         INC    AL
         ADD    AL,AL
         MOV    yvel[SI],AL
         XOR    AX,AX
         MOV    erase[SI],AL
         INC    [nnew]

   @@doflake:
        MOV     AL,erase[SI]
        OR      AL,AL
        JZ      SHORT @@noer
         MOV    DI,addr[SI]
         MOV    AH,mask[SI]
         NOT    AH
         AND    ES:[DI],AH
         AND    SS:[DI],AH
     @@noer:
        XOR     BH,BH
        MOV     erase[SI],BH
        MOV     BL,yvel[SI]
        MOV     AX,ScrOffs[BX]
        ADD     AX,addr[SI]
        MOV     addr[SI],AX
        CALL    GetRandomNumber3
        SUB     AL,2
        MOV     DI,addr[SI]
        MOV     AH,mask[SI]
        CALL    RotMask

        TEST    AH,SS:[DI]
        JZ      SHORT @@nostop

        MOV     DI,addr[SI]
        MOV     AH,mask[SI]
        TEST    AH,SS:[DI]
        JZ      SHORT @@nostop
        ADD     DI,SCRW
        TEST    AH,SS:[DI]
        JZ      SHORT @@nostop
    @@stoplp1:
         SUB    DI,SCRW
         JC     SHORT @@ynook
         TEST   AH,SS:[DI]
         JNZ    SHORT @@stoplp1

         CALL   RotMaskLeft
         TEST   AH,SS:[DI]
         JNZ    SHORT @@donelt
          TEST  AH,SS:[DI+SCRW]
          JZ    SHORT @@nostop
    @@donelt:
         CALL   RotMaskRight
         CALL   RotMaskRight
         TEST   AH,SS:[DI]
         JNZ    SHORT @@donert
          TEST  AH,SS:[DI+SCRW]
          JZ    SHORT @@nostop
    @@donert:
        CALL    RotMaskLeft
        MOV     yvel[SI],0

    @@nostop:
        OR      ES:[DI],AH
        OR      SS:[DI],AH
        MOV     addr[SI],DI
        MOV     mask[SI],AH
        MOV     erase[SI],AH

   @@next:
        ADD     SI,SIZE TFLAKE
        DEC     [FlakeCounter]
        JNZ     @@loop

        RET

    @@ynook:
         MOV    yvel[SI],0
         JMP    SHORT @@next

; =======================================
; Warning: spaghetti code follows.
; Sometimes you have to do things like
; this one, just to enjoy yourself.

DoWriter:
        MOV     AX,[TextDelay]
        OR      AX,AX
        JZ      SHORT @@wc1
         DEC    [TextDelay]
         RET
    @@wc1:
        MOV     ES,[VGASeg]
        MOV     DX,3C4h
        MOV     AL,2
        OUT     DX,AL
        INC     DX
        MOV     AL,07h                  ; Write to planes 0-2.
        OUT     DX,AL
        MOV     DX,3CEh
        MOV     AL,5
        OUT     DX,AL
        INC     DX
        IN      AL,DX
        AND     AL,0FCh                 ; Write mode 0
        OUT     DX,AL

        MOV     SI,[TextPos]
        OR      SI,SI
        JNZ     @@drawl
   @@inittext:
         MOV    SI,OFFSET IntroText
         JMP    SHORT @@initline
   @@looptext:
         MOV    SI,OFFSET LoopText
   @@initline:
         LODSW
         CMP    AX,TCRESTART
         JZ     SHORT @@looptext
         CMP    AX,TCCLEAR
         JNZ    SHORT @@ic2
          MOV   DX,3CEh
          MOV   AL,8                    ; Bitmask
          OUT   DX,AL
          INC   DX
          MOV   AL,0FFh
          OUT   DX,AL
          MOV   DI,165*SCRW
          MOV   CX,SCRW*(350-165)/2
          XOR   AX,AX
          REP STOSW
          JMP   SHORT @@initline
     @@ic2:
         MOV    BX,AX
         SHR    BX,3
         MOV    CL,AL
         MOV    AL,80h
         AND    CL,7
         JZ     SHORT @@ic1
          SHR   AL,CL
     @@ic1:
         MOV    [TextBitmask],AL
         LODSW
         ADD    AX,AX
         MOV    DI,AX
         MOV    AX,ScrOffs[DI]
         ADD    BX,AX
         MOV    [TextAddr],BX
    @@newchar:
         LODSB
         MOV    [TextPos],SI
         OR     AL,AL
         JZ     SHORT @@initline
         CMP    AL,' '
         JZ     SHORT @@nc1
         JNC    SHORT @@nc2
          XOR   AH,AH
          MOV   DX,60
          MUL   DX
          MOV   [TextDelay],AX
          RET
     @@nc1:
          MOV   CX,15
       @@nl1:
           CALL @@advpos
           LOOP @@nl1
          JMP   SHORT @@newchar
     @@nc2:
         SUB    AL,'A'
         XOR    BX,BX
         MOV    BL,AL
         MOV    AL,FontTable[BX]
         MOV    [TextWidth],AL
         ADD    BX,BX
         MOV    AX,FontOffs[BX]
         MOV    [TextCharData],AX
   @@drawl:
        MOV     AL,[TextWidth]
        OR      AL,AL
        JNZ     SHORT @@dc1
         CALL   @@advpos
         CALL   @@advpos
         JMP    @@newchar
    @@dc1:
        DEC     [TextWidth]
        MOV     DX,3CEh
        MOV     AL,5
        CLI
        OUT     DX,AL
        INC     DX
        IN      AL,DX
        AND     AL,0FCh
        OR      AL,2                    ; Write Mode 2
        OUT     DX,AL
        DEC     DX
        MOV     AL,8                    ; Bitmask
        OUT     DX,AL
        INC     DX
        MOV     AL,[TextBitmask]
        OUT     DX,AL
        STI
        MOV     SI,[TextCharData]
        MOV     DI,[TextAddr]
        MOV     CX,12
      @@dl1:
         LODSB
         MOV    AH,AL
         SHR    AL,4
         AND    AL,7
         JZ     SHORT @@dc2
          MOV   BL,ES:[DI]      ; Load latches.
          MOV   ES:[DI],AL
     @@dc2:
         ADD    DI,SCRW
         MOV    AL,AH
         AND    AL,7
         JZ     SHORT @@dc3
          MOV   BL,ES:[DI]      ; Load latches.
          MOV   ES:[DI],AL
     @@dc3:
         ADD    DI,SCRW
         LOOP   SHORT @@dl1
        MOV     [TextCharData],SI

   @@advpos:
        ROR     [TextBitmask],1
        ADC     [TextAddr],0
        RET

; =======================================
; Writes the big BlasterSound logo at the
; bottom. Upper squares are softened.

WriteBlaster:
        MOV     ES,[VGASeg]
        MOV     DX,3C4h
        MOV     AL,2
        OUT     DX,AL
        INC     DX
        MOV     AL,0Fh                  ; Write to planes 0-2.
        OUT     DX,AL
        MOV     DX,3CEh
        MOV     AL,5
        OUT     DX,AL
        INC     DX
        IN      AL,DX
        AND     AL,0FCh                 ; Write mode 2
        OR      AL,2
        OUT     DX,AL
        MOV     DI,SCRW*400+7
        MOV     AH,0C0h
        MOV     SI,OFFSET BlasterMsg
   @@loop:
         LODSB
         SUB    AL,'A'
         JC     SHORT @@ret
         XOR    BX,BX
         MOV    BL,AL
         MOV    CH,FontTable[BX]
         ADD    BL,BL
         MOV    BX,FontOffs[BX]
      @@cl1:
          MOV   DX,3CEh
          MOV   AL,8                    ; Bitmask
          OUT   DX,AL
          INC   DX
          MOV   AL,AH
          OUT   DX,AL
          MOV   CL,12
      @@cl2:
           MOV  AL,[BX]
           INC  BX
           MOV  DL,AL
           SHR  AL,4
           AND  AL,7
           JZ   SHORT @@dc2
            OR  AL,8
            MOV DH,ES:[DI]      ; Load latches.
            MOV ES:[DI],AL
            MOV ES:[DI+SCRW],AL
            OR  SS:[DI],AH
            OR  SS:[DI+SCRW],AH
       @@dc2:
           ADD  DI,SCRW*2
           MOV  AL,DL
           AND  AL,7
           JZ   SHORT @@dc3
            OR  AL,8
            MOV DH,ES:[DI]      ; Load latches.
            MOV ES:[DI],AL
            MOV ES:[DI+SCRW],AL
            OR  SS:[DI],AH
            OR  SS:[DI+SCRW],AH
       @@dc3:
           ADD  DI,SCRW*2
           DEC  CL
           JNZ  SHORT @@cl2
          SUB   DI,2*12*2*SCRW
          ROR   AH,1
          ROR   AH,1
          ADC   DI,0
          DEC   CH
          JNZ   SHORT @@cl1
          JMP   SHORT @@loop
    @@ret:

        ; Smooth corners.

        MOV     DX,3CEh
        MOV     AL,5
        OUT     DX,AL
        INC     DX
        IN      AL,DX
        AND     AL,0FCh                 ; Write mode 0
        OUT     DX,AL

        MOV     DI,OFFSET SCRW*400+7
        MOV     CL,24
    @@sl1:
        PUSH    DI
        MOV     AH,80h
        MOV     SI,(640-7*8)/2
    @@sl2:
         TEST   AH,SS:[DI]
         JZ     SHORT @@sc1
         TEST   AH,SS:[DI-SCRW]
         JNZ    SHORT @@sc1
         CALL   RotMaskLeft
         TEST   AH,SS:[DI]
         PUSHF
         CALL   RotMaskRight
         POPF
         JNZ    SHORT @@sc1
          DEC   DX
          MOV   AL,8                    ; Bitmask
          OUT   DX,AL
          INC   DX
          MOV   AL,AH
          OUT   DX,AL
          NOT   AL
          AND   SS:[DI],AL
          AND   ES:[DI],AL
    @@sc1:
         CALL   RotMaskRight
         TEST   AH,SS:[DI]
         JZ     SHORT @@sc2
         TEST   AH,SS:[DI-SCRW]
         JNZ    SHORT @@sc2
         CALL   RotMaskRight
         TEST   AH,SS:[DI]
         PUSHF
         CALL   RotMaskLeft
         POPF
         JNZ    SHORT @@sc2
          DEC   DX
          MOV   AL,8                    ; Bitmask
          OUT   DX,AL
          INC   DX
          MOV   AL,AH
          OUT   DX,AL
          NOT   AL
          AND   SS:[DI],AL
          AND   ES:[DI],AL
    @@sc2:
    @@next:
         CALL   RotMaskRight
         DEC    SI
         JNZ    SHORT @@sl2
        POP     DI
        ADD     DI,2*SCRW
        DEC     CL
        JNZ     SHORT @@sl1
       RET

; =======================================
; Timer handler routine.

TimerHandler:
        CLI
        PUSH    AX
        MOV     AL,20h
        OUT     20h,AL
        INC     CS:[TimerCounter]
        CALL    ADL_DoSong
        POP     AX
        IRET

; =======================================
; Timer (un)initialization.

InitTimer:
        MOV     AX,3508h
        INT     21h
        MOV     [OldTimerHandlerOffs],BX
        MOV     [OldTimerHandlerSeg],ES

        MOV     DX,OFFSET TimerHandler
        MOV     AX,CS
        MOV     DS,AX
        MOV     AX,2508h
        INT     21h

        MOV     BX,23863  ;19886                ; 1193180/60
        MOV     AL,54
        OUT     43h,AL
        MOV     AL,BL
        OUT     40h,AL
        MOV     AL,BH
        OUT     40h,AL
        RET

DoneTimer:
        MOV     DX,[OldTimerHandlerOffs]
        MOV     DS,[OldTimerHandlerSeg]
        MOV     AX,2508h
        INT     21h
        MOV     AX,CS
        MOV     DS,AX

        MOV     AL,54
        OUT     43h,AL
        XOR     AL,AL
        OUT     40h,AL
        OUT     40h,AL
        RET

; =======================================
; Restore system time from CMOS registers.
; Just to be nice.

RestoreSystemTime:
       XOR     AL,AL
       OUT     70h,AL
       IN      AL,71h
       MOV     DH,AL
       AND     DH,15
       SHR     AL,4
       MOV     DL,10
       MUL     DL
       ADD     DH,AL

       MOV     AL,2
       OUT     70h,AL
       IN      AL,71h
       MOV     CL,AL
       AND     CL,15
       SHR     AL,4
       MOV     DL,10
       MUL     DL
       ADD     CL,AL

       MOV     AL,4
       OUT     70h,AL
       IN      AL,71h
       MOV     CH,AL
       AND     CH,15
       SHR     AL,4
       MOV     DL,10
       MUL     DL
       ADD     CH,AL

       XOR     DL,DL
       MOV     AH,2Dh
       INT     21h

       MOV     AL,7
       OUT     70h,AL
       IN      AL,71h
       MOV     DL,AL
       AND     DL,15
       SHR     AL,4
       MOV     CH,10
       MUL     CH
       ADD     DL,AL

       MOV     AL,8
       OUT     70h,AL
       IN      AL,71h
       MOV     DH,AL
       AND     DH,15
       SHR     AL,4
       MOV     CH,10
       MUL     CH
       ADD     DH,AL

       MOV     AL,4
       OUT     70h,AL
       IN      AL,71h
       MOV     CL,AL
       AND     CL,15
       SHR     AL,4
       MOV     CH,10
       MUL     CH
       ADD     CL,AL

       XOR     CH,CH
       ADD     CX,1900
       MOV     AH,2Bh
       INT     21h
       RET

; =======================================

PUBLIC CmfBeg
CmfBeg:
INCLUDE SONG.INC
PUBLIC AdlBeg
AdlBeg:
INCLUDE ADLIB.INC
PUBLIC AdlEnd
AdlEnd:
INCLUDE MPU.INC
PUBLIC MpuEnd
MpuEnd:

; 
;     Here comes the data.                                             
; 

; ----------- Non-VGA message ----------------
VgaMsg DB 'This intro requires 196Kb free and a VGA card.', 10, 13

       ; ----------- Exit message -------------------
;ByeMsg DB 'Call BlasterSound BBS! +34-58-293-583', 10, 13
;       DB 'Intro by Iguana: coded by JCAB & Jare, tune by COI.$'

ByeMsg DB 'For hearing this intro''s music you must use an OPL2 (AdLib) or ',10,13
       DB 'General Midi (MPU) device. Every sound card supports one of them.',10,10,13
       DB 'Greetings from Iguana to all our friends all over the world.',10,10,13
       DB '',10,13
       DB '                THE FINEST DEMO ORIENTED BBS IN SPAIN',10,13
       DB '',10,13
       DB '                BLASTERSOUND BBS        +34-58-293583',10,13
       DB '',10,13
       DB '   Sound Blaster Connection 14:4500/200 & 201 Hub Granada (Spain).',10,13
       DB '      Creativity Demo Net 94:620/200 & 201 Hub Granada (Spain).',10,13
       DB '              SoundNet Espaa 34:34/0 Coordinator/Host.',10,13
       DB '                          Fidonet 2:345/805',10,13
       DB '                      IGUANA  World HeadQuarters',10,13
       DB '                    VangeliSTeam Distribution Site',10,13
       DB '                        DUST Distribution Site',10,13
       DB '                 Authorized Product Support Node for',10,13
       DB '               Advanced Gravis Computer Technology Ltd.',10,13
       DB '',10,13
       DB '             Baudrate: 19k2 ZyXEL/ 24 Open/ +1 Gb On-line',10,13
       DB '',10,13,'$'

; ------------ DAC Palette -------------------
Palette LABEL BYTE
DB  0, 0, 0, 12,32,11, 20,37,20, 28,44,28, 36,51,36, 46,56,44, 52,59,52, 60,60,60
DB 63,63,63, 12,12,40, 20,20,44, 28,28,52, 36,36,56, 44,44,56, 52,52,60, 60,60,60

; ------------ Font data ---------------------

PUBLIC FontBeg
FontBeg:
INCLUDE Font.Inc
PUBLIC FontEnd
FontEnd:

FontNChars EQU $ - OFFSET FontTable

; ------------
RandSeed     DW 348Bh
RandSeed2    DW 7F34h
RandSeed3    DW 32bfh

; ------------
VGASeg       DW 0A000h

; Intro text ----------------
; Haha! It's even worse than my handwriting!

_0 = 'Z'+1
_1 = 'Z'+2
_2 = 'Z'+3
_3 = 'Z'+4
_4 = 'Z'+5
_5 = 'Z'+6
_6 = 'Z'+7
_7 = 'Z'+8
_8 = 'Z'+9
_9 = 'Z'+10

Separator EQU DB 'ggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggggg',0

IntroText LABEL BYTE
        DW 25, 115
        DB 3,'BLASTERSOUND',_9+1,'  '
        DB _9+4,_3,_4,_9+5,' ',_5,_8,_9+3,_2,_9,_3,_9+3,_5,_8,_3,0
        DW 0, 95
        Separator
        DW 0, 135
        Separator
        DW 0, 0
        Separator
        DW 0, 350
        Separator
        DW 11, 34
        DB 'THE FINEST DEMO ORIENTED BBS',0
        DW 230, 60
        DB 'IN SPAIN'
        DB 3,0
LoopText LABEL BYTE
        DW 30, 165
        DB 'IGUANA WORLD HEADQUARTERS',0
        DW 50, 205
        DB 'VANGELISTEAM DISTRO SITE',0
        DW 80, 245
        DB 'DUST DISTRIBUTION SITE',0
        DW 44, 285
        DB 'PRODUCT SUPPORT NODE FOR',0
        DW 90, 315
        DB 'ADVANCED GRAVIS LTDk',10,0
        DW TCCLEAR
        DW 0, 165
        DB 'SOUNDNET   ',_3,_4,_9+6,_3,_4,_9+2,_0,0
        DW 0, 215
        DB 'SBCNET       ',_1,_4,_9+6,_4,_5,_0,_0,_9+2,_2,_0,_0,0
        DW 0, 265
        DB 'CDNET        ',_9,_4,_9+6,_6,_2,_0,_9+2,_2,_0,_0,0
        DW 0, 315
        DB 'FIDONET       ',_2,_9+6,_3,_4,_5,_9+2,_8,_0,_5,10,0
        DW TCCLEAR
        DW 200, 165
        DB _1,_9,_2,_0,_0,' BAUD',0
        DW 170, 205
        DB 'OPEN ',_2,_4,' HOURS',0
        DW 192, 245
        DB _1,' GB ON LINE',0
        DW 203,285
        DB 'ggggggggggggggggggggggggggggggggggggg',0
        DW 198,300
        DB 'ggggCALL NOWgggg',0
        DW 203,315
        DB 'ggggggggggggggggggggggggggggggggggggg',0

        DW 0,0
        DB 10,0
        DW TCCLEAR
        DW TCRESTART

BlasterMsg DB 'BLASTERSOUND',0

PUBLIC DataEnd
DataEnd:

; 
;     Here comes the BSS. All initialized to zero at startup           
; 

ZeroStart LABEL BYTE

TextBitmask  DB ?
TextAddr     DW ?
TextPos      DW ?
TextDelay    DW ?
TextCharData DW ?
TextWidth    DB ?

FontOffs DW FontNChars DUP (?)

FlakeCounter DW ?
MaxFlakes    DW ?
nnew         DW ?
Flakes   DB (SIZE TFLAKE)*NFLAKES DUP (?)

TimerCounter        DW ?
OldTimerHandlerOffs DW ?
OldTimerHandlerSeg  DW ?

ZeroLength EQU $-OFFSET ZeroStart

ScrOffs DW SIZEY DUP (?)

END Start

; ------------ End of BLASTER2.ASM ---------------
