/****************************************************************************
*
* VERSION
*	$VER: main.c 1.72 (30.12.93)
*
* DESCRIPTION
*	Main code for SClock...
*
* AUTHOR
*	Rune Johnsrud
*
* COPYRIGHT
*	(c) 1993 Amiga Freelancers
*
*****************************************************************************/

#define INTUI_V36_NAMES_ONLY

#include <exec/exec.h>
#include <exec/types.h>
#include <exec/memory.h>
#include <exec/alerts.h>
#include <dos/dos.h>
#include <intuition/intuition.h>
#include <graphics/modeid.h>
#include <intuition/screens.h>
#include <libraries/diskfont.h>
#include <libraries/asl.h>
#include <libraries/gadtools.h>
#include <workbench/workbench.h>
#include <devices/timer.h>
#include <utility/date.h>
#include <datatypes/datatypes.h>

#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>

#include <pragmas/intuition_pragmas.h>
#include <pragmas/graphics_pragmas.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/diskfont.h>
#include <proto/asl.h>
#include <proto/icon.h>
#include <proto/gadtools.h>
#include <proto/timer.h>
#include <proto/datatypes.h>

#include <string.h>

#include "global.h"

/************************************************************************/

char __stdiowin[] = "";
char __stdiov37[] = "";

/************************************************************************/

UBYTE versiontag[] = "$VER: SClock V1.72 (30.12.93)";

UBYTE AboutText[]  = "SClock V1.72 (30.12.93)\n\n"
					 "Written by Rune Johnsrud\n\n"
					 "(c) 1993 Amiga Freelancers";

/************************************************************************/

UBYTE *ErrMsg[] =
{
	NULL,
	NULL,
	"This program can only be started from Workbench",
	"Couldn't open intuition.library V39",
	"Couldn't open graphics.library V39",
	"Couldn't open diskfont.library V39",
	"Couldn't open asl.library V39",
	"Couldn't open gadtools.library V39",
	"Couldn't open icon.library V39",
	"Couldn't open utility.library V39",
	"Couldn't open datatypes.library V39",
	"Couldn't open timer.device",
	"Couldn't allocate asl requester",
	"Couldn't obtain datatype attrs",
	"Couldn't do datatype method",
	"Unable to start screen mode prefs notification",
	"Couldn't lock specified public screen",
	"Couldn't open window",
	"No icon arguments",
	"Couldn't read icon",
	"Couldn't write icon",
	"Couldn't open specified font",
	"Couldn't create menus",
	"Couldn't obtain visual info",
	"Window size error, truncating window",
	"Couldn't allocate memory",
	"Couldn't allocate signal",
	"Unknow error",
};

UBYTE ErrReqTitle[] 	= "Error";
UBYTE ErrReqBody[]  	= "%s, Error: %ld\n\n%s";
UBYTE ErrReqGad[]   	= "OK";
UBYTE PErrReqBody[]		= "%s, Error: %ld - %s\n";
UBYTE ReqTitle[]		= "SClock Request";
UBYTE FontReqTitle[]	= "Select New Font...";
UBYTE FileReqTitle[]	= "Select New Backdrop Picture...";

/************************************************************************/

struct Gadget ClockGadget =
{
	NULL,
	0,
	0,
	0,
	0,
	GFLG_GADGHNONE,
	GACT_IMMEDIATE,
	GTYP_SYSGADGET | GTYP_WDRAGGING,
	NULL,
	NULL,
	NULL,
	0,
	NULL,
	0,
	NULL
};

struct ClockInfo DefClockInfo =
{
	NULL,
	CT_DIGITAL,
	NULL,
	11,
	NULL,
	0,
	0,
	100,
	100,
	0,
	0,
	0,
	0,
	0,
	{
		0, 0, 0, 0, 0, 35, 35,
		50, 50, 50, 50,
		0, 0, 0, 0, 0, 0
	},
	{
		1, 0, 1, 1, 1, 2, 1
	},

//	FALSE,		/* ShowTime		*/
	TRUE,		/* ShowDate 	*/
	FALSE,		/* ShowSec		*/
	TRUE,		/* WinBevel		*/
	FALSE,		/* BDClock		*/
	FALSE,		/* LockPos		*/

	FALSE,		/* PlaceClock	*/
	FALSE,		/* ShowDial		*/
	FALSE,		/* AutoSize		*/

	1,
	3,
	2,
	1,
	".",
	":",
	0,
	2,
	4,

//	1
};

/************************************************************************/

#define MENU_ID_PROJECT		0
#define   ITEM_ID_ABOUT		0
#define	  ITEM_ID_QUIT      2
#define MENU_ID_SETTINGS	1
#define   ITEM_ID_FONT		0
#define   ITEM_ID_BACKDR	1
#define   ITEM_ID_SAVESET	3

struct NewMenu MainMenus[] =
{
	{ NM_TITLE, "Project",        0 , 0, 0, 0,},
	{  NM_ITEM, "About",         "?", 0, 0, 0,},
	{  NM_ITEM, NM_BARLABEL,      0 , 0, 0, 0,},
	{  NM_ITEM, "Quit",          "Q", 0, 0, 0,},

	{ NM_TITLE, "Settings",       0 , 0, 0, 0,},
	{  NM_ITEM, "Font...",       "F", 0, 0, 0,},
	{  NM_ITEM, "Backdrop...",   "B", 0, 0, 0,},
	{  NM_ITEM, NM_BARLABEL,      0,  0, 0, 0,},
	{  NM_ITEM, "Save Settings", "S", 0, 0, 0,},
	{  NM_END,  NULL,             0 , 0, 0, 0,},
};

/************************************************************************/

extern struct ExecBase *SysBase;
extern struct DosLibrary *DOSBase;
struct Library *IntuitionBase;
struct Library *GfxBase;
struct Library *DiskfontBase;
struct Library *AslBase;
struct Library *IconBase;
struct Library *GadToolsBase;
struct Library *TimerBase;
struct Library *UtilityBase;
struct Library *DataTypesBase;

struct GlobalData globaldata, *gd = &globaldata;
struct ClockInfo *ci = &DefClockInfo;

/************************************************************************/

void __regargs __chkabort(void);	/* Turn of SAS CTRL-C checking */

WORD InitStart(int argc, char **argv);
WORD CleanUp(VOID);
WORD DoMagic(VOID);

WORD CreateAnalogClock(VOID);
VOID RefreshAnalogClock(VOID);
WORD DeleteAnalogClock(VOID);
WORD CreateDigitalClock(VOID);
VOID RefreshDigitalClock(VOID);
WORD DeleteDigitalClock(VOID);

WORD ASL_RequestFont(VOID);
WORD ASL_RequestFile(VOID);

WORD HandleWindowEvents(VOID);
WORD HandleMenuEvents(struct IntuiMessage *imsg);


/*** Main code **********************************************************/


/**** Turn of SAS CTRL-C checking ****/
void __regargs __chkabort(void)
{
}
/*************************************/


VOID main(int argc, char **argv)
{
	if (SysBase->LibNode.lib_Version >= MIN_LIB_VER)
	{
		gd->ErrCode = InitStart(argc, argv);

		if (gd->ErrCode) 
			Error("Init Failed", gd->ErrCode);
		else
			Error("SClock", DoMagic());

		CleanUp();
	}
}


WORD InitStart(int argc, char **argv)
{
	gd->VScreen		= NULL;
	gd->ClockWindow	= NULL;

	if (argc == 0)
	{
		gd->IconArgs = (struct WBStartup *) argv;
		gd->WBStart  = TRUE;
	}
	else
	{
		gd->WBStart = FALSE;
		return INIT_ERR_NOTWBSTART;
	}

	IntuitionBase = OpenLibrary("intuition.library", MIN_LIB_VER);
	if (!IntuitionBase) return INIT_ERR_INTUITIONLIB;

	GfxBase = OpenLibrary("graphics.library", MIN_LIB_VER);
	if (!GfxBase) return INIT_ERR_GRAPHICSLIB;

	GadToolsBase = OpenLibrary("gadtools.library", MIN_LIB_VER);
	if (!GadToolsBase) return INIT_ERR_GADTOOLSLIB;

	DiskfontBase = OpenLibrary("diskfont.library", MIN_LIB_VER);
	if (!DiskfontBase) return INIT_ERR_DISKFONTLIB;

	AslBase = OpenLibrary("asl.library", MIN_LIB_VER);
	if (!AslBase) return INIT_ERR_ASLLIB;

	IconBase = OpenLibrary("icon.library", MIN_LIB_VER);
	if (!IconBase) return INIT_ERR_ICONLIB;

	UtilityBase = OpenLibrary("utility.library", MIN_LIB_VER);
	if (!UtilityBase) return INIT_ERR_UTILITYLIB;

	DataTypesBase = OpenLibrary("datatypes.library", MIN_LIB_VER);
	if (!DataTypesBase) return INIT_ERR_DATATYPESLIB;

	TimerBase = NULL;

	if (!OpenTimerDevice()) return INIT_ERR_OPENDEVICE;

	gd->AslFontReq = AllocAslRequestTags(ASL_FontRequest,
						ASLFO_TitleText,	FontReqTitle,
						ASLFO_InitialWidth,	300,
						ASLFO_InitialHeight,375,
						ASLFO_MaxHeight,	127,
						TAG_END);

	if (!gd->AslFontReq) return INIT_ERR_ALLOCASLREQ;

	gd->AslFileReq = AllocAslRequestTags(ASL_FileRequest,
						ASLFR_TitleText,	FileReqTitle,
						ASLFR_InitialWidth,	300,
						ASLFR_InitialHeight,375,
						ASLFR_RejectIcons,	TRUE,
						TAG_END);

	if (!gd->AslFileReq) return INIT_ERR_ALLOCASLREQ;

	InitRastPort(&gd->FakeRP);

	ci->PubScreenName = (UBYTE *) &gd->StrBuff[0];
	ci->FontName      = (UBYTE *) &gd->StrBuff[1];
	ci->BDRPic 		  = (UBYTE *) &gd->StrBuff[2];

	return NOERROR;
}


WORD CleanUp(void)
{
	DeletePrefsNotify();

	if (gd->ClockWindow)	CleanUpClock();

	if (gd->AslFileReq)		FreeAslRequest(gd->AslFileReq);
	if (gd->AslFontReq)		FreeAslRequest(gd->AslFontReq);
	if (TimerBase)			CloseTimerDevice();

	if (DiskfontBase)		CloseLibrary(DiskfontBase);
	if (GfxBase)			CloseLibrary(GfxBase);
	if (IntuitionBase)		CloseLibrary(IntuitionBase);
	if (GadToolsBase)		CloseLibrary(GadToolsBase);
	if (AslBase)			CloseLibrary(AslBase);
	if (IconBase)			CloseLibrary(IconBase);
	if (UtilityBase)		CloseLibrary(UtilityBase);
	if (DataTypesBase)		CloseLibrary(DataTypesBase);

	return NOERROR;
}


VOID Error(UBYTE *header, WORD errcode)
{
	UBYTE *p;

	if (errcode)
	{
		if (errcode == SYSERROR)
			p = gd->SysErr;
		else
			p = ErrMsg[errcode];

		if (gd->WBStart)
			EReq(gd->ClockWindow, ErrReqTitle, ErrReqBody, ErrReqGad, header, errcode, p);
		else
			Printf(PErrReqBody, header, errcode, p);
	}
}


/************************************************************************/


WORD DoMagic(void)
{
	WORD errcode = NOERROR, retval = NOACTION;

	if (errcode = ParseIconArgs(gd->IconArgs)) return errcode;
	if (errcode = CreatePrefsNotify()) return errcode;

	gd->TmpFlags = ci->ShowDate;

	if (errcode = CreateClock()) return errcode;

	while (!retval)
	{
		retval = HandleWindowEvents();

		switch (retval)
		{
		case ACTION_CLOSEWINDOW:
			if (errcode = CreateClock())
				retval = ACTION_QUIT;
			else
				retval = NOACTION;
			break;
		}
	}

	return errcode;
}


/*** Main handle stuff ****************************************************/


WORD HandleWindowEvents(VOID)
{
	struct IntuiMessage *imsg;
	BOOL done = FALSE;
	ULONG signals;
	WORD retval = NOACTION;

	while (!done)
	{
		signals = Wait((1L << gd->ClockWindow->UserPort->mp_SigBit) |
		    		   (1L << gd->TimerPort->mp_SigBit)             |
			 		   (1L << gd->PNSigNum));

		if (GetMsg(gd->TimerPort))
		{
			gd->TReq->tr_time.tv_secs  = 1;
			gd->TReq->tr_time.tv_micro = 0;
			SendIO((struct IORequest *) gd->TReq);
			RefreshClock();
		}

		if (signals & (1L << gd->PNSigNum))
		{
			CleanUpClock();
			Delay(150);
			CreateClock();
		}

		while ((!done) && (imsg = GT_GetIMsg(gd->ClockWindow->UserPort)))
		{
			switch (imsg->Class)
			{
			case IDCMP_MENUPICK:
				if (retval = HandleMenuEvents(imsg)) done = TRUE;
				break;
			}

			GT_ReplyIMsg(imsg);
		}
	}

	return retval;
}


WORD HandleMenuEvents(struct IntuiMessage *imsg)
{
	UWORD menucode;
	WORD retval = NOACTION;

	menucode = imsg->Code;

	while (menucode != MENUNULL)
	{
		switch (MENUNUM(menucode))
		{
		case MENU_ID_PROJECT:
			switch (ITEMNUM(menucode))
			{
			case ITEM_ID_ABOUT:
				EReq(gd->ClockWindow, ReqTitle, AboutText, "OK", NULL);
				break;

			case ITEM_ID_QUIT:
				retval = ACTION_QUIT;
				break;
			}
			break;

		case MENU_ID_SETTINGS:
			switch (ITEMNUM(menucode))
			{
			case ITEM_ID_FONT:
				switch (ASL_RequestFont())
				{
				case ASL_REQ_OK:
					retval = ACTION_CLOSEWINDOW;
					break;
				case ASL_REQ_FAILED:
					Error("Asl-Request", gd->ErrCode);
					break;
				}
				break;

			case ITEM_ID_BACKDR:
				switch (ASL_RequestFile())
				{
				case ASL_REQ_OK:
					retval = ACTION_CLOSEWINDOW;
					break;
				case ASL_REQ_FAILED:
					Error("Asl-Request", gd->ErrCode);
					break;
				}
				break;

			case ITEM_ID_SAVESET:
				Error("Save Settings", SaveCurrSettings(gd->IconArgs));
				break;
			}
			break;
		}

		menucode = (((struct MenuItem *) ItemAddress(gd->MainMenu, menucode))->NextSelect);
	}

	return retval;
}


/************************************************************************/


WORD CreateClock(VOID)
{
	WORD errcode = NOERROR;

	if (ci->LockPos) ClockGadget.GadgetType &= ~GTYP_WDRAGGING;

	if (ci->ClockType == CT_DIGITAL)
	{
		errcode = CreateDigitalClock();
	}
	else
	{
		errcode = CreateAnalogClock();
	}

	return errcode;
}



VOID RefreshClock(VOID)
{
	if (ci->ClockType == CT_DIGITAL)
	{
		RefreshDigitalClock();
	}
	else
	{
		RefreshAnalogClock();
	}
}


WORD CleanUpClock(VOID)
{
	WORD errcode = NOERROR;

	if (ci->ClockType == CT_DIGITAL)
	{
		errcode = DeleteDigitalClock();
	}
	else
	{
		errcode = DeleteAnalogClock();
	}

	return errcode;
}


/************************************************************************/


WORD ASL_RequestFont(VOID)
{
	if (AslRequestTags(gd->AslFontReq,
		ASLFO_Window,		gd->ClockWindow,
		ASLFO_SleepWindow,	TRUE,
		TAG_END))
	{
		gd->TextAttr = gd->AslFontReq->fo_Attr;
		return ASL_REQ_OK;
	}
	else
	{
		if (IoErr() == 0)
		{
			gd->ErrCode = NOERROR;
			return ASL_REQ_CANCEL;
		}
		else
		{
			gd->ErrCode = SYSERROR;
			Fault(IoErr(), NULL, gd->SysErr, 254);
			return ASL_REQ_FAILED;
		}
	}
}


WORD ASL_RequestFile(VOID)
{
	struct Hook filter;
	static UBYTE buff[512];

	filter.h_Entry = FReqFilter;

	if (AslRequestTags(gd->AslFileReq,
			ASLFR_Window,		gd->ClockWindow,
			ASLFR_SleepWindow,	TRUE,
			ASLFR_FilterFunc,	&filter,
			TAG_END))
	{
		strncpy(buff, gd->AslFileReq->fr_Drawer, sizeof(buff));
		AddPart(buff, gd->AslFileReq->fr_File, sizeof(buff));

		ci->BDRPic = (UBYTE *) &buff;
		return ASL_REQ_OK;
	}
	else
	{
		if (IoErr() == 0)
		{
			gd->ErrCode = NOERROR;
			return ASL_REQ_CANCEL;
		}
		else
		{
			gd->ErrCode = SYSERROR;
			Fault(IoErr(), NULL, gd->SysErr, 254);
			return ASL_REQ_FAILED;
		}
	}
}


BOOL InitMainMenus(VOID)
{
	if (ci->ClockType == CT_ANALOG)
	{
		MainMenus[5].nm_Flags = NM_ITEMDISABLED;
		MainMenus[6].nm_Flags = 0;
	}
	else
	{
		MainMenus[5].nm_Flags = 0;
		MainMenus[6].nm_Flags = NM_ITEMDISABLED;
	}

	gd->MainMenu = CreateMenus((struct NewMenu *) &MainMenus, TAG_END);
	if (!gd->MainMenu) return FALSE;

	if (!LayoutMenus(gd->MainMenu, gd->VisualInfo,
			GTMN_NewLookMenus, TRUE,
			TAG_END))
	{
		return FALSE;
	}

	if (!SetMenuStrip(gd->ClockWindow, gd->MainMenu))
		return FALSE;

	return TRUE;
}


LONG EReq(struct Window *w, UBYTE *title, UBYTE *bodytext, UBYTE *gadformat, APTR arg1, ...)
{
	static struct EasyStruct es;
	struct Requester req;
	LONG reqret;

	es.es_StructSize   = sizeof(struct EasyStruct);
	es.es_Flags        = 0;
	es.es_Title        = title;
	es.es_TextFormat   = bodytext;
	es.es_GadgetFormat = gadformat;

	if (w)
	{
		InitRequester(&req);

		if (Request(&req, w))
		{
			SetWindowPointer(w,
				WA_BusyPointer, TRUE,
				TAG_END);

			reqret = EasyRequestArgs(w, &es, NULL, &arg1);

			SetWindowPointer(w,
				WA_Pointer, NULL,
				TAG_END);

			EndRequest(&req, w);
		}
	}
	else
		reqret = EasyRequestArgs(NULL, &es, NULL, &arg1);

	return reqret;
}


/* End Of File */
