/****************************************************************************
*
* VERSION
*	$VER: global.h 1.71 (18.12.93)
*
* DESCRIPTION
*	Global defines/structs/prototypes...
*
* AUTHOR
*	Rune Johnsrud
*
* COPYRIGHT
*	(c) 1993 Amiga Freelancers
*
*****************************************************************************/

#define MIN_LIB_VER 39

/****************************************************************************/

#define ASM		__asm __saveds
#define REG(x)	register __ ## x

/****************************************************************************/

enum _ERR_ID
{
	NOERROR,
	SYSERROR,
	INIT_ERR_NOTWBSTART,
	INIT_ERR_INTUITIONLIB,
	INIT_ERR_GRAPHICSLIB,
	INIT_ERR_DISKFONTLIB,
	INIT_ERR_ASLLIB,
	INIT_ERR_GADTOOLSLIB,
	INIT_ERR_ICONLIB,
	INIT_ERR_UTILITYLIB,
	INIT_ERR_DATATYPESLIB,
	INIT_ERR_OPENDEVICE,
	INIT_ERR_ALLOCASLREQ,
	PN_ERR_PREFSNOTIFY,
	DT_ERR_GETATTRS,
	DT_ERR_DOMETHOD,
	GEN_ERR_LOCKSCREEN,
	GEN_ERR_OPENWINDOW,
	GEN_ERR_NOICONARGS,
	GEN_ERR_READICON,
	GEN_ERR_WRITEICON,
	GEN_ERR_OPENFONT,
	GEN_ERR_MENUS,
	GEN_ERR_GETVISUALINFO,
	GEN_ERR_WINSIZE,
	GEN_ERR_ALLOCMEM,
	GEN_ERR_ALLOCSIGNAL,
	ERR_UNKNOWN,
};

enum _ASL_RETVAL
{
	ASL_REQ_OK,
	ASL_REQ_CANCEL,
	ASL_REQ_FAILED,
};

enum _IDCMP_ACTION
{
	NOACTION,
	ACTION_CLOSEWINDOW,
	ACTION_QUIT,
};

/****************************************************************************/

struct GlobalData
{
	struct Screen   		*VScreen;
	struct Window			*ClockWindow;
	struct Gadget			*ClockGadget;
	struct RastPort			FakeRP;
	struct RastPort			FillRP;
	struct RastPort			SaveRP;
	struct BitMap			*SaveBM;
	struct TextAttr 		TextAttr;
	struct TextFont			*TextFont;
	struct VisualInfo		*VisualInfo;
	struct Menu				*MainMenu;
	struct FontRequester	*AslFontReq;
	struct FileRequester	*AslFileReq;
	struct WBStartup		*IconArgs;

	struct MsgPort			*TimerPort;
	struct ClockData		CData;
	struct timerequest		*TReq;
	struct timeval			TVal;

	struct NotifyRequest	*NReq;
	LONG					PNSigNum;

	UBYTE	StrBuff[3][512];
	UBYTE	DateStr[20];
	UBYTE	TimeStr[20];

	BOOL	NewDate;
	BOOL	NewTime;
	BOOL	NewMin;
	BOOL	NewHour;
	BOOL	TmpFlags;

	BOOL	WBStart;
	WORD	ErrCode;
	UBYTE	SysErr[255];
};

#define NUM_OF_DATEFORMATS	3	/* The real number is 4, really!! */
#define MIN_ACLOCK_WIDTH	50
#define MIN_ACLOCK_HEIGHT	50

enum _CLOCK_TYPES
{
	CT_DIGITAL,
	CT_ANALOG,
};

struct AnalogPts
{
	WORD SzX;		/* X Size	*/
	WORD SzY;		/* Y Size	*/
	WORD CtX;		/* X Center	*/
	WORD CtY;		/* Y Center	*/
	WORD Dec;		/* Size Dec */
	WORD MIXScale;
	WORD MIYScale;

	WORD ClockLeft;
	WORD ClockTop;
	WORD ClockHeight;
	WORD ClockWidth;

	WORD sx;
	WORD sy;
	WORD mx;
	WORD my;
	WORD hx;
	WORD hy;
};

struct AnalogPens
{
	UBYTE MinSmallPen;
	UBYTE MinLargePen;
	UBYTE SecPen;
	UBYTE MinPen;
	UBYTE HourPen;

	UBYTE DialPen;
	UBYTE DialOPen;
};

struct ClockInfo
{
	UBYTE	*PubScreenName;
	UBYTE	ClockType;
	UBYTE	*FontName;
	WORD	FontSize;
	UBYTE	*BDRPic;
	WORD 	Top;			/* Window Y Pos */
	WORD	Left;			/* Window X Pos */
	WORD	Width;			/* User's WX	*/
	WORD	Height;			/* User's WY	*/
	UWORD   InnerTop;
	UWORD	InnerLeft;
	UWORD	InnerHeight;
	UWORD	InnerWidth;
	UWORD	TimeWidth;

	struct	AnalogPts ap;
	struct  AnalogPens apn;

/* Global flags ********/

//	BOOL	ShowTime;		/* Not yet implemented */
	BOOL 	ShowDate;
	BOOL	ShowSec;
	BOOL	WinBevel;
	BOOL	BDClock;
	BOOL	LockPos;

/* Analog Flags ********/

	BOOL	PlaceClock;
	BOOL	ShowDial;
	BOOL	AutoSize;

/***********************/

	UBYTE	TextPen;
	UBYTE	BGPen;
	UBYTE	ShinePen;
	UBYTE	ShadowPen;
	UBYTE	DateSep[2];
	UBYTE	TimeSep[2];
	UBYTE	DateFormat;
	WORD	DateSpc;
	WORD	EdgeSpace;

//	UBYTE	BevelDepth;		/* Not yet implemented */
};

/****************************************************************************/

VOID Error(UBYTE *header, WORD errcode);
LONG EReq(struct Window *w, UBYTE *title, UBYTE *bodytext, UBYTE *gadformat, APTR arg1, ...);
BOOL InitMainMenus(VOID);

WORD CreateClock(VOID);
VOID RefreshClock(VOID);
WORD CleanUpClock(VOID);

WORD ReadDTPic(BOOL render);
ULONG ASM FReqFilter(REG (a0) struct Hook *h, REG (a2) struct FileRequester *fr, REG (a1) struct AnchorPath *ap);

WORD ParseIconArgs(struct WBStartup *wbs);
WORD SaveCurrSettings(struct WBStartup *wbs);

BOOL OpenTimerDevice(VOID);
VOID CloseTimerDevice(VOID);
VOID GetCurrSysTime(VOID);

WORD CreatePrefsNotify(VOID);
WORD DeletePrefsNotify(VOID);

/* End Of File */
