


     pgmcrater(1)         AMIGA (15 October 1991)         pgmcrater(1)



     NAME
          pgmcrater - create cratered terrain by fractal forgery

     SYNOPSIS
          pgmcrater [-number n] [-height|-ysize s] [-width|-xsize s]
                    [-gamma g]

     DESCRIPTION
          pgmcrater creates a portable graymap which  mimics  cratered
          terrain.  The graymap is created by simulating the impact of
          a given number of craters with  random  position  and  size,
          then  rendering  the resulting terrain elevations based on a
          light source shining from one side of the screen.  The  size
          distribution  of  the  craters is based on a power law which
          results in many more small craters  than  large  ones.   The
          number  of  craters of a given size varies as the reciprocal
          of the area as described on pages 31 and 32 of  Peitgen  and
          Saupe[1];  cratered  bodies in the Solar System are observed
          to obey this  relationship.   The  formula  used  to  obtain
          crater   radii   governed  by  this  law  from  a  uniformly
          distributed pseudorandom  sequence  was  developed  by  Rudy
          Rucker.

          High resolution images with large numbers of  craters  often
          benefit  from  being piped through pnmsmooth.  The averaging
          performed by this process  eliminates  some  of  the  jagged
          pixels  and  lends a mellow ``telescopic image'' feel to the
          overall picture.

     OPTIONS
          -number n Causes n craters to be generated.  If  no  -number
                    specification  is  given,  50000  craters  will be
                    generated.  Don't expect to  see  them  all!   For
                    every  large crater there are many, many more tiny
                    ones which tend simply to erode the landscape.  In
                    general,  the  more  craters  you specify the more
                    realistic the result; ideally you want the  entire
                    terrain to have been extensively turned over again
                    and again by cratering.   High  resolution  images
                    containing   five   to  ten  million  craters  are
                    stunning but take quite a while to create.

          -height height
                    Sets the height of the generated image  to  height
                    pixels.  The default height is 256 pixels.

          -width width
                    Sets the width of the  generated  image  to  width
                    pixels.  The default width is 256 pixels.

          -xsize width
                    Sets the width of the  generated  image  to  width



     Page 1                                          (printed 12/9/93)






     pgmcrater(1)         AMIGA (15 October 1991)         pgmcrater(1)



                    pixels.  The default width is 256 pixels.

          -ysize height
                    Sets the height of the generated image  to  height
                    pixels.  The default height is 256 pixels.

          -gamma factor
                    The specified factor is used to gamma correct  the
                    graymap   in  the  same  manner  as  performed  by
                    pnmgamma.  The default value is 1.0, which results
                    in  a medium contrast image.  Values larger than 1
                    lighten  the  image  and  reduce  contrast,  while
                    values  less  than  1 darken the image, increasing
                    contrast.

          All flags  can  be  abbreviated  to  their  shortest  unique
          prefix.

     BUGS
          The -gamma option  isn't  really  necessary  since  you  can
          achieve  the same effect by piping the output from pgmcrater
          through pnmgamma.  However, pgmcrater performs  an  internal
          gamma  map  anyway in the process of rendering the elevation
          array into a graymap, so there's no additional  overhead  in
          allowing a user-specified gamma.

          Real craters  have  two  distinct  morphologies.   pgmcrater
          simulates  only  small  craters,  which are hemispherical in
          shape (regardless of the incidence angle  of  the  impacting
          body,  as long as the velocity is sufficiently high).  Large
          craters, such as Copernicus and Tycho on the  Moon,  have  a
          ``walled plain'' shape with a cross-section more like:
                          /\                            /\
                    _____/  \____________/\____________/  \_____
          Larger craters should really use this profile, including the
          central   peak,  and  totally  obliterate  the  pre-existing
          terrain.

     SEE ALSO
          pgm(5), pnmgamma(1), pnmsmooth(1)

          [1]  Peitgen, H.-O., and Saupe,  D.  eds.,  The  Science  Of
               Fractal Images, New York: Springer Verlag, 1988.

     AUTHOR
               John Walker
               Autodesk SA
               Avenue des Champs-Montants 14b
               CH-2074 MARIN
               Suisse/Schweiz/Svizzera/Svizra/Switzerland
               Usenet:  kelvin@Autodesk.com
               Fax:     038/33 88 15



     Page 2                                          (printed 12/9/93)






     pgmcrater(1)         AMIGA (15 October 1991)         pgmcrater(1)



               Voice:   038/33 76 33

          Permission  to  use,  copy,  modify,  and  distribute   this
          software  and  its documentation for any purpose and without
          fee  is  hereby   granted,   without   any   conditions   or
          restrictions.   This  software is provided ``as is'' without
          express or implied warranty.

          PLUGWARE! If you like this kind of stuff, you may also enjoy
          ``James Gleick's Chaos--The Software'' for MS-DOS, available
          for $59.95 from your local software store or  directly  from
          Autodesk,  Inc.,  Attn:  Science Series, 2320 Marinship Way,
          Sausalito, CA 94965, USA.  Telephone:  (800) 688-2344  toll-
          free  or,  outside  the  U.S. (415) 332-2344 Ext 4886.  Fax:
          (415) 289-4718.  ``Chaos--The  Software''  includes  a  more
          comprehensive   fractal   forgery  generator  which  creates
          three-dimensional landscapes as well as clouds and  planets,
          plus five more modules which explore other aspects of Chaos.
          The  user  guide  of  more  than  200  pages   includes   an
          introduction  by  James  Gleick and detailed explanations by
          Rudy Rucker of the mathematics and algorithms used  by  each
          program.

































     Page 3                                          (printed 12/9/93)



