This file is an attempt to give some basic guide lines for those
who wish to write new Netpbm filters. Since Netpbm is intended to
be portable to many platforms, it is absolutely necessary to stick
to these when programming. Most of these rules were set up by Jef
Poskanzer when he wrote Pbmplus, though some have come up more
recently.

* Your new filter must belong to one of the four Netpbm formats,
  i.e. pbm, pgm, ppm or pnm. They are defined as follows:
  pbm: Bitmaps only, i.e. a pixel is either black or white.
  pgm: Gray scales, i.e. a pixel can have any value between black
       and white, but no colours.
  ppm: Colour images. Note that Netpbm does not support the use of
       look up tables.
  pnm: A facility able to create or read more than one of the formats
       above. Note that all pgm filters can automatically read pbm
       images, and that all ppm filters can automatically read both
       pbm and pgm files. A pnm utility does more than this, its action
       depends on the type of the input file. E.g. the pnmtotiff utility
       creates a bitmap TIFF file when it reads a pbm file on its input,
       a gray scale TIFF files when it reads a pgm file on its input, etc.
       ppmtogif on the other hand treats a pbm file on its input exactly
       as if it were a ppm file with only the colours black and white.
  Decide which one of these formats your filter belongs to.

* If you want to use global variables or global functions in your filter,
  make them static, so that they won't cause problems to other filters
  when you compile a merged binary (see the Makefile).

* So far, all filters are written in K&R style C, but with prototypes
  for both K&R C and ANSI C. The ARGS macro (defined in pbmplus.h) helps
  you to write prototypes. You can use it like this:
  int my_function ARGS((int a, double b, char c));

* Include pbm.h, pgm.h, ppm.h, or pnm.h (only one of them!). Don't include
  files like stdio.h, stdlib.h etc. These should be included through
  pbmplus.h, which in turn is included by p?m.h (i.e. pbm.h, pgm.h, ppm.h,
  or pnm.h). You may need to include math.h though.

* Declare main as: int main(argc, argv), not void! VMS won't compile
  void main().

* Always start the code in main() with a call to p?m_init().

* All input and output of pbm format files must go through the library
  routines. This ensures compatibility, error checking, correct byte
  order etc.

* Use pm_error() and pm_message() for error messages and other messages.

* Don't forget to write a proper manual page!

The easiest way to write your own facility, is to take an existing one,
similar to the want you want to write, and to modify it. This saves a
lot of time, and ensures conformity with the rules stated above.

Oliver Trepte, November 15th, 1993
oliver@fysik4.kth.se
