/******************* ( Animation Construction Kit 3D ) ***********************/
/*			    Wrapup Routines				     */
/* CopyRight (c) 1993	   Author: Lary Myers				     */
/*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <mem.h>
#include <alloc.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <sys\stat.h>
#include "ack3d.h"
#include "ackeng.h"
#include "ackext.h"
#include "xmslib.h"

/****************************************************************************
** This routine **MUST** be called by the application prior to exiting to  **
** allow XMS memory to be returned to the system. Failure to do so will	   **
** cause the XMS memory to become unavailable to other applications.	   **
**									   **
****************************************************************************/
int AckWrapUp(ACKENG *ae)
{

free(LongTanTable);
free(LongInvTanTable);
free(CosTable);
free(SinTable);
free(InvSinTable);
free(InvCosTable);
free(LongCosTable);
free(xNextTable);
free(yNextTable);
free(ViewCosTable);
free(AdjustTable);

if (ae->OverlayBuffer != NULL)
    free(ae->OverlayBuffer);
ae->OverlayBuffer = NULL;

if (ae->BkgdBuffer != NULL)
    free(ae->BkgdBuffer);
ae->BkgdBuffer = NULL;

if (ae->ScreenBuffer != NULL)
    free(ae->ScreenBuffer);
ae->ScreenBuffer = NULL;

#if USE_XMS
    if (UseXMS)
	XMSclose();
#endif

return(0);
}

