 DEFINT A-Z
 '============================= MLIBSAM5.BAS ================================
 '             Copyright (C) 1994 Terry Venn. All rights reserved.
 '
 '                  THIS SAMPLE PROGRAM IS PROVIDED AS IS.
 '
 ' You may modify/use this code in any way you wish, provided that you agree
 ' that Terry Venn has no warranties, obligations or liabilities for any code
 ' contained in this sample program.
 '
 ' This sample program shows how to display a menu (using SCREEN 9) offering
 ' multiple items to choose from. MLIB's standard routines provide mouse
 ' support. For simplicity reasons, error trapping is not included.
 '
 ' QB refers to: QuickBasic 4.5
 ' VBDOS refers to: Visual Basic for DOS
 '
 ' To run this sample program from inside the QB environment, start the QB
 ' editor by typing: QB/L MLIBN
 '
 ' To run this sample program from inside the VBDOS environment, start the
 ' editor by typing: VBDOS/L MLIBF
 '
 ' QuickBasic and Visual Basic are trademarks of Microsoft Corporation.
 '===========================================================================

 ' $INCLUDE: 'MLIB.BI'
 DECLARE SUB BackGround ()
 DECLARE SUB KeyBoardCheck (Kbd$, ChosenItem%)
 DECLARE SUB ShowMenu (Row%, Col%)
 DECLARE SUB PrintMenuItems ()
 DECLARE SUB MoveBar (LastItem%, NewItem)
 DECLARE SUB MouseLoop ()
 DECLARE SUB MouseCheck (NewItem)
 DECLARE FUNCTION MouseOnItem% (X%)
 TYPE MType
      x1        AS INTEGER
      y1        AS INTEGER
      x2        AS INTEGER
      y2        AS INTEGER
      R         AS INTEGER
      C         AS INTEGER
 END TYPE
 CONST TRUE = -1, FALSE = 0
 COMMON SHARED /Menu/ M()             AS MType    ' Menu control array.
 COMMON SHARED /Menu/ MenuItem()      AS STRING   ' Menu item array.
 COMMON SHARED /Menu/ MinItem         AS INTEGER  ' First menu item.
 COMMON SHARED /Menu/ MaxItem         AS INTEGER  ' Last menu item.
 COMMON SHARED /Menu/ LongestMenuItem AS INTEGER  ' Longest item in array.
 COMMON SHARED /Menu/ LastItem        AS INTEGER  ' Last item highlighted.
 COMMON SHARED /Menu/ NewItem         AS INTEGER  ' New item to highlight.
 COMMON SHARED /Menu/ CharacterHeight AS INTEGER  ' Height of current char.
 COMMON SHARED /Menu/ CharacterWidth  AS INTEGER  ' Width of current char.
 COMMON SHARED /Menu/ HighLightColor  AS INTEGER  ' Selected item outline.
 COMMON SHARED /Menu/ OutLineColor    AS INTEGER  ' Normal outline color.

 SCREEN 9
 
 ' Ask BIOS for character info.
 DEF SEG = &H40
 CharacterHeight = PEEK(&H85)
 CharacterWidth = 8
 DEF SEG

 ' Initialize MLIB plus the mouse driver, and place pointer at 0 X 0.
 CLS : CALL InitPointer(IsMouse%): CALL ARROW0: CALL SetPointer(0, 0)
 CALL BackGround
 COLOR 15, 0
 VIEW PRINT
 LOCATE 1, 26: PRINT "MLIB: Mouse Library Menu Demo"
 LOCATE 24, 1: PRINT "<Arrow Keys=Scroll Menu Items> <Enter or Click=Choose Menu Item> <Esc=Quit Demo>"
 LOCATE 19, 7: PRINT "You have chosen:"
 COLOR 14, 0
 CALL ShowPointer

 ' Define the items that will appear on the menu.
 TotalItem% = 6   ' Total number of menu items.

 REDIM MenuItem(1 TO TotalItem%) AS STRING ' Array to hold menu items.

 MenuItem(1) = "           Menu Item  #1           "
 MenuItem(2) = "           Menu Item  #2           "
 MenuItem(3) = "           Menu Item  #3           "
 MenuItem(4) = "           Menu Item  #4           "
 MenuItem(5) = "           Menu Item  #5           "
 MenuItem(6) = "           Quit Demo               "

 ' Upper left corner of menu.
 Row% = 6: Col% = 23

 ' Outline color of each selection.
 OutLineColor = 9

 ' Highlight color of selected item.
 HighLightColor = 12

 ' Show menu selection.
 CALL ShowMenu(Row%, Col%)
 
 ' Mouse and keyboard code...
 DO
    DO ' Loop until a mouse button or a key is pressed.
       CALL GetButtonM(MousePress%, X%, Y%)
       KeyPress$ = INKEY$
    LOOP UNTIL MousePress% AND 1 OR LEN(KeyPress$)
   
    ' Clear chosen item.
    CALL HidePointer: LOCATE 19, 23: PRINT SPACE$(LEN(MenuItem(MinItem))): ShowPointer

    ' Check for a mouse event first.
    IF MousePress% AND 1 THEN
       CALL MouseCheck(ChosenItem%)
    END IF

    ' Check for a key press.
    IF KeyPress$ <> "" THEN
       CALL KeyBoardCheck(KeyPress$, ChosenItem%)
    END IF

    IF ChosenItem% THEN
       ReturnedItem$ = LTRIM$(RTRIM$(MenuItem(ChosenItem%)))
       SELECT CASE ReturnedItem$
          CASE "Menu Item  #1"
          CASE "Menu Item  #2"
          CASE "Menu Item  #3"
          CASE "Menu Item  #4"
          CASE "Menu Item  #5"
          CASE "Quit Demo": EXIT DO
       END SELECT
       ' Update chosen item.
       CALL HidePointer: LOCATE 19, 23: PRINT MenuItem(ChosenItem%): ShowPointer
    ELSE
       ReturnedItem$ = ""
    END IF
 
 LOOP UNTIL KeyPress$ = CHR$(27)

 ' We done...
 CALL HidePointer
 SCREEN 0, 0, 0
 COLOR 7, 0
 CLS
 END

'
' Doodle a background pic.
'
SUB BackGround
 FOR X% = 1 TO 640 STEP 4
    LINE (1, 1)-(X%, 350), 1
    LINE (1, 1)-(X% + 1, 350), 8
    LINE (640, 350)-(X%, 1), 1
    LINE (640, 350)-(X% + 1, 1), 8
 NEXT X%
END SUB

'
' Keyboard support for menu.
'
' Scroll selection (highlight) bar using the arrow keys.
'
' ChosenItem% - returns the chosen item's element value.
'
SUB KeyBoardCheck (Kbd$, ChosenItem%)

 ChosenItem% = FALSE

 SELECT CASE Kbd$
    
     CASE CHR$(0) + "H", CHR$(0) + "K"  ' Up and right arrow.
        NewItem = LastItem - 1
        ChangeBar% = TRUE
    
     CASE CHR$(0) + "P", CHR$(0) + "M"  ' Down and left arrow.
        NewItem = LastItem + 1
        ChangeBar% = TRUE

     CASE CHR$(0) + "G", CHR$(0) + "I"  ' Home and page up.
        NewItem = MinItem
        ChangeBar% = TRUE
    
     CASE CHR$(0) + "O", CHR$(0) + "Q"  ' End and page down.
        NewItem = MaxItem
        ChangeBar% = TRUE

     CASE CHR$(13)                      ' Enter.
        NewItem = LastItem
       
        ' Return chosen menu item.
        ChosenItem% = NewItem
       
 END SELECT

 'Show item highlighted.
 IF ChangeBar% = TRUE THEN
    CALL MoveBar(LastItem, NewItem)
    LastItem = NewItem
 END IF
END SUB

'
' Mouse support for menu.
'
SUB MouseCheck (NewItem)

 ' Check if cursor is on a menu item.
 IF MouseOnItem(NewItem) THEN
    OnItem% = TRUE

    DO
       CALL GetButtonM(MousePress%, d1%, d2%)
       IF MouseOnItem(NewItem) THEN
          OnItem% = TRUE
       ELSE
          OnItem% = FALSE
       END IF

       'Show item highlighted.
       IF OnItem% = TRUE AND LastItem <> NewItem THEN
          CALL MoveBar(LastItem, NewItem)
          LastItem = NewItem
       END IF
    
       IF NOT MousePress% AND 1 THEN   'This menu item has been chosen,
          EXIT SUB               'NewItem - returns the item's element value.
       END IF
      
       OnItem% = FALSE
      
       A$ = INKEY$ ' Clear keyboard.

    LOOP WHILE MousePress% AND 1
 END IF

 'We checked the entire array, no match of cursor to menu item.
 NewItem = FALSE
  
 ' Mouse was pressed off the menu, loop while mouse button is down.
 CALL MouseLoop

END SUB

'
' Loop while mouse button is down.
'
SUB MouseLoop
 DO ' Check for mouse event.
    CALL GetButtonM(MousePress%, D%, D%)
    A$ = INKEY$ ' Clear keyboard.
 LOOP WHILE MousePress%
END SUB

'
' Check if pointer is on a menu item.
'
' X% - Returns element value.
'
FUNCTION MouseOnItem (X%)

 FOR X% = MinItem TO MaxItem
    IF InWinM(M(X%).x1, M(X%).y1, M(X%).x2, M(X%).y2) THEN
      MouseOnItem = TRUE
      EXIT FUNCTION
    END IF
 NEXT X%

 ' No match found.
 X% = FALSE

 MouseOnItem = FALSE

END FUNCTION

'
' Highlights a selected menu item.
'
SUB MoveBar (LastItem, NewItem)

 ' *** Keep pointers within range. ***
                                               ' Un-REM these two IF - THENs
 ' Selection bar stops at top and bottom.      ' to stop selection bar from
 'IF NewItem > MaxItem THEN NewItem = MaxItem  ' continuously looping. Make
 'IF NewItem < MinItem THEN NewItem = MinItem  ' sure the next two IF - THENs
                                               ' are REM-ed.
 '' Selection bar moves continuously.
 IF NewItem > MaxItem THEN NewItem = MinItem
 IF NewItem < MinItem THEN NewItem = MaxItem
 ' ***********************************

 IF LastItem <> NewItem THEN
   
    CALL HidePointer
   
    ' Turn off highlight on the last selected menu item.
    LINE (M(LastItem).x1, M(LastItem).y1)-(M(LastItem).x2, M(LastItem).y2), OutLineColor, B
    LINE (M(LastItem).x1 - 1, M(LastItem).y1 - 1)-(M(LastItem).x2 + 1, M(LastItem).y2 + 1), OutLineColor, B

    ' Highlight new selected menu item with a brighter outline.
    LINE (M(NewItem).x1, M(NewItem).y1)-(M(NewItem).x2, M(NewItem).y2), HighLightColor, B
    LINE (M(NewItem).x1 - 1, M(NewItem).y1 - 1)-(M(NewItem).x2 + 1, M(NewItem).y2 + 1), HighLightColor, B
   
    CALL ShowPointer

  END IF

END SUB

'
' Print all menu items using the menu control array coordinates.
'
SUB PrintMenuItems
 CALL HidePointer
 ' Print menu items.
 FOR X% = MinItem TO MaxItem
    LOCATE M(X%).R, M(X%).C
    PRINT MenuItem(X%)
   
    ' Draw a box around each item.
    LINE (M(X%).x1, M(X%).y1)-(M(X%).x2, M(X%).y2), OutLineColor, B
    LINE (M(X%).x1 - 1, M(X%).y1 - 1)-(M(X%).x2 + 1, M(X%).y2 + 1), OutLineColor, B
 NEXT X%
 CALL ShowPointer
END SUB

'
' Initializes menu control array and draws menu on the screen.
'
SUB ShowMenu (Row%, Col%)

 MinItem = LBOUND(MenuItem, 1)
 MaxItem = UBOUND(MenuItem, 1)
 REDIM M(MinItem TO MaxItem)  AS MType

 ' Make sure we start at zero length.
 LongestMenuItem = 0

 ' Find the longest menu item.
 FOR X% = MinItem TO MaxItem
    NewLen% = LEN(MenuItem(X%))
    IF NewLen% > LongestMenuItem THEN
       LongestMenuItem = NewLen%
    END IF
 NEXT X%

 ' Use  copies.
 R% = Row%
 C% = Col%

 ' Initialize menu control array.
 FOR X% = MinItem TO MaxItem
    M(X%).x1 = (C% - 1) * CharacterWidth
    M(X%).y1 = (R% - 1) * CharacterHeight
    M(X%).x2 = M(X%).x1 + (CharacterWidth * LongestMenuItem)
    M(X%).y2 = M(X%).y1 + CharacterHeight
    M(X%).R = (M(X%).y1 \ CharacterHeight) + 1
    M(X%).C = (M(X%).x1 \ CharacterWidth) + 1
    R% = R% + 2 ' Print menu item on every second row.
 NEXT X%
 
 CALL HidePointer

 ' Print menu items on screen and show first selection highlighted.
 CALL PrintMenuItems
 CALL MoveBar(MaxItem, MinItem)
 LastItem = MinItem: NewItem = MinItem
 CALL ShowPointer
 
END SUB

