 DEFINT A-Z
 '============================= MLIBSAM3.BAS ================================
 '                  THIS SAMPLE PROGRAM IS PROVIDED AS IS.
 '
 ' You may modify/use this code in any way you wish, provided that you agree
 ' that Terry Venn has no warranties, obligations or liabilities for any code
 ' contained in this sample program.
 '
 ' MLIBSAM3.BAS is a sample program that demonstrates the following routines:
 '
 ' SetBoundM()      - Confine pointer movement to specified screen area.
 ' InWinM()         - Determines if pointer is in specified area.
 ' Pointer Shapes   - Show multiple pointer shapes from MLIB library.
 '
 ' QB refers to: QuickBasic 4.5
 ' VBDOS refers to: Visual Basic for DOS
 '
 ' To run this sample program from inside the QB environment, start the QB
 ' editor by typing: QB/L MLIBN
 '
 ' To run this sample program from inside the VBDOS environment, start the
 ' editor by typing: VBDOS/L MLIBF
 '
 ' QuickBasic and Visual Basic are trademarks of Microsoft Corporation.
 '===========================================================================

 ' $INCLUDE: 'MLIB.BI'                           '
                                                 '
TYPE WindowType                                  '
      x1 AS INTEGER                              '
      y1 AS INTEGER                              '
      x2 AS INTEGER                              '
      y2 AS INTEGER                              '
      wc AS INTEGER'Win color.                   '
END TYPE                                         '
                                                 '
DECLARE SUB InitWin ()                           '
DECLARE SUB CreateWin ()                         '
DECLARE SUB NumberWin ()                         '
DECLARE FUNCTION ActiveWin ()                    '
                                                 '
DIM SHARED Win(1 TO 8) AS WindowType             '
DIM SHARED WinLB%, WinUB%                        '
WinLB% = LBOUND(Win, 1)                          'Set these vars now, so we
WinUB% = UBOUND(Win, 1)                          'only make one call to get
                                                 'upper/lower boundaries.
SCREEN 12: CLS : CALL InitPointer(NumBut%)       '
IF NumBut% = 0 THEN                              '
   SCREEN 0                                      '
   PRINT "No mouse"                              '
   END                                           '
END IF                                           '
                                                 '
CALL GetSpeedM(OldH%, OldV%, OldD%)              'Save speed settings.
CALL SetSpeedM(50, 50, 50)                       'Use our own settings.
CALL SetBoundM(1, 1, 638, 110)                   'Confine pointer to area
                                                 'around windows.
CALL InitWin                                     '
CALL CreateWin                                   '
CALL NumberWin                                   '
                                                 '
LOCATE 10, 1                                     '
PRINT "Clicked in window:"                       '
                                                 '
LOCATE 28, 1                                     '
PRINT "Press any key to end..."                  '
CALL ShowPointer                                 '
                                                 '
DO                                               '
                                                 '
  DO                                             '
                                                 '
     CALL GetButtonM(But%, MX%, MY%)             'Get mouse button status
                                                 'pointer position.
     I% = ActiveWin                              '
     IF I% <> OldI% THEN                         'Check if pointer is in
        SELECT CASE I%                           'one of the windows.
           CASE 1: ARROW0                        'Call a different shape
           CASE 2: HANDV0                        'for each window.
           CASE 3: HOURGLASS0                    'These shapes were created
           CASE 4: PEN0                          'by: ME.EXE(mouse editor)
           CASE 5: MAGNIFYGLASS0                 'CVTASM.EXE(convert-assembly)
           CASE 6: PAINTCUP0                     'assembled(MASM compatible)
           CASE 7: MOUSE0                        'linked to MLIB. ME/CVTASM
           CASE 8: WATCH0                        'included in registered ver.
           CASE ELSE: ARROW1                     'Not in a window, call
        END SELECT                               'default shape.
        OldI% = I%                               '
     END IF                                      '
                                                 '
     IF LEN(INKEY$) THEN                         'Restore speed settings
        CALL SetSpeedM(OldH%, OldV%, OldD%)      'before exiting.
        SCREEN 0: END                            '
     END IF                                      '
                                                 '
  LOOP UNTIL But%                                '
                                                 '
  IF I% THEN                                     'Pointer is in a window.
     x1 = Win(I%).x1                             'do some things and stuff.
     y1 = Win(I%).y1                             '
     x2 = Win(I%).x2                             '
     y2 = Win(I%).y2                             '
     DIM Box(1 TO 1822)                          '
     HidePointer                                 '
     GET (x1, y1)-(x2, y2), Box                  '
     PUT (162, 135), Box, PSET                   '
     ShowPointer                                 '
  END IF                                         '
                                                 '
  WHILE But%                                     'Loop while button is down.
     CALL GetButtonM(But%, MX%, MY%)             '
  WEND                                           '
                                                 '
LOOP                                             '

FUNCTION ActiveWin

ActiveWin = 0 'Prove otherwise.

FOR El = WinLB% TO WinUB%                        'Check first through last
                                                 'Win(?) element, or until
                                                 'a match is made.
   x1 = Win(El).x1 'Easier to read.
   y1 = Win(El).y1
   x2 = Win(El).x2
   y2 = Win(El).y2

                                                 'NOTE! InWinM always checks
                                                 'current pointer position.
                                                 'InWinM returns -1,if inside
                                                 'defined area.
   IF InWinM(x1, y1, x2, y2) THEN                'Pointer is inside Win(?),
                                                 'return element number.
      ActiveWin = El
      EXIT FOR
     
   END IF

NEXT El

END FUNCTION

SUB CreateWin
'Draw 8 windows.

FOR Num% = LBOUND(Win, 1) TO UBOUND(Win, 1)

LINE (Win(Num%).x1, Win(Num%).y1)-(Win(Num%).x2, Win(Num%).y2), Win(Num%).wc, B
LINE (Win(Num%).x1 + 2, Win(Num%).y1 + 2)-(Win(Num%).x2 - 2, Win(Num%).y2 - 2), Win(Num%).wc, BF

NEXT Num%

END SUB

SUB InitWin
'Initialize Win() array.

Y = 0

FOR X = 1 TO 640 STEP 80
  
   Y = Y + 1
  
   Win(Y).x1 = X
   Win(Y).y1 = 10
   Win(Y).x2 = X + 72
   Win(Y).y2 = 100
   Win(Y).wc = Y   'win color.

NEXT

END SUB

SUB NumberWin
'Number each window.

FOR X = 1 TO 80 STEP 10

   LOCATE 2, X + 3
   PRINT X \ 10 + 1

NEXT

END SUB

