VERSION 2.00
Begin Form RegDemo 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Registration Demo"
   ClientHeight    =   4155
   ClientLeft      =   1305
   ClientTop       =   1455
   ClientWidth     =   4530
   Height          =   4560
   Icon            =   REGDEMO.FRX:0000
   Left            =   1245
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4155
   ScaleWidth      =   4530
   Top             =   1110
   Width           =   4650
   Begin CommandButton CommandCancel 
      BackColor       =   &H00C0C0C0&
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   330
      Left            =   3630
      TabIndex        =   10
      Top             =   3660
      Width           =   765
   End
   Begin TextBox TextVersion 
      Height          =   285
      Left            =   120
      MaxLength       =   5
      TabIndex        =   2
      Text            =   "1.00"
      Top             =   870
      Width           =   4275
   End
   Begin TextBox TextBusiness 
      Height          =   285
      Left            =   120
      MaxLength       =   40
      TabIndex        =   1
      Text            =   "Your Business Name"
      Top             =   510
      Width           =   4275
   End
   Begin TextBox TextPerson 
      Height          =   285
      Left            =   120
      MaxLength       =   40
      TabIndex        =   0
      Text            =   "Your Name"
      Top             =   150
      Width           =   4275
   End
   Begin CommandButton CommandReadLicence 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Read &Licence"
      Height          =   330
      Left            =   1170
      TabIndex        =   5
      Top             =   3660
      Width           =   1890
   End
   Begin CommandButton CommandRegister 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Register User"
      Height          =   330
      Left            =   1170
      TabIndex        =   3
      Top             =   1260
      Width           =   1875
   End
   Begin CommandButton CommandReadSerial 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Read &Serial Number"
      Height          =   330
      Left            =   1170
      TabIndex        =   4
      Top             =   2130
      Width           =   1890
   End
   Begin Label LabelVersion 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   120
      TabIndex        =   9
      Top             =   3300
      Width           =   4275
   End
   Begin Label LabelBusiness 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   2970
      Width           =   4275
   End
   Begin Label LabelPerson 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   2640
      Width           =   4275
   End
   Begin Label LabelSerial 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   1770
      Width           =   4275
   End
End
'******************************************************
'*                                                    *
'*   Copyright Sotidi SoftWare, 1994                 *
'*                                                    *
'******************************************************
Option Explicit
Declare Function Register% Lib "Licence.Dll" (ByVal PersonName$, ByVal Business$, ByVal VersionNum$)
Declare Function GetSerial% Lib "Licence.Dll" (ByVal SerialNum$)
Declare Function GetLicence% Lib "Licence.Dll" (ByVal PersonName$, ByVal Business$, ByVal VersionNum$)
Dim PerName$, BusName$, AppVer$, SerNum$, NewLine$
Dim RetVal%
Dim TopColour%, BotColour%

Sub CommandCancel_Click ()

    Unload Me

End Sub

Sub CommandReadLicence_Click ()
On Error GoTo LicenceError

    PerName$ = Space$(40)
    BusName$ = Space$(40)
    AppVer$ = Space$(5)
    ' Return the Registered User's details and Version
    RetVal% = GetLicence(PerName$, BusName$, AppVer$)
    If RetVal% = False Then
        MsgBox "Licence not Registered.", 16, "Read Licence"
        CommandRegister.Enabled = False
    Else
        LabelPerson.Caption = Trim$(PerName$)
        LabelBusiness.Caption = Trim$(BusName$)
        LabelVersion.Caption = Trim$(AppVer$)
    End If

LicenceError:
    If Err > 0 Then
        MsgBox Error$(Err) & ".", 48, "Read Licence"
        Resume Next
    End If

End Sub

Sub CommandReadSerial_Click ()
On Error GoTo SerialError

    SerNum$ = Space$(30)
    ' Return the Serial Number
    RetVal% = GetSerial(SerNum$)
    If RetVal% = False Then
        ' The Developer didn't to Initialise Licence.Dll
        ' with any data!
        LabelSerial.Caption = Trim$(SerNum$)
        MsgBox "WARNING... This copy is not Serialised.", 16, "Read Serial Number"
    Else
        LabelSerial.Caption = Trim$(SerNum$)
    End If

SerialError:
    If Err > 0 Then
        MsgBox Error$(Err) & ".", 48, "Read Serial Number"
        Resume Next
    End If

End Sub

Sub CommandRegister_Click ()
On Error GoTo RegisterError

    PerName$ = TextPerson.Text
    BusName$ = TextBusiness.Text
    AppVer$ = TextVersion.Text
    ' Register the User's details and Version
    RetVal% = Register(PerName$, BusName$, AppVer$)
    If RetVal% = False Then
        MsgBox "Unable to Register 'Licence.Dll'.", 16, "Register"
    Else
        CommandReadLicence.Enabled = True
    End If

RegisterError:
    If Err > 0 Then
        MsgBox Error$(Err) & ".", 48, "Register"
        Resume Next
    End If

End Sub

Sub Form_Load ()
On Error GoTo LoadError

    NewLine$ = Chr$(13) & Chr$(10)
    Screen.MousePointer = 11
    Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
    SerNum$ = Space$(30)
    ' Check if Licence.DLL has been Serialised
    RetVal% = GetSerial(SerNum$)
    If RetVal% = False Then
        ' This copy has not been Serialised so 'End'
        ' Trim$(SerNum$) will return "NO SERIAL NUMBER"
        Screen.MousePointer = 0
        MsgBox "WARNING... 'Licence.Dll' has not been Serialised!", 16, "Read Serial Number"
        End
    Else
        PerName$ = Space$(40)
        BusName$ = Space$(40)
        AppVer$ = Space$(5)
        RetVal% = GetLicence(PerName$, BusName$, AppVer$)
        ' Check if Licence.Dll is already Registered
        If RetVal% = False Then
            ' It's not Registered, so not previously used
            CommandReadLicence.Enabled = False
        Else
            ' It is Registered, so give the User's details
            MsgBox "This is Version '" & Trim$(AppVer$) & "' and Registered to:-" & NewLine$ & NewLine$ & Trim$(PerName$) & NewLine$ & Trim$(BusName$) & NewLine$ & NewLine$ & "The Serial Number is:-" & NewLine$ & Trim$(SerNum$), 64, "User Licence Details"
            CommandRegister.Enabled = False
        End If
    End If
    Screen.MousePointer = 0

LoadError:
    If Err > 0 Then
        MsgBox Error$(Err) & ".", 48, "Registration Demo"
        Resume Next
    End If

End Sub

Sub Form_Paint ()

    Make3DForm Me, 1
    Make3D LabelPerson, 0
    Make3D LabelBusiness, 0
    Make3D LabelVersion, 0
    Make3D LabelSerial, 0
    Make3D TextPerson, 0
    Make3D TextBusiness, 0
    Make3D TextVersion, 0

End Sub

Sub Form_Resize ()

    Make3DForm Me, 1
    Make3D LabelPerson, 0
    Make3D LabelBusiness, 0
    Make3D LabelVersion, 0
    Make3D LabelSerial, 0
    Make3D TextPerson, 0
    Make3D TextBusiness, 0
    Make3D TextVersion, 0

End Sub

Sub Form_Unload (Cancel As Integer)

    End

End Sub

Sub Make3D (Ctl As Control, Mode As Integer)

    If Mode = 1 Then
        TopColour% = 15
        BotColour% = 8
    Else
        TopColour% = 8
        BotColour% = 15
    End If
    Ctl.Parent.Line (Ctl.Left - 15, Ctl.Top - 15)-(Ctl.Left + Ctl.Width + 15, Ctl.Top - 15), QBColor(TopColour%)'Top
    Ctl.Parent.Line (Ctl.Left - 15, Ctl.Top - 15)-(Ctl.Left - 15, Ctl.Top + Ctl.Height + 15), QBColor(TopColour%) 'Left
    Ctl.Parent.Line (Ctl.Left, Ctl.Top + Ctl.Height)-(Ctl.Left + Ctl.Width + 15, Ctl.Top + Ctl.Height), QBColor(BotColour%)  'Bottom
    Ctl.Parent.Line (Ctl.Left + Ctl.Width, Ctl.Top)-(Ctl.Left + Ctl.Width, Ctl.Top + Ctl.Height), QBColor(BotColour%)  'Right

End Sub

Sub Make3DForm (Frm As Form, Mode As Integer)

    If Mode = 1 Then
        TopColour% = 15
        BotColour% = 8
    Else
        TopColour% = 8
        BotColour% = 15
    End If
    Frm.Line (0, 0)-(Frm.ScaleWidth - 15, 0), QBColor(TopColour%)  'Top
    Frm.Line (0, 0)-(0, Frm.ScaleHeight - 15), QBColor(TopColour%) 'Left
    Frm.Line (0, Frm.ScaleHeight - 15)-(Frm.ScaleWidth - 0, Frm.ScaleHeight - 15), QBColor(BotColour%)  'Bottom
    Frm.Line (Frm.ScaleWidth - 15, 0)-(Frm.ScaleWidth - 15, Frm.ScaleHeight - 0), QBColor(BotColour%)   'Right

End Sub

Sub TextBusiness_GotFocus ()

    TextBusiness.SelStart = 0
    TextBusiness.SelLength = Len(TextBusiness.Text)

End Sub

Sub TextBusiness_LostFocus ()

    If Trim$(TextBusiness.Text) = "" Then
        ' Force the User to enter a Business Name
        Beep
        TextBusiness.Text = "Your Business Name"
        TextBusiness.SetFocus
    Else
        TextBusiness.Text = Trim$(TextBusiness.Text)
    End If

End Sub

Sub TextPerson_GotFocus ()

    TextPerson.SelStart = 0
    TextPerson.SelLength = Len(TextPerson.Text)

End Sub

Sub TextPerson_LostFocus ()

    If Trim$(TextPerson.Text) = "" Then
        ' Force the User to enter a Name
        Beep
        TextPerson.Text = "Your Name"
        TextPerson.SetFocus
    Else
        TextPerson.Text = Trim$(TextPerson.Text)
    End If

End Sub

Sub TextVersion_GotFocus ()

    TextVersion.SelStart = 0
    TextVersion.SelLength = Len(TextVersion.Text)

End Sub

Sub TextVersion_KeyPress (KeyAscii As Integer)

    If TextVersion.SelStart = 0 Then
        ' Restrict the first character to 0 - 9.
        If KeyAscii < 48 Or KeyAscii > 57 Then
            KeyAscii = 0
        End If
        ' Restrict remaining characters to 0 - 9, BackSpace and .
    ElseIf (KeyAscii < 48 Or KeyAscii > 57) And KeyAscii <> 8 And KeyAscii <> 46 Then
        KeyAscii = 0
    End If

End Sub

Sub TextVersion_LostFocus ()

    If TextVersion.Text = "" Then
        ' The Programmer should use a Version Number
        Beep
        TextVersion.Text = "0.00"
        TextVersion.SetFocus
    End If

End Sub

