{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application    := Basic SFX Window

	Files          := SFXWin.pas

	Units Required := MObjects and MWCC.dll

	Tabs           := 2

	Screen         := 800 * 600

	Date           := August, 1993.

	The TSFXWindow object does not support the use of standard menus (menu bars)
	or TScroller scroll bars (ws_VScroll or ws_HScroll).

	Warning - Don't overide any inherited methods (not listed here) without first consulting
	          the documentation.

***}

program SFXWin;

uses WinTypes, WinProcs, MObjects,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	AppName : PChar = 'NewSFXWindow';

type

	PNewSFXApplication = ^TNewSFXApplication;
	TNewSFXApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

	PNewSFXWindow = ^TNewSFXWindow;
	TNewSFXWindow = object(TSFXWindow)
		constructor Init(AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function  GetClassName : PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	end;

{********** TNewSFXApplication **********}

procedure TNewSFXApplication.InitMainWindow;
begin
	MainWindow := New(PNewSFXWindow, Init(nil, 'SpecialFX Window'));
end;

{********** TNewSFXWindow **********}

constructor TNewSFXWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
	TSFXWindow.Init(AParent, AName);
	Attr.Style := Attr.Style;
	Attr.X := GetSystemMetrics(sm_CXScreen) div 4;
	Attr.Y := GetSystemMetrics(sm_CYScreen) div 4;
	Attr.W := GetSystemMetrics(sm_CXScreen) div 2;
	Attr.H := GetSystemMetrics(sm_CYScreen) div 2;
end;

destructor TNewSFXWindow.Done;
begin
	TSFXWindow.Done;
end;

function TNewSFXWindow.GetClassName;
begin
	GetClassName := AppName;
end;

procedure TNewSFXWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TSFXWindow.GetWindowClass(AWndClass);
end;

procedure TNewSFXWindow.SetUpWindow;
begin
	TSFXWindow.SetUpWindow;
end;

procedure TNewSFXWindow.WMPaint (var Msg: TMessage);
begin
	TSFXWindow.WMPaint(Msg);
end;

procedure TNewSFXWindow.WMNCPaint (var Msg: TMessage);
begin
	TSFXWindow.WMNCPaint(Msg);
end;

procedure TNewSFXWindow.WMNCCalcSize (var Msg: TMessage);
begin
	TSFXWindow.WMNCCalcSize(Msg);
end;

procedure TNewSFXWindow.WMCtlColor (var Msg: TMessage);
begin
	TSFXWindow.WMCtlColor(Msg);
end;

procedure TNewSFXWindow.WMActivate (var Msg: TMessage);
begin
	TSFXWindow.WMActivate(Msg);
end;

procedure TNewSFXWindow.WMNCActivate (var Msg: TMessage);
begin
	TSFXWindow.WMNCActivate(Msg);
end;

procedure TNewSFXWindow.WMActivateApp (var Msg: TMessage);
begin
	TSFXWindow.WMNCActivate(Msg);
end;

procedure TNewSFXWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	TSFXWindow.WMGetMinMaxInfo(Msg);
end;

{********** Main program **********}

var
	SFXApp: TNewSFXApplication;
begin

	SFXApp.Init(AppName);
	SFXApp.Run;
	SFXApp.Done;
end.
