{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application := Winmenu 3D Ownerdraw Menu Demonstration

	Files       := Winmenu.exe, Winmenu.pas, Winmenu.res

	Requires    := MObjects, MMsgBox and MWCC.dll

	Purpose     := Winmenu shows you how to,

								 1. Set up a 3D Menu bar using TMWCCButtons and popup menus.

								 2. Use CreatePopupMenu and TrackPopupMenu.

								 3. Create ownerdraw popup menus using wm_DrawItem and wm_MenuChar.

								 4. Use the wh_Keyboard Hook from HotKey1 example.

								 4. Use some of the objects and custom controls
										in the MWCC unit and library.

								 5. Use the SFXMsgBox and MWCCMsgBox functions instead of
										the Windows API MessageBox function.

	Tabs        := 2

	Screen      := 800 * 600

	Date        := August 1993.

{*** About TMWCCWindow

	The TMWCCWindow object works differently depending on how you set it up. One of the main
	things you should be aware of is the way it uses normal menus and ws_VScroll and ws_HScroll
	scroll bars. This is only of concern if you give your window an SFX style frame by setting
	SFXFrame := True in the constructor.

	The TMWCCWindow and TMWCCDlgWindow objects intercept the wm_NCPaint message to paint their
	frame and title bar. After painting, if you pass the message along to DefWndProc it then
	draws the normal frame as well. What you would see when you ran the program would be a
	quick flash of normal frame colour before my NCPaint routine paints the SFX style frame.
	It is reasonably fast and most noticeable when you resize the window. This is how the
	Microsoft Ctl3d.dll paints its frames. It just paints over the existing colours.

	Well, I wasn't satisfied with that. I don't like seeing flashing colours. The
	only alternative was to draw the non-client area myself(What a pain!!!). It was easy to
	draw the frame and the title	bar but I couldn't get the menu bar or scroll bars to
	display properly. If your window doesn't use menu's or scroll bars then its Ok.
	You don't pass the wm_NCPaint message onto DefWndProc, you draw the frame yourself and you
	don't see any flashing colours. Unfortunaletly, most windows need atleast a menu and
	often a scroll bar.

	My solution was to optionally pass wm_NCPaint along to DefWndProc. If the Attr.Style
	includes ws_VScroll or ws_HScroll or if your window has a class menu then wm_NCPaint
	is passed to DefWndProc and the non-client area is drawn normally. If you use an
	SFX style frame it just gets drawn over the top. When your window doesn't use a class
	menu and/or doesn't have ws_VScroll or ws_HScroll in its Attr.Style field then the wm_NCPaint
	message is not get passed along to DefWndProc.

	(This is a the way SFX objects work (TSFXWindow etc) except they don't pass wm_NCPaint
	on at all. Thats why you can't use menus etc with them. If you add a menu or scroll bar
	the object destroys them before displaying the window/dialog.)

	I think its important to try and give your program classy interface. Thats where 'Winmenu'
	comes in. It shows you an alternative way to institute a (3D) menu bar using buttons and
	popup menus. It also shows you whats needed to make the separate buttons and menus function
	together as a single unit like a normal menu bar. And there's more! It matches the
	design on the window, you don't see any colour flashes around the frame and it looks great!

{*** About Winmenu

	Winmenu shows you one way to set up a 3D menu bar with ownerdraw menus. I'm still working on
	refining the way the menus work so expect some improvements in future.

	Drawing ownerdraw menus is much the same as drawing ownerdraw list boxes. In this example
	I didn't worry about adding bitmap glyphs for each menu item but you can easily add them
	in same way you would	to ownerdraw list box items (see Wintask).

	I played around with several ideas for ownerdraw menus until I came up with the menus in
	Winmenu. Each menu item is drawn as a separate 3D block and uses its own 'checked' bitmap
	when checked (see Object Viewer). I didn't bother about menu separators. If you want
	separators you'll have to add them to the wm_DrawItem method yourself.	After looking at
	the way OS/2 draws its menus (and other programs) I felt it looked better to have the
	highlighted menu item a different colour. The default highlight text and background only
	look good with a bold font and I didn't want a bold font. If I use these menus as is, I will
	let the user select the highlight background and highlight text color as an option.

	I tried making the menu items look like buttons but it didn't look right because regular
	menus don't operate like buttons.

	The wm_MenuChar method method handles the menu item's keyboard mnemonic. This method is very
	important when you draw ownerdraw menus.

	The other methods like wm_Hotkey, wm_ResetMenus and the TMenuButtons are all designed to
	make the 3D menus work more like regular menus.

	I hope you find this example useful.

	Jeff...

***}

program WinMenu;

{$R WinMenu.res}

uses WinTypes, WinProcs, WinDos, Win31, Strings, MObjects, MMsgBox,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	{*** Menu Button ID's ***}
	idm_But1        						 = 201;
	idm_But2        						 = 202;
	idm_But3        						 = 203;
	idm_But4        						 = 204;
	idm_But5        						 = 205;

	{*** Window Static ID ***}
	idw_Stat1       						 = 401;

	{*** About Dialog ID's ***}
	idd_OkBut                    = 402;

	{*** Menu Item ID's ***}
	idm_Item1       						 = 701;
	idm_Item2       						 = 702;
	idm_Item3                    = 703;
	idm_Item4                    = 704;
	idm_About                    = 705;

	{*** Miscellaneous ID's ***}
	pToHotKeyHookProc : TFarProc = nil;
	wm_HotKey                    = wm_User + 76;
	wm_ResetMenus                = wm_User + 202;
	AppName : PChar              = 'WinMenu';

type

	PAboutDialog = ^TAboutDialog;
	TAboutDialog = object(TMWCCDialog)
		{***

			TMWCCBmpButton is a BWCC style bitmap button object. TMWCCStatic is a static object
			that displays either raised, recessed or normal static controls. WMDrawItem is required
			to draw the TMWCCBmpButton ownerdraw button object.

		***}
		OkBut    : PMWCCBmpButton;
		ST1, ST2 : PMWCCStatic;
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		procedure SetUpWindow; virtual;
		procedure WMDrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
	end;

	PMenuButton = ^TMenuButton;
	TMenuButton = object(TMWCCButton)
		{***

			The TMWCCButton object draws a button displaying either Text or a single Bitmap.
			MWCCButtons don't support the 'default' field. That's so you can draw recessed (etc)
			buttons without thick black borders spoiling the 3D effect.

			TMenuButton overrides the default TMWCCButton font and creates a larger font suitable
			for menus. It also sets up the wm_MouseMove mehtod to reset all the menus.

		***}
		MenuFont : HFont;
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMMouseMove (var Msg: TMessage); virtual wm_First + wm_MouseMove;
	end;

	PMenuWindow = ^TMenuWindow;
	TMenuWindow = object(TMWCCWindow)
		CheckBmp     : HBitmap;
		MenuH, Reply : Integer;
		MenuFont     : HFont;
		CRect        : TRect;
		Stat         : PMWCCStatic;
		MenuPt       : TPoint;
		But1, But2, But3, But4, But5                           : PMWCCButton;
		Menu1, Menu2, Menu3, Menu4, Menu5, SubMenu, SysMenu    : HMenu;
		ShowMenu1, ShowMenu2, ShowMenu3, ShowMenu4, ShowMenu5  : Boolean;
		constructor Init (AParent: PWindowsObject; AName, ABmp : PChar);
		destructor Done; virtual;
		function  GetClassName: PChar; virtual;
		procedure GetWindowClass (var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMSize (var Msg: TMessage); virtual wm_First + wm_Size;
		procedure WMMeasureItem (var Msg: TMessage); virtual wm_First + wm_MeasureItem;
		procedure WMDrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
		procedure WMMenuChar (var Msg: TMessage); virtual wm_First + wm_MenuChar;
		procedure WMKeyUp (var Msg: TMessage); virtual wm_First + wm_KeyUp;
		procedure WMHotKey (var Msg: TMessage); virtual wm_First + wm_Hotkey;
		procedure WMResetMenus (var Msg: TMessage); virtual wm_First + wm_ResetMenus;
		procedure WMCommand (var Msg: TMessage); virtual wm_First + wm_Command;
		procedure IDMBut1 (var Msg: TMessage); virtual id_First + idm_But1;
		procedure IDMBut2 (var Msg: TMessage); virtual id_First + idm_But2;
		procedure IDMBut3 (var Msg: TMessage); virtual id_First + idm_But3;
		procedure IDMBut4 (var Msg: TMessage); virtual id_First + idm_But4;
		procedure IDMBut5 (var Msg: TMessage); virtual id_First + idm_But5;
		procedure IDMItem1 (var Msg: TMessage); virtual cm_First + idm_Item1;
		procedure IDMItem2 (var Msg: TMessage); virtual cm_First + idm_Item2;
		procedure IDMItem3 (var Msg: TMessage); virtual cm_First + idm_Item3;
		procedure IDMItem4 (var Msg: TMessage); virtual cm_First + idm_Item4;
	end;

	PMenuApplication = ^TMenuApplication;
	TMenuApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

var

	HHotKeyHook : HHook;

{********** Task Hook's Callback function **********}

function HotKeyHookProc (nCode: Integer; wParam: Word; lParam: LongInt): LongInt; export;
{***

	When a key is pressed this callback function checks to see that the Alt (vk_Menu)
	key is down and that wParam (the pressed Key number) is within range. It it is its passed
	to the main window in the private message wm_HotKey.

	CallNexthookEx passes the message onto the next hook in the system;

***}
label
	Exit;
var
	HotKeyWnd : HWnd;
	Msg : Tmessage;
	Key : Word;
begin
	Key := wParam;
	if (nCode = hc_Action) and (wParam <> vk_Menu) and (wParam <> vk_Return) then
	begin
		{***

			This is supposed to ignore and exit if a Key is released or repeated but
			I don't think it works.

		***}
		if (lParam = $80000000) or (lParam = $40000000) then
			goto Exit;
		if (HI(GetKeyState(vk_Menu)) <> 0) and (wParam > 48) and (wParam < 73) then
		begin
			 HotKeyWnd := FindWindow('WinMenu', nil);
			 PostMessage(HotKeyWnd, wm_HotKey, wParam, 0);
		end;
	end;

	Exit:
		HotKeyHookProc := CallNextHookEx(HHotKeyHook, nCode, WParam, Longint(@LParam));
end;

{********** TMenuApplication **********}

procedure TMenuApplication.InitMainWindow;
begin
	MainWindow := New(PMenuWindow, Init(nil, 'WinMenu', 'MWCC'));
end;

{********** TMenuWindow **********}

constructor TMenuWindow.Init (AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TMWCCWindow.Init(AParent, AName, ABmp);
	{*** Set the window to a reasonable size ***}
	Attr.X := GetSystemMetrics(sm_CXScreen) div 8;
	Attr.Y := GetSystemMetrics(sm_CYScreen) div 8;
	Attr.W := (GetSystemMetrics(sm_CXScreen) div 8)*6;
	Attr.H := (GetSystemMetrics(sm_CYScreen) div 8)*5;
	{*** Initialize Buttons - Their size  and  position is set by wm_Size ***}
	But1 := New(PMenuButton, Init(@Self, idm_But1, 'Menu &1', 0, 0, 0, 0, nil, 0));
	But2 := New(PMenuButton, Init(@Self, idm_But2, 'Menu &2', 0, 0, 0, 0, nil, 0));
	But3 := New(PMenuButton, Init(@Self, idm_But3, 'Menu &3', 0, 0, 0, 0, nil, 0));
	But4 := New(PMenuButton, Init(@Self, idm_But4, 'Menu &4', 0, 0, 0, 0, nil, 0));
	But5 := New(PMenuButton, Init(@Self, idm_But5, '&Help', 0, 0, 0, 0, nil, 0));
	{*** Raised static to fill gap between menu buttons and the frame ***}
	Stat := New(PMWCCStatic, Init(@Self, idw_Stat1, '', 0, 0, 0, 0, 0, ctl_Raised, False));
	{*** MenuH is the height of menu items and depends on screen resolution ***}
	if GetSystemMetrics(sm_CYSize) = 26 then
		MenuH    := 29
	else
		MenuH    := 27;
	{*** CheckBmp is the Check bitmap used when a menu item has been checked ***}
	CheckBmp   := LoadBitmap(HInstance, 'Check');
	{*** Sets Hook handle to zero ***}
	HHotKeyHook := 0;
	{*** Setting the inherited SFXFrame field to true gives the Window an SFX style frame ***}
	SFXFrame := True;
	{***	The Showmenu fields track the display state of each menu ***}
	ShowMenu1 := True;
	ShowMenu2 := True;
	ShowMenu3 := True;
	ShowMenu4 := True;
	ShowMenu5 := True;
end;

destructor TMenuWindow.Done;
begin
	{*** Unhook the Hook before exiting ***}
	if HHotKeyHook <> 0 then
	begin
		UnhookWindowsHookEx(HHotKeyHook);
		HHotKeyHook := 0;
	end;
	{*** Destroy menu handles before exiting ***}
	if Menu1 <> 0 then DestroyMenu(Menu1);
	if Menu2 <> 0 then DestroyMenu(Menu2);
	if Menu3 <> 0 then DestroyMenu(Menu3);
	if Menu4 <> 0 then DestroyMenu(Menu4);
	if Menu5 <> 0 then DestroyMenu(Menu5);
	TMWCCWindow.Done;
end;

function TMenuWindow.GetClassName;
begin
  GetClassName := AppName;
end;

procedure TMenuWindow.GetWindowClass (var AWndClass: TWndClass);
begin
	TMWCCWindow.GetWindowClass(AWndClass);
	AWndClass.HIcon := LoadIcon(HInstance, 'WinMenu');
	{***

	This is part of the routine to stop the buttons flickering when the window is
	resized. This part just stops the client area being repainted when the window's
	resized.

	***}
	AWndClass.Style := AWndClass.Style and (not cs_VRedraw) and (not cs_HRedraw);
end;

procedure TMenuWindow.SetUpWindow;
begin
	TMWCCWindow.SetUpWindow;
	{***

		Installs the wh_Keyboard Task Hook used to trap the menu button Hot keys that
		launch the popup menus.

	***}
	if HHotKeyHook = 0 then
	begin
		pToHotKeyHookProc := TFarProc(@HotKeyHookProc);
		HHotKeyHook := SetWindowsHookEx(wh_Keyboard, THookProc(pToHotKeyHookProc),
																									HInstance, GetCurrentTask);
	end;
	{*** Modify the System menu making it ownerdraw ***}
	SysMenu := GetSystemMenu(HWindow, False);
	RemoveMenu(SysMenu, 5, mf_ByPosition);
	RemoveMenu(SysMenu, 6, mf_ByPosition);
	RemoveMenu(SysMenu, 6, mf_ByPosition);
	ModifyMenu(SysMenu, 0, mf_ByPosition or mf_OwnerDraw, sc_Restore, '&Restore');
	ModifyMenu(SysMenu, 1, mf_ByPosition or mf_OwnerDraw, sc_Move, '&Move');
	ModifyMenu(SysMenu, 2, mf_ByPosition or mf_OwnerDraw, sc_Size, '&Size');
	ModifyMenu(SysMenu, 3, mf_ByPosition or mf_OwnerDraw, sc_Minimize, 'Mi&nimize');
	ModifyMenu(SysMenu, 4, mf_ByPosition or mf_OwnerDraw, sc_Maximize, 'Ma&ximize');
	ModifyMenu(SysMenu, 5, mf_ByPosition or mf_OwnerDraw, sc_Close,
						 '&Close  Winmenu                  Alt+F4');
	{*** Create popup submenu and add ownerdraw items ***}
	SubMenu := CreatePopupMenu;
	AppendMenu(SubMenu, mf_OwnerDraw, idm_Item1, 'SubMenu Item &A');
	AppendMenu(SubMenu, mf_OwnerDraw, idm_Item2, 'SubMenu Item &B');
	AppendMenu(SubMenu, mf_OwnerDraw, idm_Item3, 'SubMenu Item &C');
	AppendMenu(SubMenu, mf_OwnerDraw, idm_Item4, 'SubMenu Item &D');
	{*** Create Menu 1 and add ownerdraw items ***}
	Menu1 := CreatePopupMenu;
	AppendMenu(Menu1, mf_OwnerDraw, idm_Item1, 'Menu Item &A');
	AppendMenu(Menu1, mf_OwnerDraw, idm_Item2, 'Menu Item &B');
	AppendMenu(Menu1, mf_OwnerDraw, idm_Item3, 'Menu Item &C');
	AppendMenu(Menu1, mf_OwnerDraw, idm_Item4, 'Menu Item &D');
	{*** Create Menu 2 and add ownerdraw items ***}
	Menu2 := CreatePopupMenu;
	AppendMenu(Menu2, mf_OwnerDraw, idm_Item1, 'Menu Item &A');
	AppendMenu(Menu2, mf_OwnerDraw, idm_Item2, 'Menu Item &B');
	AppendMenu(Menu2, mf_OwnerDraw, idm_Item3, 'Menu Item &C');
	AppendMenu(Menu2, mf_OwnerDraw or mf_Popup, SubMenu, '&SubMenu');
	{*** Create Menu 3 and add ownerdraw items ***}
	Menu3 := CreatePopupMenu;
	AppendMenu(Menu3, mf_OwnerDraw, idm_Item1, 'Menu Item &A');
	AppendMenu(Menu3, mf_OwnerDraw or mf_Popup, SubMenu, '&SubMenu');
	AppendMenu(Menu3, mf_OwnerDraw, idm_Item3, 'Menu Item &C');
	AppendMenu(Menu3, mf_OwnerDraw, idm_Item4, 'Menu Item &D');
	{*** Create Menu 4 and add ownerdraw items ***}
	Menu4 := CreatePopupMenu;
	AppendMenu(Menu4, mf_OwnerDraw, idm_Item1, 'Menu Item &A');
	AppendMenu(Menu4, mf_OwnerDraw, idm_Item2, 'Menu Item &B');
	AppendMenu(Menu4, mf_OwnerDraw or mf_Popup, SubMenu, '&SubMenu');
	AppendMenu(Menu4, mf_OwnerDraw, idm_Item4, 'Menu Item &D');
	{*** Create Menu 5 and add ownerdraw items ***}
	Menu5 := CreatePopupMenu;
	AppendMenu(Menu5, mf_OwnerDraw, idm_About, 'About WinMenu');
end;

procedure TMenuWindow.WMPaint (var Msg: TMessage);
{***

	The inherited wm_Paint method draws a raised border around the entire client area.
	Here I don't want that so I override the inherited wm_paint method by calling
	TWindow.WMPaint instead and redraw the raised border, using the  Draw3DBorder procedure,
	offsetting the border along the top just enough to squeeze the buttons and static in.
	This makes them appear recessed. The Draw3DFrame procedure is added from the inherited
	method. It ensures the window frame and caption bitmaps are drawn proprerly
	when the window first appears.

***}
var
	PaintDC : HDC;
	W, H    : Integer;
	PS      : TPaintStruct;
begin
	TWindow.WMPaint(Msg);
	GetClientRect(HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	Draw3DBorder(HWindow, 1, MenuH, W - 2, H - MenuH - 1, ctl_Raised);
	Draw3DFrame(HWindow);
end;

procedure TMenuWindow.WMSize (var Msg: TMessage);
{***

	The wm_Size message is used to postion and size the menu buttons and static and set their
	'repaint field' to false. The Static needs to be invalidated so it's displayed properly
	when the window is resized.

	The Inc function shrinks the client area rectangle to just below the button line.
	This Client area (minus the button area) is then updated everytime the window is resized.

	This is the rest of the routine that prevents the buttons from flickering everytime
	the window's client area is resized.

***}
var
	W, H : Integer;
begin
	GetClientRect(HWindow, CRect);
	with CRect do
	begin
		W := Right;
		H := Bottom;
	end;
	Inc(CRect.Top, MenuH);
	InvalidateRect(HWindow, @CRect, True);
	if not IsIconic(HWindow) then
	begin
		MoveWindow(But1^.HWindow, -1, -1, 74, MenuH, False);
		MoveWindow(But2^.HWindow, 72, -1, 74, MenuH, False);
		MoveWindow(But3^.HWindow, 145, -1, 74, MenuH, False);
		MoveWindow(But4^.HWindow, 218, -1, 74, MenuH, False);
		MoveWindow(But5^.HWindow, 291, -1, 74, MenuH, False);
		MoveWindow(Stat^.HWindow, 364, -1, W-363, MenuH, False);
		InvalidateRect(Stat^.HWindow, nil, True);
	end;
end;

procedure TMenuWindow.WMMeasureItem (var Msg: TMessage);
{*** Sets the width and height of the ownerdraw menu items ***}
begin
	with	pMeasureItemStruct(Msg.lParam)^ do
		case CtlType of
			odt_Menu:
			begin
				ItemHeight := MenuH - 2;
				ItemWidth  := 200;
			end;
		end;
end;

procedure TMenuWindow.WMDrawItem (var Msg:tMessage);
{***

	wm_DrawItem draws the menu items and works the same as for list box items
	I haven't worked out how to make bitmaps transparent so I draw around the
	checked bitmap picture so that it appears correctly.

***}
var
	MemDC              : HDC;
	OldObject          : THandle;
	Buf1, Buf2         : array[0..79] of Char;
	Brush1, Brush2, BkBrush, OldBrush  : HBrush;
	TextColor, BkColor : LongInt;
	ItemStr            : PChar;
	szTemp             : array[0..4] of Char;
	OldFont            : HFont;
	MFlags : Word;
	BM  : TBitMap;
	Bmp : HBitmap;
begin
	with PDrawItemStruct(Msg.lParam)^ do
		case CtlType of
			odt_Button:
			begin
				case CtlID of
					idm_But1 : But1^.DrawItem(Msg);
					idm_But2 : But2^.DrawItem(Msg);
					idm_But3 : But3^.DrawItem(Msg);
					idm_But4 : But4^.DrawItem(Msg);
					idm_But5 : But5^.DrawItem(Msg);
				end;
			end;
			odt_Menu:
			begin
				if ((ItemState and ods_Selected) <> 0) and (ItemId <> word (-1)) then
				begin
					Brush1 := 0;
					Brush2 := 0;
					BkColor := RGB(0, 255, 255);
					BkBrush := CreateSolidBrush(BkColor);
					TextColor := RGB(0, 0, 0);
				end
				else
				begin
					Brush1 := GetstockObject(White_Brush);
					Brush2 := GetstockObject(Gray_Brush);
					BkColor := RGB(192, 192, 192);
					BkBrush := CreateSolidBrush(BkColor);
					TextColor := RGB(0, 0, 0);
				end;
				SetBkColor(HDC, BkColor);
				SetBkMode(HDC, Transparent);
				if (ItemState and ods_Disabled <> 0) or (itemState and ods_Grayed <> 0) then
					SetTextColor(HDC, GetSysColor(Color_GrayText))
				else
					SetTextColor(HDC, TextColor);
				OldBrush := SelectObject(HDC, BkBrush);
				FillRect(HDC, rcItem, BkBrush);
				SelectObject(HDC, GetstockObject(Black_Brush));
				PatBlt(HDC, rcItem.left, rcItem.top, rcitem.right- rcitem.left, 1, PatCopy);
				if Brush1 <> 0 then
				begin
					SelectObject(HDC, Brush1);
					PatBlt(HDC, rcItem.left, rcItem.top+1, rcitem.right- rcitem.left, 1, PatCopy);
					PatBlt(HDC, rcItem.left+1, rcItem.top+2, rcitem.right- rcitem.left-2, 1, PatCopy);
					PatBlt(HDC, rcItem.left, rcItem.top+1, 1, rcitem.bottom- rcitem.top-2, PatCopy);
					PatBlt(HDC, rcItem.left+1, rcItem.top+1, 1, rcitem.bottom- rcitem.top-2, PatCopy);
					SelectObject(HDC, Brush2);
					PatBlt(HDC, rcItem.Right-1, rcItem.top+1, 1, rcitem.bottom- rcitem.top-2, PatCopy);
					PatBlt(HDC, rcItem.Right-2, rcItem.top+2, 1, rcitem.bottom- rcitem.top-4, PatCopy);
					PatBlt(HDC, rcItem.Left, rcItem.Bottom-1, rcitem.right- rcitem.left, 1, PatCopy);
					PatBlt(HDC, rcItem.Left+1, rcItem.Bottom-2, rcitem.right- rcitem.left-2, 1, PatCopy);
				end;
				if ((ItemState and ods_Checked) <> 0) and (ItemId <> word (-1)) then
				begin
					MemDC := CreateCompatibleDC(HDC);
					OldObject := SelectObject(MemDC, CheckBmp);
					BitBlt(HDC, rcItem.Left + 5, rcItem.Top + ((MenuH - 10) div 2), 9, 9, MemDC, 0, 0, SrcCopy);
					SelectObject(MemDC, OldObject);
					DeleteDC(MemDC);
					if ItemState and ods_Selected <> 0 then
					begin
						SelectObject(HDC, BkBrush);
						PatBlt(HDC, rcItem.left + 5, rcItem.Top + ((MenuH - 10) div 2), 9, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5, rcItem.Top + ((MenuH - 10) div 2) + 1, 7, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5, rcItem.Top + ((MenuH - 10) div 2) + 2, 6, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5, rcItem.Top + ((MenuH - 10) div 2) + 3, 1, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 2, rcItem.Top + ((MenuH - 10) div 2) + 3, 3, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 2, rcItem.Top + ((MenuH - 10) div 2) + 4, 2, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 2, rcItem.Top + ((MenuH - 10) div 2) + 5, 1, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 2, rcItem.Top + ((MenuH - 10) div 2) + 8, 7, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 3, rcItem.Top + ((MenuH - 10) div 2) + 7, 6, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 4, rcItem.Top + ((MenuH - 10) div 2) + 6, 5, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 5, rcItem.Top + ((MenuH - 10) div 2) + 5, 4, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 6, rcItem.Top + ((MenuH - 10) div 2) + 4, 3, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 7, rcItem.Top + ((MenuH - 10) div 2) + 3, 2, 1, PatCopy);
						PatBlt(HDC, rcItem.left + 5 + 8, rcItem.Top + ((MenuH - 10) div 2) + 2, 1, 1, PatCopy);
					end;
				end;
				SelectObject(HDC, OldBrush);
				LongInt(ItemStr) := ItemData;
				StrCopy(Buf1, #32#32#32#32#32#32);
				StrCat(Buf1, ItemStr);
				{*** I put the menu font here because I intend to let the user select their own ***}
				MenuFont := CreateFont(-13, 0, 0, 0, 400, 0, 0, 0, 0, 1, 2, 1, 34, 'MS Sans Serif');
				OldFont := SelectObject(HDC, MenuFont);
				DrawText(HDC, Buf1, -1, rcItem, DT_Left + DT_SingleLine + DT_VCenter + DT_ExpandTabs);
				SelectObject(HDC, OldFont);
				DeleteObject(BkBrush);
				DeleteObject(MenuFont);
				if Brush1 <> 0 then
				begin
					DeleteObject(Brush1);
					DeleteObject(Brush2);
				end;
			end;
		end;
end;

procedure TMenuWindow.WMMenuChar (var Msg: TMessage);
{***

	wm_MenuChar handles to keyboard hot keys for each item. Without this method the keyboard
	hot keys wont work.

	Msg.ResultLo contains the item index of the selected item when Msg.ResultHi is 2. Windows
	selects this item.

***}
var
	MFlags : Word;
begin
	if Msg.lParamLo = Msg.lParamLo or mf_SysMenu then
	begin
		case Msg.wParam of
			82, 114 :
			begin
					Msg.ResultLo := 0;
					Msg.ResultHi := 2;
			end;
			77, 109 :
			begin
					Msg.ResultLo := 1;
					Msg.ResultHi := 2;
			end;
			83, 115 :
			begin
					Msg.ResultLo := 2;
					Msg.ResultHi := 2;
			end;
			78, 110 :
			begin
					Msg.ResultLo := 3;
					Msg.ResultHi := 2;
			end;
			88, 120 :
			begin
					Msg.ResultLo := 4;
					Msg.ResultHi := 2;
			end;
			67, 99  :
			begin
					Msg.ResultLo := 5;
					Msg.ResultHi := 2;
			end;
		else
			TMWCCWindow.DefWndProc(Msg);
		end;
	end;
	if Msg.lParamHi = SubMenu then
	begin
		case Msg.wParam of
			65, 97  :
			begin
				Msg.ResultLo := 0;
				Msg.ResultHi := 2;
			end;
			66, 98  :
			begin
				Msg.ResultLo := 1;
				Msg.ResultHi := 2;
			end;
			67, 99  :
			begin
				Msg.ResultLo := 2;
				Msg.ResultHi := 2;
			end;
			68, 100 :
			begin
				Msg.ResultLo := 3;
				Msg.ResultHi := 2;
			end;
		else
			TMWCCWindow.DefWndProc(Msg);
		end;
	end
	else
	if Msg.lParamHi = Menu1 then
	begin
		case Msg.wParam of
			65, 97  :
			begin
				Msg.ResultLo := 0;
				Msg.ResultHi := 2;
			end;
			66, 98  :
			begin
				Msg.ResultLo := 1;
				Msg.ResultHi := 2;
			end;
			67, 99  :
			begin
				Msg.ResultLo := 2;
				Msg.ResultHi := 2;
			end;
			68, 100 :
			begin
				Msg.ResultLo := 3;
				Msg.ResultHi := 2;
			end;
		else
			TMWCCWindow.DefWndProc(Msg);
		end;
	end
	else
	if Msg.lParamHi = Menu2 then
	begin
		case Msg.wParam of
			65, 97  :
			begin
				Msg.ResultLo := 0;
				Msg.ResultHi := 2;
			end;
			66, 98  :
			begin
				Msg.ResultLo := 1;
				Msg.ResultHi := 2;
			end;
			67, 99  :
			begin
				Msg.ResultLo := 2;
				Msg.ResultHi := 2;
			end;
			83, 115 :
			begin
				Msg.ResultLo := 3;
				Msg.ResultHi := 2;
			end;
		else
			TMWCCWindow.DefWndProc(Msg);
		end;
	end
	else
	if Msg.lParamHi = Menu3 then
	begin
		case Msg.wParam of
			65, 97  :
			begin
				Msg.ResultLo := 0;
				Msg.ResultHi := 2;
			end;
			83, 115 :
			begin
				Msg.ResultLo := 1;
				Msg.ResultHi := 2;
			end;
			67, 99  :
			begin
				Msg.ResultLo := 2;
				Msg.ResultHi := 2;
			end;
			68, 100 :
			begin
				Msg.ResultLo := 3;
				Msg.ResultHi := 2;
			end;
		else
			TMWCCWindow.DefWndProc(Msg);
		end;
	end
	else
	if Msg.lParamHi = Menu4 then
	begin
		case Msg.wParam of
			65, 97  :
			begin
				Msg.ResultLo := 0;
				Msg.ResultHi := 2;
			end;
			66, 98  :
			begin
				Msg.ResultLo := 1;
				Msg.ResultHi := 2;
			end;
			83, 115  :
			begin
				Msg.ResultLo := 2;
				Msg.ResultHi := 2;
			end;
			68, 100 :
			begin
				Msg.ResultLo := 3;
				Msg.ResultHi := 2;
			end;
		else
			TMWCCWindow.DefWndProc(Msg);
		end;
	end;
end;

procedure TMenuWindow.WMResetMenus (var Msg: TMessage);
{***

	Used to reset the show state of a menu after it's been displayed. Helps the menus
	function like regular menus.

***}
begin
	if not ShowMenu1 then ShowMenu1 := True;
	if not ShowMenu2 then ShowMenu2 := True;
	if not ShowMenu3 then ShowMenu3 := True;
	if not ShowMenu4 then ShowMenu4 := True;
	if not ShowMenu5 then ShowMenu5 := True;
end;

procedure TMenuWindow.WMKeyUp (var Msg: TMessage);
{*** Everytime the enter key if pressed the menu state is reset. ***}
begin
	case Msg.wParam of
		13: WMResetMenus(Msg);
	else
		TMWCCWindow.DefWndProc(Msg);
	end;
end;

procedure TMenuWindow.WMHotKey (var Msg: TMessage);
{*** These are the menu button hot keys. These are 1 to 4 and H ***}
begin
	case Msg.wParam of
		49:	IDMBut1(Msg);
		50:	IDMBut2(Msg);
		51:	IDMBut3(Msg);
		52: IDMBut4(Msg);
		72: IDMBut5(Msg);
	end;
	WMResetMenus(Msg);
end;

procedure TMenuWindow.WMCommand (var Msg: TMessage);
{***

	with Msg.lParamLo = 0 the message is from a menu item.
	wm_Command is used for popup menus. Here the MWCC style about dialog is launched using
	the MWCC bitmap for the background brush. You could use 'BWCC' or nil (light grey).

***}
begin
	TMWCCWindow.WMcommand(Msg);
	if Msg.lParamLo = 0 then
	case Msg.wParam of
		idm_About: Application^.ExecDialog(New(PAboutDialog, Init(@Self, 'AboutDialog', nil)));
	end;
end;

procedure TMenuWindow.IDMBut1 (var Msg: TMessage);
{*** Popup Menu 1

		This displays popup Menu1. The showmenu states for all menus
		are reset if there've changed. This helps the menu buttons to function like a
		single menu bar.

***}
begin
	if ShowMenu1 then
	begin
		MenuPt.X := -1;
		MenuPt.Y := MenuH - 2;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu1, 0, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		WMResetMenus(Msg);
		ShowMenu1 := False;
	end
	else
		WMResetMenus(Msg);
end;

procedure TMenuWindow.IDMBut2 (var Msg: TMessage);
{*** Popup Menu 2 ***}
begin
	if ShowMenu2 then
	begin
		MenuPt.X := 72;
		MenuPt.Y := MenuH - 2;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu2, 0, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		WMResetMenus(Msg);
		ShowMenu2 := False;
	end
	else
		WMResetMenus(Msg);
end;

procedure TMenuWindow.IDMBut3(var Msg: TMessage);
{*** Popup Menu 3 ***}
begin
	if ShowMenu3 = True then
	begin
		MenuPt.X := 145;
		MenuPt.Y := MenuH - 2;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu3, 0, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		WMResetMenus(Msg);
		ShowMenu3 := False;
	end
	else
		WMResetMenus(Msg);
end;

procedure TMenuWindow.IDMBut4(var Msg: TMessage);
{*** Popup Menu 4 ***}
begin
	if ShowMenu4 = True then
	begin
		MenuPt.X := 218;
		MenuPt.Y := MenuH - 2;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu4, 0, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		WMResetMenus(Msg);
		ShowMenu4 := False;
	end
	else
		WMResetMenus(Msg);
end;

procedure TMenuWindow.IDMBut5(var Msg: TMessage);
{*** Popup Menu 5 ***}
begin
	if ShowMenu5 = True then
	begin
		MenuPt.X := 291;
		MenuPt.Y := MenuH - 2;
		ClientToScreen(HWindow, MenuPt);
		TrackPopupMenu(Menu5, 0, MenuPt.X, MenuPt.Y, 0, HWindow, nil);
		WMResetMenus(Msg);
		ShowMenu5 := False;
	end
	else
		WMResetMenus(Msg);
end;

procedure TMenuWindow.IDMItem1(var Msg: TMessage);
{***

	The menu items are used to display an assortment of message boxes.
	The SFXMsgBox and MWCCMsgBox functions work in exactly the same way,
	and have the same fields as the Windows API Message box function.

	1. SFXMsgBox and MWCCMsgBox now take a window handle as the first parameter.

	2. The MWCCMsgBox function takes one extra field after ATextType (the buttons and icons). It
		 takes the name of the bitmap you want used as the background brush - BWCC, MWCC or nil);

	PS. These message boxes are non-OWL windows not dialog boxes.

***}
begin
	Reply := SFXMsgBox(HWindow, 'You have selected menu item A',
										 'Information', mb_RetryCancel or mb_IconExclamation);
	if Reply = id_Retry then Messagebox(0, 'You selected Retry', 'Reply',
																					mb_ok or mb_IconAsterisk);
	if Reply = id_Cancel then Messagebox(0, 'You selected Cancel', 'Reply',
																					mb_ok or mb_IconAsterisk);

end;

procedure TMenuWindow.IDMItem2(var Msg: TMessage);
begin
	Reply := MWCCMsgBox(HWindow, 'You have selected menu item B', 'Information',
																mb_OkCancel or mb_IconInformation, 'BWCC');
	if Reply = id_Ok then Messagebox(0, 'You selected Ok', 'Reply',
																					mb_ok or mb_IconAsterisk);
	if Reply = id_Cancel then Messagebox(0, 'You selected Cancel', 'Reply',
																					mb_ok or mb_IconAsterisk);
end;

procedure TMenuWindow.IDMItem3(var Msg: TMessage);
begin
	Reply := MWCCMsgBox(HWindow, 'You have selected menu item C', 'Information',
																mb_AbortRetryIgnore or mb_IconQuestion, 'MWCC');
	if Reply = id_Abort then Messagebox(0, 'You selected Abort', 'Reply',
																					mb_ok or mb_IconAsterisk);
	if Reply = id_Retry then Messagebox(0, 'You selected Retry', 'Reply',
																					mb_ok or mb_IconAsterisk);
	if Reply = id_Ignore then Messagebox(0, 'You selected Ignore', 'Reply',
																					mb_ok or mb_IconAsterisk);
end;

procedure TMenuWindow.IDMItem4(var Msg: TMessage);
begin
	Reply := MWCCMsgBox(HWindow, 'You have selected menu item D. Its the last menu item.',
															 'Information', mb_YesNoCancel or mb_IconHand, nil);
	if Reply = id_Yes then Messagebox(0, 'You selected Yes', 'Reply',
																					mb_ok or mb_IconAsterisk);
	if Reply = id_No then Messagebox(0, 'You selected No', 'Reply',
																					mb_ok or mb_IconAsterisk);
	if Reply = id_Cancel then Messagebox(0, 'You selected Cancel', 'Reply',
																					mb_ok or mb_IconAsterisk);
end;

{********** TMenuButton **********}

destructor TMenuButton.Done;
begin
	DeleteObject(MenuFont);
	TMWCCButton.Done;
end;

procedure TMenuButton.SetupWindow;
{***

	Overrides the default size 8 TMWCCButton font and creates a size ten font which is
	more suitable for menu items. I prefer not to use a bold font.

***}
begin
	TMWCCButton.SetupWindow;
	MenuFont := CreateFont(-13, 0, 0, 0, 400, 0, 0, 0, 0, 1, 2, 1, 34, 'MS Sans Serif');
	SendMessage(HWindow, wm_SetFont, MenuFont, 1);
end;

procedure TMenuButton.WMMouseMove (var Msg: TMessage);
{***

	Resets the menus when the mouse passes over a menu button. This helps the menus to
	function more like regular menus.

***}
begin
	if Msg.wParam = 0 then
		PostMessage(Parent^.HWindow, wm_ResetMenus, 0, 0);
end;

{********** TAboutDialog **********}

constructor TAboutDialog.Init(AParent: PWindowsObject; AName, ABmp: PChar);
{***

	This initializes two recessed TMWCCStatic objects and the BWCC style
	Ok Button' (id 1) in MWCC.dll.

***}
begin
	TMWCCDialog.Init(AParent, AName, ABmp);
	ST1 := New(PMWCCStatic, InitResource(@Self, idw_Stat1, 0, ctl_Recessed));
	if GetSystemMetrics(sm_CYSize) = 26 then
		OkBut := New(PMWCCBmpButton, Init(@Self, id_Ok, 158, 184, False, 1, ctl_Flush))
	else
		OkBut := New(PMWCCBmpButton, Init(@Self, id_Ok, 116, 144, False, 1, ctl_Flush));
end;

procedure TAboutDialog.SetUpWindow;
begin
	TMWCCDialog.SetUpWindow;
	{***

		Centres the About dialog over the Winmenu window's Client area. This procedure is
		now in MWCC.dll.

	***}
	CenterOverClient(Parent^.HWindow, HWindow);
end;

procedure TAboutDialog.WMDrawItem(var Msg:tMessage);
{*** Draws the Ok Button ***}
begin
	with PDrawItemStruct(Msg.lParam)^ do
    case CtlType of
      odt_Button:
        case CtlID of
					id_Ok : OkBut^.DrawItem(Msg);
				end;
    end;
end;

{********** Main program **********}

var
	MenuApp: TMenuApplication;
begin
	MenuApp.Init(AppName);
	MenuApp.Run;
	MenuApp.Done;
end.
