{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application := System Task List

	Files       := Wintask.exe, Wintask.pas, Wintask.res

	Requires    := MObjects and MWCC.dll

	Purpose     := Wintask shows you how to,

								 1. Use the EnumWindows function to set up a task list.

								 2. Set up an ownerdraw list box and fill it with icons.

								 3. Use some of the objects in the MWCC library.

	Tabs        := 2

	Screen      := 800 * 600

	Date        := August 1993.

	Wintask is a Task Manager application that with a little work could be made into one
	of the best task managers around. Its main purpose is to show you how to use an
	ownerdraw list box and fill it with icons. Wintask also shows off some of the objects
	in the MWCC library (a recessed  list box, a recessed static control and the TMWCCButton
	object).

	I hope you find Wintask useful.

	Jeff...

***}

program WinTask;

{$R WinTask.res}

uses WinTypes, WinProcs, ShellAPI, Strings, ToolHelp, MObjects,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	{*** Button ID's ***}
	idw_But1            = 201;
	idw_But2            = 202;
	idw_But3            = 203;
	idw_But4            = 204;
	idw_But5            = 205;

	{*** Window Control ID's ***}
	idw_Listbox         = 401;
	idw_Static          = 402;

	{*** Dialog Control ID's ***}
	idd_Static1         = 403;
	idd_Static2         = 404;

	{*** System Menu ID ***}
	idm_About           = 701;

	{*** Speaks for itself ***}
	AppName     : PChar = 'WinTask';

type

	PAboutDialog = ^TAboutDialog;
	TAboutDialog = object(TSFXDialog)
		{***

			TMWCCBmpButton is a BWCC style bitMap button object. TMWCCStatic is a static object
			that displays either raised, recessed or normal static controls. WMDrawItem is required
			to draw the TMWCCBmpButton ownerdraw button object.

		***}
		OkBut : PMWCCBmpButton;
		Stat  : PMWCCStatic;
		constructor Init (AParent: PWindowsObject; AName: PChar);
		procedure SetUpWindow; virtual;
		procedure WMDrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
	end;

	PWinTaskWindow = ^TWinTaskWindow;
	TWinTaskWindow = object(TSFXWindow)
		{***

			TSFXWindow is a resizable 3D Window object. It doesn't support normal menu's or
			TScroller scroll bars. If you don't want the window to be resized set IsSizeable
			in the constructor to False. For a resizeable window set it to True.

			TMWCCListBox displays a recessed list box with a vertical scroll bar.
			TMWCCButton is a button object that can be used to display a single bitmap, text,
			or both on a button. If the button is resizeable as in this example the text
			(or bitmap) automatically recentres itself. The button can either be raised or
			recessed.

		***}
		LB       : PMWCCListBox;
		ST       : PMWCCStatic;
		TaskProc : TFarproc;
		AppIcon, WinIcon,	IcoHandle  : HIcon;
		But1, But2, But3, But4, But5 : PMWCCButton;
		constructor Init(AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function GetClassName : PChar; virtual;
		procedure GetWindowClass (var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure WMSysCommand (var Msg: TMessage); virtual wm_First + wm_SysCommand ;
		{*** WMMeasureItem  and WMDrawItem draw the list box ***}
		procedure WMMeasureItem (var Msg: TMessage); virtual wm_First + wm_MeasureItem;
		procedure WMDrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
		procedure WMSize (var Msg: TMessage); virtual wm_First + wm_Size;
		procedure ListWindows; virtual;
		procedure IDWListbox (var Msg: TMessage); virtual id_First + idw_ListBox;
		procedure IDWBut1 (var Msg: TMessage); virtual id_First + idw_But1;
		procedure IDWBut2 (var Msg: TMessage); virtual id_First + idw_But2;
		procedure IDWBut3 (var Msg: TMessage); virtual id_First + idw_But3;
		procedure IDWBut4 (var Msg: TMessage); virtual id_First + idw_But4;
		procedure IDWBut5 (var Msg: TMessage); virtual id_First + idw_But5;
	end;

	PWinTaskApplication = ^TWinTaskApplication;
	TWinTaskApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

var

	IsTopWindows : Boolean;


{********** TWinTaskApplication **********}

procedure TWinTaskApplication.InitMainWindow;
{*** True produces a resizeable window ***}
begin
	MainWindow := New(PWinTaskWindow, Init(nil, 'Task List'));
end;

{********** Callback function to list windows **********}

function GetTaskProc(Wnd: HWnd; LB: PMWCCListbox): Boolean; export;
{***

	This is the function that actually enumerates all the windows. When the function name
	is set to true the function continues to enumerate all the window giving you a handle
	for each one (Wnd). Here I use the handle to get the window's title and add it to the
	list box. If IsTopWindows is True only Top windows are listed. If its False all windows
	are listed.

***}
var
	Buf: array[0..79] of Char;
begin
	GetTaskProc := True;
	GetWindowText(Wnd, Buf, sizeof(Buf));
	if (Buf[0] <> #0) and (StrIComp(Buf, 'Task List') <> 0) then
	begin
		if IsTopWindows then
			if  (GetWindow(Wnd, gw_Owner) = 0) then
				LB^.AddString(Buf);
		if not IsTopWindows then
			LB^.AddString(Buf);
	end;
end;

{********** TWinTaskWindow **********}

constructor TWinTaskWindow.Init (AParent: PWindowsObject; AName: PChar);
{***

	The list box, static and button objects are initialized with zero values because
	WMSize sets their position later.

***}
begin
	TSFXWindow.Init(AParent, AName);
	Attr.X := GetSystemMetrics(sm_CXScreen) div 4;
	Attr.Y := (GetSystemMetrics(sm_CYScreen) div 4) + 5;
	Attr.W := GetSystemMetrics(sm_CXScreen) div 2;
	Attr.H := (GetSystemMetrics(sm_CYScreen) div 2) - 10;
	LB := New(PMWCCListBox, Init(@Self, idw_ListBox, 0, 0, 0, 0, True));
	{*** This sets the list box style to Ownerdraw, HasStrings and WantKeyboardInput ***}
	LB^.Attr.Style := LB^.Attr.Style or lbs_OwnerDrawVariable or lbs_HasStrings
										or lbs_WantKeyboardInput;
	ST := New(PMWCCStatic, Init(@Self, idw_Static, '', 0, 0, 0, 0, 0, ctl_Recessed, False));
	But1 := New(PMWCCButton, Init(@Self, idw_But1, 'All Windows', 0, 0, 0, 0, nil, 0));
	But2 := New(PMWCCButton, Init(@Self, idw_But2, 'Top Windows', 0, 0, 0, 0, nil, 0));
	But3 := New(PMWCCButton, Init(@Self, idw_But3, 'Show', 0, 0, 0, 0, nil, 0));
	But4 := New(PMWCCButton, Init(@Self, idw_But4, 'Hide', 0, 0, 0, 0, nil, 0));
	But5 := New(PMWCCButton, Init(@Self, idw_But5, 'End Task', 0, 0, 0, 0, nil, 0));
	AppIcon := LoadIcon(HInstance, 'WinTask');
	WinIcon := LoadIcon(HInstance, 'Windows');
	{*** This sets IsTopWindows to true so that only top Windows are initially displayed ***}
	IsTopWindows := True;
end;

destructor TWinTaskWindow.Done;
begin
	DeleteObject(AppIcon);
	DeleteObject(WinIcon);
	TSFXWindow.Done;
end;

function TWinTaskWindow.GetClassName;
begin
	GetClassName := AppName;
end;

procedure TWinTaskWindow.GetWindowClass (var AWndClass: TWndClass);
begin
	TSFXWindow.GetWindowClass(AWndClass);
	AWndClass.HIcon := AppIcon;
end;

procedure TWinTaskWindow.SetUpWindow;
var
	SysMenu : HMenu;
begin
	TSFXWindow.SetUpWindow;
	{*** Add About menu item to system menu ***}
	SysMenu := GetSystemMenu(HWindow, False);
	RemoveMenu(SysMenu, 8, MF_ByPosition);
	AppendMenu(SysMenu, 0, idm_About, '&About WinTask');
	{*** The user defined procedure handles listing the windows and icons ***}
	ListWindows;
end;
procedure TWinTaskWindow.WMSysCommand (var Msg : TMessage);
begin
	case Msg.wParam of
		idm_About: Application^.ExecDialog(New(PABoutDialog, Init(@Self, 'AboutDialog')));
	else
		TSFXWindow.DefWndProc(Msg);
  end;
end;

procedure TWinTaskWindow.WMMeasureItem (var Msg: TMessage);
{*** This Sets the height of the list box items ***}
begin
	pMeasureItemStruct(Msg.lParam)^.ItemHeight:= GetSystemMetrics(sm_CYIcon) + 4;
end;

procedure TWinTaskWindow.WMDrawItem (var Msg: TMessage);
{*** This draws the list box items and ownerdraw buttons ***}
var
	Buf1, Buf2         : array[0..79] of Char;
	BkBrush, OldBrush  : HBrush;
	TextColor, BkColor : LongInt;
begin
	with pDrawItemStruct(Msg.lParam)^ do
		case CtlType of
			{*** List box ***}
			odt_ListBox:
			begin
				{***

					If the item is selected the highlght colors are used otherwise the list box colors
					are used.

				***}
				if ((ItemState and ods_Selected) <> 0) and (ItemId <> word (-1)) then
				begin
					BkColor := GetSysColor(Color_HighLight);
					BkBrush := CreateSolidBrush(BkColor);
					TextColor := GetSysColor(Color_HighLightText);
				end
				else
				begin
					BkColor := GetSysColor(Color_Window);
					BkBrush := CreateSolidBrush(BkColor);
					TextColor := GetSysColor(Color_WindowText);
				end;
				{*** This sets the background color to whatever has been set above ***}
				SetBkColor(HDC, BkColor);
				{*** The text background is set to transparent and the above text color is used ***}
				SetBkMode(HDC, Transparent);
				SetTextColor(HDC, TextColor);
				OldBrush := SelectObject(HDC, BkBrush);
				{*** Fills the item rectangle with the above Brush ***}
				FillRect(HDC, rcItem, BkBrush);
				SelectObject(HDC, OldBrush);
				{*** If the selected item has the focus we draw a special border around it ***}
				if ItemState and ods_Focus <> 0 then
				begin
					DrawFocusRect(HDC, rcItem);
				end;
				{*** Get the text for the item we are about to draw ***}
				SendMessage(LB^.HWindow, lb_GetText, ItemID, LongInt(@Buf1));
				{*** Insert a tab (#9). Moves the text to the right to make room for the icon ***}
				StrCopy(Buf2, #9);
				StrCat(Buf2, Buf1);
				{*** Draw the text ***}
				DrawText(HDC, Buf2, -1, rcItem, DT_Left + DT_SingleLine + DT_VCenter + DT_ExpandTabs);
				{***

					A handle for an item's icon is set in ListWindows using the lb_SetItemData message.
					lb_GetItemData retrieves that handle so we can be draw the icon.

				***}
				IcoHandle := SendMessage(LB^.HWindow, lb_GetItemData, ItemID, 0);
				DrawIcon(HDC, rcItem.left+2, rcItem.top+2, IcoHandle);
				DeleteObject(BkBrush);
			end;
			{*** TMWCCButton ownerdraw button objects ***}
			odt_Button:
				case CtlID of
					idw_But1 : But1^.DrawItem(Msg);
					idw_But2 : But2^.DrawItem(Msg);
					idw_But3 : But3^.DrawItem(Msg);
					idw_But4 : But4^.DrawItem(Msg);
					idw_But5 : But5^.DrawItem(Msg);
				end;
		end;
end;

procedure TWinTaskWindow.WMSize (var Msg: TMessage);
{***

	I wanted to have everything in the window resize along with the window. Any positon
	set in the constructor will be overridden by WMSize so I set them zero. When the
	TMWCCButton's are resized the text (or bitmap) is autmatically recentred.

***}
var
	CRect : TRect;
	W, H, ButH : Integer;
begin
	TSFXWindow.WMSize(Msg);
	GetClientRect(HWindow, CRect);
	with CRect do
	begin
		W := Right;
		H := Bottom;
	end;
	ButH := ((H - 52) div 5);
	SetWindowPos(ST^.HWindow, 0, W-115, 20, 101, H-36, swp_NoZOrder);
	SetWindowPos(But1^.HWindow, 0, W-110, 24, 91, ButH, swp_NoZOrder);
	SetWindowPos(But2^.HWindow, 0, W-110, 24+ButH+2, 91, ButH, swp_NoZOrder);
	SetWindowPos(But3^.HWindow, 0, W-110, 24+(ButH*2)+4, 91, ButH, swp_NoZOrder);
	SetWindowPos(But4^.HWindow, 0, W-110, 24+(ButH*3)+6, 91, ButH, swp_NoZOrder);
	SetWindowPos(But5^.HWindow, 0, W-110, 24+(ButH*4)+8, 91, ButH, swp_NoZOrder);
	SetWindowPos(LB^.HWindow, 0, 16, 22, W-150, H-40, swp_NoZOrder);
end;

procedure TWinTaskWindow.ListWindows;
var
	Title : array[0..144] of Char;
	Item: Integer;
	TaskWnd : HWnd;
	TaskModule : THandle;
	Msg : TMessage;
begin
	{***

		The next 3 lines plus the callback function are all that's required
		to enumerate the windows.

	***}
	TaskProc := MakeProcInstance(@GetTaskProc, HInstance);
	EnumWindows(TaskProc, LongInt(LB));
	FreeProcInstance(TaskProc);
	{***

		The callback function adds all the window titles to the list box. Now we retrieve
		them so that we can get a handle for the window's icon.

	***}
	Item := 0;
	while Item < LB^.GetCount do
	begin
		LB^.GetString(Title, Item);
		TaskWnd := FindWindow(nil, Title);
		IcoHandle := GetClassWord(TaskWnd, gcw_HIcon);
		{***

			If the Window has no icon we find its executable module, usually the parent window,
			and use its icon.

		***}
		if IcoHandle = 0 then
		begin
			TaskModule := GetClassWord(TaskWnd, gcw_HModule);
			GetModuleFileName(TaskModule, Title, sizeof(Title));
			IcoHandle := ExtractIcon(HInstance, Title, 0);
			if IcoHandle = 0 then
				IcoHandle := LoadIcon(0, idi_Application);
		end;
		{***

			lb_SetItemData lets us associate a value with each list item. Here we associate
			an icon handle with its list item. In WMDrawItem we retrieve this handle with
			lb_GetItemData so we can draw the icon.

		***}
		SendMessage(LB^.HWindow, lb_SetItemData, Item, IcoHandle);
		Inc(Item);
	end;
	{*** Set the focus so that the first item is highlighted when Wintask is launched ***}
	LB^.SetSelIndex(0);
	SetFocus(LB^.HWindow);
end;

procedure TWinTaskWindow.IDWListBox (var Msg: TMessage);
{*** Show the window when we double click on its name in the list ***}
var
	Title : array[0..50] of Char;
	TaskWnd : HWnd;
begin
	if Msg.lParamHi = lbn_DblClk then
	begin
		LB^.GetSelString(@Title, 50);
		TaskWnd := FindWindow(nil, Title);
		ShowWindow(TaskWnd, sw_ShowNormal);
	end
	else
		TSFXWindow.DefChildProc(Msg);
end;

procedure TWinTaskWindow.IDWBut1 (var Msg: TMessage);
{*** Resets IsTopWindows to False so that all windows on the system can be displyed ***}
begin
	IsTopWindows := False;
	SendMessage(LB^.HWindow, lb_ResetContent, 0, 0);
	ListWindows
end;

procedure TWinTaskWindow.IDWBut2 (var Msg: TMessage);
{*** Resets IsTopWindows to True so that only top windows are displyed ***}
begin
	IsTopWindows := True;
	SendMessage(LB^.HWindow, lb_ResetContent, 0, 0);
	ListWindows
end;

procedure TWinTaskWindow.IDWBut3 (var Msg: TMessage);
{*** Show a hidden window ***}
var
	SelStr : array[0..50] of Char;
	TaskWnd : HWnd;
begin
	LB^.GetSelString(@SelStr, 49);
	TaskWnd := FindWindow(nil, SelStr);
	if IsIconic(TaskWnd) then
		ShowWindow(TaskWnd, sw_ShowMinNoActive)
	else
		ShowWindow(TaskWnd, sw_ShowNormal);
	BringWindowtoTop(Taskwnd);
end;

procedure TWinTaskWindow.IDWBut4 (var Msg: TMessage);
{*** Hide a window. To successfully hide an icon you have to call sw_Hide twice ***}
var
	SelStr : array[0..50] of Char;
	TaskWnd : HWnd;
begin
	LB^.GetSelString(@SelStr, 49);
	TaskWnd := FindWindow(nil, SelStr);
	if IsIconic(TaskWnd) then
	begin
		ShowWindow(TaskWnd, sw_Hide);
		ShowWindow(TaskWnd, sw_Hide);
	end
	else
		ShowWindow(TaskWnd, sw_Hide);
end;

procedure TWinTaskWindow.IDWBut5 (var Msg: TMessage);
{*** Close a window and reset the list ***}
var
	SelStr : array[0..50] of Char;
	TaskWnd : HWnd;
	Indx : Integer;
begin
	Indx := SendMessage(LB^.HWindow, lb_GetCurSel, 0, 0);
	SendMessage(LB^.HWindow, lb_GetText, Indx, LongInt(@SelStr));
	TaskWnd := FindWindow(nil, SelStr);
	if GetWindow(TaskWnd, gw_Owner) <> 0 then
		SendMessage(GetWindow(TaskWnd, gw_Owner), wm_Close, 0, 0)
	else
		SendMessage(TaskWnd, wm_Close, 0, 0);
	SendMessage(LB^.HWindow, lb_ResetContent, 0, 0);
	ListWindows;
end;

{********** TAboutDialog **********}

constructor TAboutDialog.Init(AParent: PWindowsObject; AName: PChar);
{***

	This initializes a recessed TMWCCStatic object and the BWCC style
	Ok Button' (id 1) in MWCC.dll.

***}
begin
	TSFXDialog.Init(AParent, AName);
	Stat := New(PMWCCStatic, InitResource(@Self, idd_Static1, 0, ctl_Recessed));
	if GetSystemMetrics(sm_CYSize) = 26 then
		OkBut := New(PMWCCBmpButton, Init(@Self, id_Ok, 150, 184, False, 1, ctl_Flush))
	else
		OkBut := New(PMWCCBmpButton, Init(@Self, id_Ok, 110, 144, False, 1, ctl_Flush));
end;

procedure TAboutDialog.SetUpWindow;
begin
	TSFXDialog.SetUpWindow;
	{***

		Centres the About dialog over the Task List window. This procedure is now in
		MWCC.dll.

	***}
	CenterOverWindow(Parent^.HWindow, HWindow);
end;

procedure TAboutDialog.WMDrawItem(var Msg:tMessage);
{*** Draws the Ok Button ***}
begin
	with PDrawItemStruct(Msg.lParam)^ do
    case CtlType of
      odt_Button:
        case CtlID of
					id_Ok : OkBut^.DrawItem(Msg);
				end;
    end;
end;

{********** Main program **********}

var
	App: TWinTaskApplication;
begin

	App.Init(AppName);
	App.Run;
	App.Done;
end.
