program DG_Test;
{ --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --

Character-by-character loop transmission test.

Requires DigiBoard's DigiChannel PC/8e hardware and XIDOS5.SYS device driver
to be installed on your PC.

  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- }
uses DOS;

type
  namestring = array[1..8] of char;

var
   Tdx, Rdx, i  : integer;
   xmitbuffsz, recvbuffsz, xmitlow, recvlow, recvhigh, buffercount : integer;
   regs : registers;
   name : ^namestring;
   stat, notetext : string;
   TestResult : word;

procedure WriteHex(dec_num:longint);
{Write a 4-digit hex number.  Dec_Num<65,536 decimal.}
var
        x : real;
        h4, h3, h2, h1 : longint;
        c4, c3, c2, c1 : string[1];
        hex_str : string[4];
BEGIN
  if Dec_Num>=65536
  then
    write('****') { Error! }
  else
  begin

   x:=Dec_Num;
   if x<=0 then h4 := 0
          else h4 := trunc(x/4096);

   x:=x-h4*4096;
   if x<=0 then h3 := 0
          else h3 := trunc(x/256);

   x:=x-h3*256;
   if x<=0 then h2 := 0
          else h2 := trunc(x/16);

   x:=x-h2*16;
   if x<=0 then h1 := 0
           else h1 := trunc(x);

   hex_str := '0000';

   if h4>$0F
   then hex_str := '****'
   else
   begin

     if h4<=9
             then str(h4:1,c4)
             else c4 := chr(h4-10+ord('A'));
     {hex_str := concat(hex_str,c4);}
     hex_str[1] := c4[1];

     if h3<=9
             then str(h3:1,c3)
             else c3 := chr(h3-10+ord('A'));
     {hex_str := concat(hex_str,c3);}
     hex_str[2] := c3[1];
     if h2<=9
             then str(h2:1,c2)
             else c2 := chr(h2-10+ord('A'));
     {hex_str := concat(hex_str,c2);}
     hex_str[3] := c2[1];

     if h1<=9
             then str(h1:1,c1)
             else c1 := chr(h1-10+ord('A'));
     {hex_str := concat(hex_str,c1);}
     hex_str[4] := c1[1];

   end;
   write(hex_str);
  end;
end;

procedure write_date;
{ Example for GetDate }
const
  days : array [0..6] of String[9] =
    ('Sunday','Monday','Tuesday',
     'Wednesday','Thursday','Friday',
     'Saturday');
var
  y, m, d, dow : Word;
begin
  GetDate(y,m,d,dow);
  Write(days[dow],', ',
          m:0, '/', d:0, '/', y:0);
end;

procedure write_time;
{ Example for GetTime }
var
  h, m, s, hund : Word;
function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;
begin
  GetTime(h,m,s,hund);
  Write('  ',LeadingZero(h),':',
          LeadingZero(m),':',LeadingZero(s),
          '.',LeadingZero(hund));
end;

BEGIN

writeln(
'DG_Test Version 1.03 - Copyright 1994 Computer Magic, Andover, Minnesota-');
writeln(
'-------------------------------------------------------------------------');
writeln;
writeln(
'This program uses the DigiCHANNEL Universal DOS Device Driver functions');
writeln('in the XIDOS5.SYS device driver for interrupt 14h.');
writeln;
write('The Date is: '); write_date; writeln;
write('The Time is: '); write_time; writeln;
TestResult := 0;
writeln;

  write('Enter Tx Dx: '); readln(Tdx); writeln(Tdx);
  write('Enter Rx Dx: '); readln(Rdx); writeln(Rdx);
  write('Note: '); readln(notetext); writeln(notetext);
  writeln;

  { Get Board & Channel Information -Function 06h }
  regs.dx := tdx;
  regs.ah := $06;
  regs.al := $00;  { Subfunction: Get Port Name }
  intr($14,regs);
  if regs.ah=$FF {error}
  then writeln('Tdx Port Name Error.');
            if regs.ah=$FF {error}
            then TestResult := 1;
  writeln('Tdx Highest Function Supported: ',regs.al);
  name := ptr(regs.es,regs.bx);
  write('Tdx Port Name: ');
  writeln(name^[1],name^[2],name^[3],name^[4],
          name^[5],name^[6],name^[7],name^[8] );
  
  regs.dx := rdx;
  regs.ah := $06;
  regs.al := $00;  { Subfunction: Get Port Name }
  intr($14,regs);
  if regs.ah=$FF {error}
  then writeln('Rdx Port Name Error.');
            if regs.ah=$FF {error}
            then TestResult := 1;
  writeln('Rdx Highest Function Supported: ',regs.al);
  name := ptr(regs.es,regs.bx);
  write('Rdx Port Name: ');
  writeln(name^[1],name^[2],name^[3],name^[4],
          name^[5],name^[6],name^[7],name^[8] );
  writeln;

  regs.dx := tdx;
  regs.ah := $06;
  regs.al := $01;  { Subfunction: Driver Information }
  intr($14,regs);
  if regs.ah=$ff then writeln('Driver Info Error.');
            if regs.ah=$FF {error}
            then TestResult := 1;
  writeln('Total Channels supported: ',regs.ax);
  write  ('          Driver Version: '); WriteHex(regs.bx); writeln;
  writeln('            Total Boards: ',regs.cx);
  writeln('        Lowest Channel #: ',regs.dx);
  regs.dx := tdx;
  regs.ah := $06;
  regs.al := $02;  { Subfunction: Board Information }
  regs.bx := 0;    {              Board # 0         }
  intr($14,regs);
  writeln('            Board Number: 0');
  if regs.ah=$ff then writeln('Board Info Error.');
            if regs.ah=$FF {error}
            then TestResult := 1;
  writeln('               Board IRQ: ',regs.ah);
  write  ('              Board Type: ',regs.al,' (');
                                       writeHex(regs.al);writeln(')');
  write  ('        Board memory seg: ',regs.bx,' (');
                                       writeHex(regs.bx);writeln(')');
  writeln('        Board # Channels: ',regs.cx);
  write  ('  Board I/O Port Address: ',regs.dx,' (');
                                       writeHex(regs.dx);writeln(')');
  writeln('     Board first Channel: ',regs.SI);
  regs.dx := tdx;
  regs.ah := $06;
  regs.al := $ff;  { Subfunction: Driver Name }
  intr($14,regs);
  write  ('   Driver Version Number: ',regs.ax,' (');
                                       writeHex(regs.ax);writeln(')');
  writeln(' Driver # Chnl Supported: ',regs.cx);
  name := ptr(regs.es,regs.bx);
  write(  '             Driver Name: ');
  writeln(name^[1],name^[2],name^[3],name^[4],
          name^[5],name^[6],name^[7],name^[8] );
  writeln; writeln;

  { Get Channel Parameters - Function 0Ch }
  regs.dx := tdx;
  regs.ah := $0c;
  intr($14,regs);
  write  ('Tdx Software Flow Control: ',regs.ah,' (');
                                       writeHex(regs.ah);writeln(')');
  if regs.ah=$ff 
  then begin
         writeln('Tdx Channel Parameter Error.');
         TestResult := 1;
       end
  else begin
         write  ('Tdx Hardware Flow Control: ',regs.al,' (');
                                       writeHex(regs.al);writeln(')');
         writeln('               Tdx Parity: ',regs.bh);
         writeln('            Tdx Stop Bits: ',regs.bl);
         writeln('     Tdx Character Length: ',regs.ch);
         write  ('            Tdx Baud Rate: ',regs.cl,' (');
                                       writeHex(regs.cl);write(')');
         case regs.cl of
          $00: writeln(' 110 baud.');
          $01: writeln(' 150 baud.');
          $02: writeln(' 300 baud.');
          $03: writeln(' 600 baud.');
          $04: writeln(' 1200 baud.');
          $05: writeln(' 2400 baud.');
          $06: writeln(' 4800 baud.');
          $07: writeln(' 9600 baud.');
          $08: writeln(' 19200 baud.');
          $09: writeln(' 38400 baud.');
          $0a: writeln(' 57600 baud.');
          $0b: writeln(' 76800 baud.');
          $0c: writeln(' 115200 baud.');
          $0d: writeln(' 50 baud.');
          $0e: writeln(' 75 baud.');
          $0f: writeln(' 134 baud.');
          $10: writeln(' 200 baud.');
          $11: writeln(' 1800 baud.');
         end;
       end;

  writeln;
  regs.dx := rdx;
  regs.ah := $0c;
  intr($14,regs);
  write  ('Rdx Software Flow Control: ',regs.ah,' (');
                                       writeHex(regs.ah);writeln(')');
  if regs.ah=$ff 
  then begin
         writeln('Rdx Channel Parameter Error.');
         TestResult := 1;
       end
  else begin
         write  ('Rdx Hardware Flow Control: ',regs.al,' (');
                                       writeHex(regs.al);writeln(')');
         writeln('               Rdx Parity: ',regs.bh);
         writeln('            Rdx Stop Bits: ',regs.bl);
         writeln('     Rdx Character Length: ',regs.ch);
         write  ('            Rdx Baud Rate: ',regs.cl,' (');
                                       writeHex(regs.cl);write(')');
         case regs.cl of
          $00: writeln(' 110 baud.');
          $01: writeln(' 150 baud.');
          $02: writeln(' 300 baud.');
          $03: writeln(' 600 baud.');
          $04: writeln(' 1200 baud.');
          $05: writeln(' 2400 baud.');
          $06: writeln(' 4800 baud.');
          $07: writeln(' 9600 baud.');
          $08: writeln(' 19200 baud.');
          $09: writeln(' 38400 baud.');
          $0a: writeln(' 57600 baud.');
          $0b: writeln(' 76800 baud.');
          $0c: writeln(' 115200 baud.');
          $0d: writeln(' 50 baud.');
          $0e: writeln(' 75 baud.');
          $0f: writeln(' 134 baud.');
          $10: writeln(' 200 baud.');
          $11: writeln(' 1800 baud.');
         end;
       end;
  writeln;


  { Clear Buffers - Function 09h }
  regs.dx := tdx;
  regs.ah := $09;
  intr($14,regs);
  if regs.ah=0 then writeln('Tdx buffers cleared.')
               else writeln('Tdx buffer clear ERROR.');
            if regs.ah=$FF {error}
            then TestResult := 1;
  regs.dx := rdx;
  regs.ah := $09;
  intr($14,regs);
  if regs.ah=0 then writeln('Rdx buffers cleared.')
               else writeln('Rdx buffer clear ERROR.');
            if regs.ah=$FF {error}
            then TestResult := 1;

  { Get Water Marks and Buffer Size - Function 1Bh }
  regs.dx := tdx;
  regs.ah := $1B;
  regs.al := $00; { subfunction: get Transmit Low Water Mark }
  intr($14,regs);
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 00h - Get Transmit Low Water Mark.');
  writeln('     Xmit Low Water Mark: ', regs.ax);
  writeln('        Xmit Buffer Size: ',regs.bx);
  xmitbuffsz := regs.bx;
  if regs.dh=$ff then writeln('                          Xmit Buffer Error.');

  regs.dx := rdx;
  regs.ah := $1B;
  regs.al := $01; { subfunction: Get Receive Low Water Mark }
  intr($14,regs);
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 01h - Get Receive Low Water Mark.');
  writeln('     Recv Low Water Mark: ', regs.ax);
  writeln('        Recv Buffer Size: ',regs.bx);
  if regs.dh=$ff then writeln('                          Recv Buffer Error.');
  
  regs.dx := rdx;
  regs.ah := $1B;
  regs.al := $02; { subfunction: Get Receive High Water Mark }
  intr($14,regs);
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 02h - Get Receive High Water Mark.');
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 02h - Get Receive High Water Mark.');
  writeln('    Recv High Water Mark: ', regs.ax);
  writeln('        Recv Buffer Size: ',regs.bx);
  recvbuffsz := regs.bx;
  recvhigh := regs.ax;
  if regs.dh=$ff then writeln('                          Recv Buffer Error.');

  buffercount := xmitbuffsz + recvhigh - 1;
  
  { Get Status - Function 03h }
  regs.dx := tdx;
  regs.ah := $03;
  intr($14,regs);
  writeln;
  write  ('Tdx Line Status: ',regs.ah,' (');writeHex(regs.ah);writeln(')');
  write  ('Tdx Modem Status: ',regs.al,' (');writeHex(regs.al);writeln(')');
  regs.dx := rdx;
  regs.ah := $03;
  intr($14,regs);
  writeln;
  write  ('Rdx Line Status: ',regs.ah,' (');writeHex(regs.ah);writeln(')');
  write  ('Rdx Modem Status: ',regs.al,' (');writeHex(regs.al);writeln(')');

  { Write Characters - Function 01h }
  writeln;
  writeln('Transmitted:');
  writeln;  write_time;  writeln;
  for i := 0 to 99 do
  begin
     regs.ah := $01;
     regs.al := i;
     regs.dx := tdx;
     intr($14,regs);
     if (i mod 5) = 0 then writeln;
     write(' ('); 
     WriteHex(regs.ah); 
     if regs.al<>i then write(')',i:3,':',regs.al:3,'* ')
                   else write(')',i:3,':',regs.al:3,'  ');
  end;
  for i := 100 to buffercount do
  begin
     regs.ah := $01;
     regs.al :=  81; { Letter "Q" }
     regs.dx := tdx;
     intr($14,regs);
     if (regs.ah and $80)<>0 then buffercount := i-1;
     if (i mod 5) = 0 then writeln;
     write(' (Q)',i:4,':',regs.al:3,'  ');
  end;

  writeln;

  { Get Water Marks and Buffer Size - Function 1Bh }
  regs.dx := tdx;
  regs.ah := $1B;
  regs.al := $00; { subfunction: get Transmit Low Water Mark }
  intr($14,regs);
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 00h - Get Transmit Low Water Mark.');
  writeln('     Xmit Low Water Mark: ', regs.ax);
  writeln('        Xmit Buffer Size: ',regs.bx);
  xmitbuffsz := regs.bx;
  if regs.dh=$ff then writeln('                          Xmit Buffer Error.');

  regs.dx := rdx;
  regs.ah := $1B;
  regs.al := $01; { subfunction: Get Receive Low Water Mark }
  intr($14,regs);
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 01h - Get Receive Low Water Mark.');
  writeln('     Recv Low Water Mark: ', regs.ax);
  writeln('        Recv Buffer Size: ',regs.bx);
  if regs.dh=$ff then writeln('                          Recv Buffer Error.');
  
  regs.dx := rdx;
  regs.ah := $1B;
  regs.al := $02; { subfunction: Get Receive High Water Mark }
  intr($14,regs);
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 02h - Get Receive High Water Mark.');
  writeln('Get Water Marks and Buffer Size - Function 1Bh');
  writeln('    Subfunction 02h - Get Receive High Water Mark.');
  writeln('    Recv High Water Mark: ', regs.ax);
  writeln('        Recv Buffer Size: ',regs.bx);
  recvbuffsz := regs.bx;
  recvhigh := regs.ax;
  if regs.dh=$ff then writeln('                          Recv Buffer Error.');

  { Get Status - Function 03h }
  regs.dx := tdx;
  regs.ah := $03;
  intr($14,regs);
  writeln;
  write  ('Tdx Line Status: ',regs.ah,' (');writeHex(regs.ah);writeln(')');
  write  ('Tdx Modem Status: ',regs.al,' (');writeHex(regs.al);writeln(')');
  regs.dx := rdx;
  regs.ah := $03;
  intr($14,regs);
  writeln;
  write  ('Rdx Line Status: ',regs.ah,' (');
                                       writeHex(regs.ah);writeln(')');
  write  ('Rdx Modem Status: ',regs.al,' (');
                                       writeHex(regs.al);writeln(')');
  writeln;

  { Input Queue Check - Function 0Ah }
  regs.dx := tdx;
  regs.ah := $0A;
  intr($14,regs);
  writeln;
  write  ('Number Chars in input buffer (Fctn 0Ah): ',regs.ax,' (');
                                       writeHex(regs.ax);writeln(')');
  write  (' Error (if ',$ff,': ',regs.dh);
  writeln;

  { Input Queue Check - Function 12h }
  regs.dx := tdx;
  regs.ah := $12;
  intr($14,regs);
  writeln;
  write  ('Bytes free in xmit buffer (Fctn 12h): ',regs.ax,' (');
                                       writeHex(regs.ax);writeln(')');
  writeln;

  { Input Queue Check - Function 15h }
  regs.dx := tdx;
  regs.ah := $15;
  intr($14,regs);
  writeln;
  write  ('Input buffer byte count (Fctn 15h): ',regs.ax,' (');
                                       writeHex(regs.ax);writeln(')');
  writeln;

  writeln;

  { Read Characters - Function 02h }
  writeln;
  writeln;  write_time;  writeln;
  writeln('Received:');
  for i := 0 to 99 do
  begin
     regs.ah := $02;
     regs.dx := rdx;
     intr($14,regs);
     if (i mod 5) = 0 then writeln;
     write(' ('); 
     WriteHex(regs.ah); 
     if regs.al<>i then write(')',i:3,':',regs.al:3,'* ')
                   else write(')',i:3,':',regs.al:3,'  ');
  end;
  for i := 100 to buffercount do
  begin
     regs.ah := $02;
     regs.dx := rdx;
     intr($14,regs);
     if (i mod 5) = 0 then writeln;
     write(' ('); 
     WriteHex(regs.ah); 
     if regs.al<>81 then write(')',i:4,':',regs.al:3,'*')
                    else write(')',i:4,':',regs.al:3,' ');
  end;
  writeln;  write_time;  writeln;
  
  { Get Status - Function 03h }
  regs.dx := tdx;
  regs.ah := $03;
  intr($14,regs);
  writeln;
  write  ('Tdx Line Status: ',regs.ah,' (');writeHex(regs.ah);writeln(')');
  write  ('Tdx Modem Status: ',regs.al,' (');writeHex(regs.al);writeln(')');
  regs.dx := rdx;
  regs.ah := $03;
  intr($14,regs);
  writeln;
  write  ('Rdx Line Status: ',regs.ah,' (');writeHex(regs.ah);writeln(')');
  write  ('Rdx Modem Status: ',regs.al,' (');writeHex(regs.al);writeln(')');

  halt(TestResult);
END.

