{$X+}
{$V-}
{ EXAMPLE6.PAS - demonstrates use of external programmer defined key buffer

  Requires Turbo Pascal version 6.0, 7.0

}
Uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  {$IFDEF VER70}
  WinDos,
  {$ELSE}
  Dos,
  {$ENDIF}
  BtvConst,
  Btv;


type
  ErrorType = Object(ErrorDisplay)
    Function    Display(Error     : Integer;
                        ErrorMsg  : String;
                        OpCode    : Integer;
                        OpCodeMsg : String;
                        FileName  : PathStr
                        ): ErrorAction;             Virtual;
  end;


var
  F           : BtrieveFile;
  Buff        : record
                  Name    : String[30];
                  Number  : Integer;
                  Comment : String[80];
                end;
  Key         : record
                  Case Byte of
                    1:(Name    : String[30]);
                    2:(Number  : Integer);
                  end;
  Name        : String[30];
  Number      : Integer;
  Comment     : String[80];
  ErrHandler  : DefErrorHandler;
  ErrDisplay  : ErrorType;


{ Heres our error display object  }
Function ErrorType.Display(Error     : Integer;
                           ErrorMsg  : String;
                           OpCode    : Integer;
                           OpCodeMsg : String;
                           FileName  : PathStr
                           ): ErrorAction;
  begin
    ClrScr;
    Writeln('Btrieve IO error for ' + FileName);
    Writeln(Error,  ' - ', ErrorMsg);
    Writeln(Opcode, ' - ', OpCodeMsg);
    Writeln('Press any key ....');
    ReadKey;
    Display := erDone;  { just let the program continue }
    ClrScr;
  end;

begin
  { first make a error display }
  ErrDisplay.Init;
  { now make an error handler, it needs a display object  }
  ErrHandler.Init(@ErrDisplay);

  ClrScr;
  Writeln('Creating a file called TEST6.DAT');

  { init the file passing it the error handler and }
  { address of our data buffer                     }
  F.Init('TEST6.DAT', @ErrHandler, @Buff, SizeOf(Buff));
  { the first thing to do is define the key }
  { #1 is a string }
  F.AddKeySegment(1, 31, bExtended, bLstring, 0, bNoJustify);
  { #2 is an integer }
  F.AddKeySegment(32, 2, bExtended, bInteger, 0, bNormal);
  F.AddKeyBuffer(@Key, SizeOf(Key));
  F.Create(bNormal, SizeOf(Buff), 1024, 15, bNormal);
  F.Open(bNormal, '');

  { lets add a couple records  }
  Write('Adding some records .');

  Buff.Name   := 'AAAAAAAAAA';
  Buff.Number := 1;
  Buff.Comment:= 'Record #1';
  F.Insert;
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'BBBBBBBBBB';
  Buff.Number := 2;
  Buff.Comment:= 'Record #2';
  F.Insert;
  Write('.');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'CCCCCCCCCC';
  Buff.Number := 3;
  Buff.Comment:= 'Record #3';
  F.Insert;
  Write('.');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'DDDDDDDDDD';
  Buff.Number := 4;
  Buff.Comment:= 'Record #4';
  F.Insert;
  Write('.');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'EEEEEEEEEE';
  Buff.Number := 5;
  Buff.Comment:= 'Record #5';
  F.Insert;
  Writeln('.');

  { how about reading a record by key }
  Writeln;
  Writeln('Reading by key 1');
  { build a key }
  F.ClearKey;
  Key.Number := 3;
  F.SetKeyPath(1);
  F.Get(bGetEqual, bNoLock);
  Writeln(Buff.Name);
  Writeln(Buff.Number);
  Writeln(Buff.Comment);
  Writeln('Press a key...');
  ReadKey;

  Writeln;
  Writeln('Reading by key 2');
  F.ClearKey;
  Key.Name := 'EEEEEEEEEE';
  F.SetKeyPath(0);
  F.Get(bGetEqual, bNoLock);
  Writeln(Buff.Name);
  Writeln(Buff.Number);
  Writeln(Buff.Comment);
  Writeln('Press a key...');
  ReadKey;

  F.Close;
end.
