/* Rexx */

sigstr = 'Signal On Syntax;Signal Off Error;Signal Off Failure;'
logfile = 'c:\rc3.log'

Signal On Syntax

/* This exec executes any valid Rexx instruction group sent from a */
/* partner LU */

Address "CMD" "@Echo Off"

If RxFuncQuery('rxAPPC') Then
  Call RxFuncAdd 'rxAPPC','rxappcfd','rxappcfd'
If rxfuncquery('syssleep') Then
  Do
  Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
  Call SysLoadFuncs
  End
If RxFuncQuery('RXRSOE2F') Then
  Do
  Call RxFuncAdd 'RxYdbaUtilInit','YDBAUTIL','RxYdbaUtilInit'
  Call RxYdbaUtilInit
  End

call rxseterror 'he'

convtype = 'mfn'       /* mapped, full-duplex, non-blocking */
rswd = 'y'

appcrc = rxAppc('Receive_Allocate','RC3','Inf.')
If appcrc = 0 Then
  Do
  tpid =   inf.1
  convid = inf.2
  incoming_user = inf.5
  partlu = inf.7
  partmode = inf.8
  End
Else
  Do
  call lineout logfile,'Receive_Allocate failed with rc =' appcrc
  Exit
  End

appcrc = rxappc('Receive_and_Wait',convtype,tpid,convid,rswd,10000,'inf.')
If appcrc <> 0 Then
  Do
  call lineout logfile,'Receive_and_Wait failed with rc =' appcrc
  Call rxAppc 'Tp_Ended', tpid,'s'
  Exit
  End
inf.5 = cryption(inf.5)
Parse Var inf.5 upmid upmpw .
rxupmrcu = RxUpm('Logon',upmid,upmpw,'Local',,'User')
rxupmrca = RxUpm('Logon',upmid,upmpw,'Local',,'Admin')
If rxupmrcu <> 0 | rxupmrca <> 0 Then
  Do
  Call rxAppc 'Send_Error',convtype,tpid,convid,'p','s','inf.'
  Call rxAppc 'Tp_Ended', tpid,'s'
  Exit
  End

/* Create an un-named pipe and get its read & write handles */
rxrc = rxcreatepipe('h.',32765)
hread  = h.1
hwrite = h.2

/* Re-direct standard out & error to pipe's write handle */
call rxsose2h hwrite

tid = rxcreaterexxthread('rc4', partlu, partmode, hread, hwrite, tpid, convid)

Restart_From_Here:

appcrc = rxappc('Receive_and_Wait',convtype,tpid,convid,rswd,10000,'inf.')
Do While Appcrc = 0
  cmdstr = cryption(inf.5)
  say 'Command String:';say '  'cmdstr;say 'Command Result:';Say
  Interpret sigstr||cmdstr
  Say ' '
  appcrc = rxappc('Receive_and_Wait',convtype,tpid,convid,rswd,10000,'inf.')
End

Call rxAppc 'Tp_Ended', tpid,'s'
call rxkillthread tid

Exit

Syntax:
msg = 'Command "'cmdstr'"'
call lineout logfile,msg;say msg
msg = 'Failed with syntax error ('rc')' ErrorText(rc)
call lineout logfile,msg;say msg
Signal Restart_From_Here

Cryption:
Return BitXor(Arg(1),Copies('ff'x,Length(Arg(1))))
