/*****************************************************************
					DISCLAIMER

Novell, Inc. makes no representations or warranties with respect to
any NetWare software, and specifically disclaims any express or
implied warranties of merchantability, title, or fitness for a
particular purpose.

Distribution of any NetWare software is forbidden without the
express written consent of Novell, Inc.  Further, Novell reserves
the right to discontinue distribution of any NetWare software.

Novell is not responsible for lost profits or revenue, loss of use
of the software, loss of data, costs of re-creating lost data, the
cost of any substitute equipment or program, or claims by any party
other than you.  Novell strongly recommends a backup be made before
any software is installed.   Technical support for this software
may be provided at the discretion of Novell.
*****************************************************************/

/********************************************************************
Source: RELOG.C  - Reattaches File Server and remaps the drives
Date  : 01/04/94 - original source
-----------------------------------------------------------------------

Purpose:
   demonstrate how to reattach to fileservers and remaps the drives
   associated with those fileservers without exitting a program.
-----------------------------------------------------------------------
01/04/94 - DReeves & MSpano - initial release.
-----------------------------------------------------------------------
***********************************************************************/

#include <io.h>                    /* Borland header files */
#include <fcntl.h>
#include <share.h>
#include <sys\stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <direct.h>
#include <dos.h>

/*-----------------------------------------------------------------------*/

#include <nit.h>                   /* NWCI header files */
#include <nxt.h>
#include <niterror.h>
#include <diag.h>

/*-----------------------------------------------------------------------*/

#define DISPLAYSAVE        1
#define DISPLAYRESET       1

#define NOTMAPPED        255
#define LOCAL            128
#define MAXMAPPINGS       32
#define MAXSEARCHDRIVES   16
#define SEARCHDRIVE        1
#define ENDMARKER       0xFF

#define CR              0x0D

#define IGNORE             0
#define RETRY              1
#define ABORT              2
#define LASTDOSDRIVE          5
/*-----------------------------------------------------------------------*/

struct searchDrives
{
   BYTE vector[MAXSEARCHDRIVES]; /* stores search drive order (indexes) */
   struct {
	  char path[255];
	  BYTE search;      /* Flag - marked if search drive                */
	  BYTE dtype;       /* drive type - used, network, local            */
	  BYTE rootEnd;     /* index into 'path' at end of the root portion */
	  WORD connID;      /* server connection for each mapped drive      */
	  } drive[MAXMAPPINGS];
}  maps;


struct serverList
{
	char fileServerName[48]; /* server name */
	BYTE network[4];         /* server's network number */
	BYTE node[6];            /* physical node address */
	BYTE socket[2];          /* socket number */
	BYTE down;               /* flag is set if fileserver is down */
	BYTE connID;             /* server connection for file server name */
} serverInfo[9];            /* want this to be 1-based */

static char *err_msg[]=     /* INT 24 messages */
{ 	"write protect",
	"unknown unit",
	"drive not ready",
	"unknown command",
	"data error (CRC)",
	"bad request",
	"seek error",
	"unknown media type",
	"sector not found",
	"printer out of paper",
	"write fault",
	"read fault",
	"general failure",
	"reserved",
	"reserved",
	"invalid disk change"
};

/**************************
	Global Variables
**************************/
BeginDiagnosticStruct destination;

BYTE  dirHandleNum;
char  dirPath[255];
char  thePath[255];
char  tmpPath[255];
char  serverName[48];
char  volume[48];
int   cCode;
int   drv;
WORD  connID,
	  defaultConnID;

char far *fsNamePtr;
char far *idNamePtr;
char far *driveFlagPtr;
char far *driveConnIDPtr;
char far *driveHndlPtr;


// function prototypes
void GetServerInfo ( void );
void SaveDriveMappings(void );
int Handler24 ( int,int,int,int );
	int ErrorWin ( char * );
	void CleanShell ( int );
	void DeleteMapDrives ( int );
void ReConnectServer ( int );
	int  MapRoot(int, char far *);
	void ResetDriveMappings ( char *, WORD );

void PingServers ( void );
void main ( void );

/***************************************************************************
** Set pointers to the various tables in the Shell
***************************************************************************/
void GetServerInfo ( void )
{
	BYTE compare;
	int entries = 1;
	union REGS inregs, outregs;
	struct SREGS segregs;
	//
	memset ( serverInfo, 0, sizeof ( serverInfo ) );

	// Server Connection Table
	segread(&segregs);

	inregs.h.ah = 0xEF;
	inregs.h.al = 0x03;
	intdosx(&inregs,&outregs,&segregs);
	idNamePtr = MK_FP(segregs.es,outregs.x.si);


	// Server Name Table
	inregs.x.ax = 0xEF04;
	intdosx (&inregs,&outregs,&segregs);
	fsNamePtr = MK_FP(segregs.es,outregs.x.si);


	//Drive Flag Table
	inregs.x.ax = 0xEF01;
	intdosx (&inregs,&outregs,&segregs);
	driveFlagPtr = MK_FP(segregs.es,outregs.x.si);


	//Drive Connection Table
	inregs.x.ax = 0xEF02;
	intdosx (&inregs,&outregs,&segregs);
	driveConnIDPtr = MK_FP(segregs.es,outregs.x.si);

	//Drive Handle Table
	inregs.x.ax = 0xEF00;
	intdosx (&inregs,&outregs,&segregs);
	driveHndlPtr = MK_FP(segregs.es,outregs.x.si);

	/* copy info from Shell into serverInfo[] */

	while ( entries < 9 )
	{
		compare = *idNamePtr;

		/* copy info only if the Slot In Use is set in the shell's
		 * Connection ID Table
		 */

		if ( compare == 0xFF )
		{
			memmove ( serverInfo[entries].fileServerName,fsNamePtr,48 );
			memmove ( serverInfo[entries].network,idNamePtr+2,4 );
			memmove ( serverInfo[entries].node,idNamePtr+6, 6);
			memmove ( serverInfo[entries].socket,idNamePtr+12,2 );
			serverInfo[entries].connID = entries;
		}
		entries ++;

		/* advance pointers */

		fsNamePtr = fsNamePtr +48;
		idNamePtr = idNamePtr +32;
	}

	/* reset pointers to the beginning of the tables */

	fsNamePtr = fsNamePtr -384;
	idNamePtr = idNamePtr -256;

}	/* end GetServerInfo () */

/****************************************************************************
** saves all mapped drives, placing respective information into the
** control structure
****************************************************************************/
void SaveDriveMappings()
{
	int drv, I;
	char *pntr,*pntr2, *tpntr, tchr;


	for (drv = 0; drv < MAXMAPPINGS; drv++)
	{

		maps.drive[drv].dtype = NOTMAPPED;     /* is not being used       */
		maps.drive[drv].rootEnd = 0;           /* ?? if mapped root yet   */

		cCode = GetDriveInformation( (BYTE)drv,
									 &maps.drive[drv].connID,
									 &dirHandleNum );

		/* determine if local drive, permament or temporary or such
		** a combination */

		if ( cCode == LOCAL )
		{
			maps.drive[drv].dtype = (BYTE)LOCAL;
			maps.drive[drv].connID = 0;         /* no connection ID */
		} /* if */

		if ( dirHandleNum )
		{

			/* get filer server name if not local drv */

			GetFileServerName ( maps.drive[drv].connID,maps.drive[drv].path );

			/* must set preferred connection to obtain the path   */
			/* from the required server.                          */

			if ( connID != maps.drive[drv].connID )
			{
				connID = maps.drive[drv].connID;
				SetPreferredConnectionID ( maps.drive[drv].connID );
			} /* if */

			if ( GetDirectoryPath ( dirHandleNum,dirPath ) == 0 )
			{
				maps.drive[drv].dtype = (BYTE)cCode;
				strcat ( maps.drive[drv].path,"\\" );
				strcat ( maps.drive[drv].path,dirPath );

				/* Check if MAPped ROOT */

				sprintf ( thePath,"%c:",drv + 'A' );  /* set drive letter */

				/* obtain the path for the drive. NOTE: if mapped root   */
				/* the MAP ROOTed portion is not returned.               */

				ParsePath ( thePath, serverName, volume, tmpPath );

				/* if a 'path' was returned then get rid of trailing '\' */

				if ( tmpPath[0] )
				{
					tmpPath[strlen(tmpPath) - 1] = NULL;
				}

				/* To check if this is a MAPped ROOT, compare the paths  */
				/* returned from the 'ParsePath' api and the path we got */
				/* back from the 'GetDirectoryPath' api. If the paths do */
				/* NOT match we found a MAPped ROOT.  We must also       */
				/* determine the MAP ROOTed portion and any path off of  */
				/* the root                                              */

				if ( strcmp ( tmpPath,( strchr ( dirPath,':' ) + 1 ) ) )
				{

					/* calculate index where the root ends ('\') */

					maps.drive[drv].rootEnd =
							   (BYTE)( strstr(maps.drive[drv].path,tmpPath) -
							   maps.drive[drv].path );

					/* force NULL over the '\', the path off of the root  */
					/* can now be obtained via the path[rootEnd]          */

					maps.drive[drv].path[maps.drive[drv].rootEnd - 1] = NULL;
				}
			} /* if */
		} /* if */
	} /* for */

	/* use the PATH environment variable to obtain the             */
	/* search drive order which also includes local search paths.  */

	strcpy ( thePath, strupr( getenv ("PATH") ) );

	if ( thePath[0] != NULL )
	{
		drv = 0;
		pntr = thePath;

		/* loop all of PATH if processed */

		while ( ( drv < MAXSEARCHDRIVES ) && ( pntr = strchr(pntr,':' ) ) )
		{
			tpntr = pntr;

			/* if character after ':' = '.' then it's a search mapping, */
			/* otherwise it's a local drive specification               */

			if ( *(pntr + 1) == '.' )
			{
				maps.vector[drv] = *(pntr - 1) - 'A';
				maps.drive[maps.vector[drv]].search = SEARCHDRIVE;

				drv++;     /* advanced to next drive in path */
			}
			else
			{
				/* Local search drive. Find next available location in the  */
				/* drive table and assign the correct vector value          */

				for ( I = 0; ( maps.drive[I].dtype != NOTMAPPED ) &&
							 ( I < MAXMAPPINGS); I++ );

				if ( I < MAXMAPPINGS )
				{
					/* check for the ';' following each drive specifier.  */
					/* NOTE: on last one there may not be one so check    */
					/* for   NULL instead                                 */

					if ( ( pntr2 = strchr (pntr,';' ) ) == NULL )
					{
						pntr2 = strchr ( pntr, '\0' );
					}

					if ( pntr2 )
					{
						tchr = *pntr2;
						*pntr2 = '\0';
						pntr--;

						/* update the search drive order */

						maps.vector[drv] = (BYTE)I;
						maps.drive[I].dtype = 1;
						maps.drive[I].search = SEARCHDRIVE;

						/* copy the local drive specification */

						strcpy ( maps.drive[I].path,pntr );

						if (tchr != NULL)
						{
							*pntr2 = '|';
						}

						drv++;     /* advanced to next drive in path */
					}/* end if */
				} /* end if */
			} /* else */

			/* 0xFF marks end of search drive vector */

			if (drv <= MAXSEARCHDRIVES) maps.vector[drv] = ENDMARKER;

			*tpntr = ' ';    /* must STEP over current ':' for next search */
		 } /* while */
	}/* end if */
} /* SaveDriveMappings */

/****************************************************************************
** Function called by Int 24 Handler when other types of errors occur
****************************************************************************/
int ErrorWin ( char *msg )
{
	int retval;
	//
	cputs ( msg );

	while ( 1 )
	{
		retval = getch ();
		if (retval == 'a' || retval == 'A')
		{
			retval = ABORT;
			break;
		}
		if (retval == 'r' || retval == 'R')
		{
			retval = ABORT;
			break;
		}
		if (retval == 'i' || retval == 'I')
		{
			retval = ABORT;
			break;
		}
	}
	return ( retval );
}

#pragma warn -par

/***************************************************************************
** Critical Error Handler
***************************************************************************/
int Handler24 ( int errval, int ax, int bp,int si )
{
	BYTE     componentList[54], majorRevisionNumber, minorRevisionNumber;
	int      drive, entries, fsNameLen, retval, i;
	int      errorno;
	WORD     maxConnections,availableConnections;
	static   char msg[80];
	unsigned di;
	//

	/* error number that is returned from DOS */
	di = _DI;

	if ( ax < 0 )
	{
		ErrorWin ( "Device error" );
		hardretn ( ABORT );
	}

	/* the information concerning which drive letter failed will be */
	/* returned in the BH register                                  */

	asm {  /* must place this bracket here for inline assembly to work */
		 xor   bl,bl
		 xchg  bh,bl
		 mov   drive,bx
	}

	/* check for General Failure and Network drive */
	/* drv is a global var and set in the main ()  */
	if ( ( ( di && 0xC ) == 0x01 ) && ( drv > LASTDOSDRIVE ) )
	{
		entries = 1;

		while ( entries < 9 )
		{
			fsNameLen = strlen ( serverInfo[entries].fileServerName );


			/* look for fileserver name that has gone down */

			retval = strncmp ( serverInfo[entries].fileServerName,
							   maps.drive[drive].path,
							   fsNameLen );

			if ( retval == 0 )
				break;      /* found */

			entries++;
		}
		printf ("drive # %d has been down\n",drive);
		printf ( "Server %s has been down, %d\n",
				  serverInfo[entries].fileServerName, cCode );

		CleanShell ( serverInfo[entries].connID );
		serverInfo[entries].down = 1;   /* set flag that server is down */
//		IPXCloseSocket ( tempSocket );
		hardretn(ABORT);
	}

	else
	{
		errorno = di & 0x00FF;
		sprintf (msg,"Error: %s on drive %c\r\n",err_msg[errorno],'A'+drive);
		ErrorWin ( msg );
		hardretn ( ABORT );
	}

} /* end Handler24 */

#pragma warn +par

/****************************************************************************
** Reset the Slot In Use flag in the Connection ID Table
****************************************************************************/
void CleanShell ( int connID )
{
	char far *tempPtr;
	int i, chkStr;
	//
	tempPtr = idNamePtr;

	/* increment pointer size of table entry */
	idNamePtr = idNamePtr + ( ( connID - 1 ) * 32 );

	/* put 0 in the Slot In Use flag for that entry */
	*idNamePtr = 0;

	idNamePtr = tempPtr;

	DeleteMapDrives ( connID );

}   /* end CleanShell () */

/****************************************************************************
** Delete entries from the Drive Handle Table, the Drive Flag Table, and the
** Drive Connection ID Table
****************************************************************************/
void DeleteMapDrives ( int connID )
{
	int drv, sdrv, dummy;
//	char drvl, *pntr, chkStr;
	BYTE temp;
	//
	/* delete all drive references to the downed fileserver */

	for ( drv = 0; drv < MAXMAPPINGS; drv++ )
	{
		temp = *driveFlagPtr;            /* Clear Drive Flag table */
		if ( ( temp != 0x00) && ( maps.drive[drv].connID == connID ) )
		  *driveFlagPtr = 0x00;
		driveFlagPtr = driveFlagPtr + 1;

		temp = *driveConnIDPtr;          /* Clear Connection ID table */
		if ( ( temp != 0x00) && ( maps.drive[drv].connID == connID ) )
		  *driveConnIDPtr = 0x00;
		driveConnIDPtr = driveConnIDPtr + 1;

		temp = *driveHndlPtr;            /* Clear Connection Handle table */
		if ( ( temp != 0x00) && ( maps.drive[drv].connID == connID ) )
		  *driveHndlPtr = 0x00;
		driveHndlPtr = driveHndlPtr + 1;

	}
	/* reset pointers */

	driveFlagPtr = driveFlagPtr - ( MAXMAPPINGS );
	driveConnIDPtr = driveConnIDPtr - ( MAXMAPPINGS );
	driveHndlPtr = driveHndlPtr - ( MAXMAPPINGS );

}	/* end DeleteMapDrives () */

/***************************************************************************
** Check the down flag in serverInfo[] and pings those servers using
** PingNode ()
***************************************************************************/
void PingServers ( void )
{
	int   entries;
	BYTE  majorRevisionNumber, minorRevisionNumber, componentList[54];
	WORD  maxConnections,availableConnections, SPXconnectionID;
	WORD  tempSocket;

	cCode = SPXInitialize( &majorRevisionNumber,
						   &minorRevisionNumber,
						   &maxConnections,
						   &availableConnections);

	if ( cCode != 0xFF )
	{
		printf ( "Unable to ping server\n" );
		printf ( "SPXInitialize failed. ccode = %d\n", cCode );
		exit ( 1 );
	}

	tempSocket = 0x00;

	cCode = IPXOpenSocket ( (BYTE *)&tempSocket, 0 );

	if ( cCode != 0 )
	{
		printf ( "Unable to ping server\n" );
		printf ( "IPXOpenSocket failed. ccode = %d\n", cCode );
		IPXCloseSocket ( tempSocket );
		exit (1);
	}

	*(WORD *)destination.socket = (WORD)IntSwap ( 0x0456 );


	for ( entries = 1; entries < 9; entries++ )
	{

		/* search only for those servers who are down */

		if ( serverInfo[entries].down == 1 )
		{
			/* get the server address */

			memmove (destination.network,serverInfo[entries].network,4);
			memmove (destination.node,serverInfo[entries].node,6);

			/* call to ping a particular server */

			cCode = PingNode ( &destination );

			if ( cCode == 0 )
			{
				printf ( "Server %s is up\n",
						  serverInfo[entries].fileServerName);
				ReConnectServer ( entries );
			}
		}
	}
	IPXCloseSocket ( tempSocket );

} /* end PingServers () */

/***********************************************************************
**Ping the Server
***********************************************************************/
int PingNode ( BeginDiagnosticStruct *destination )
{
	static struct
	{
		BYTE    exclusionCount;
	} IPXReqstPkt = { (BYTE)NULL };

	static struct
	{
		BYTE    majorVer;
		BYTE    minorVer;
		WORD    SPXDiagSocket;
		BYTE    compCnt;
		BYTE    compType[53];
	} IPXReplyPkt;

	static ECB         IPXSendECB,IPXReceiveECB;
	static IPXHeader   IPXSendPkt,IPXReceivePkt;
		  WORD        tempSocket,startTicks,endTicks;
		  int         tTime;
	//
	tempSocket = (WORD)0x4545;
	if( IPXOpenSocket((BYTE *)&tempSocket, 0) )
		return 1;

	IPXReceiveECB.socketNumber = tempSocket;
	IPXReceiveECB.fragmentCount = 2;
	IPXReceiveECB.fragmentDescriptor[0].size = sizeof(IPXReceivePkt);
	IPXReceiveECB.fragmentDescriptor[1].size = sizeof(IPXReplyPkt);

	IPXGetDataAddress((BYTE *)(&IPXReceivePkt),
					 (WORD *)&IPXReceiveECB.fragmentDescriptor[0].address);

	IPXGetDataAddress((BYTE *)&IPXReplyPkt,
					 (WORD *)&IPXReceiveECB.fragmentDescriptor[1].address);

	IPXGetLocalTarget((BYTE *)destination,
					 (BYTE *)IPXReceiveECB.immediateAddress, &tTime);

	IPXListenForPacket(&IPXReceiveECB);


	IPXSendPkt.destination = *(IPXAddress *)destination;

	*(WORD *)IPXSendPkt.destination.socket = (WORD)0x5604;
	*(WORD *)IPXSendPkt.source.socket = tempSocket;

	IPXSendPkt.packetType = 4;

	IPXGetInternetworkAddress((BYTE *)&IPXSendPkt.source);

	IPXGetLocalTarget((BYTE *)IPXSendPkt.destination.network,
					 IPXSendECB.immediateAddress, &tTime);

	IPXSendECB.socketNumber = tempSocket;
	IPXSendECB.fragmentCount = 2;
	IPXSendECB.fragmentDescriptor[0].size = sizeof(IPXSendPkt);
	IPXSendECB.fragmentDescriptor[1].size = sizeof(IPXReqstPkt);

	IPXGetDataAddress((BYTE *) (&IPXSendPkt),
					 (WORD *) &IPXSendECB.fragmentDescriptor[0].address);

	IPXGetDataAddress((BYTE *) &IPXReqstPkt,
					 (WORD *) &IPXSendECB.fragmentDescriptor[1].address);

	IPXSendPacket(&IPXSendECB);

	while( IPXSendECB.inUseFlag )
		IPXRelinquishControl();

	startTicks = IPXGetIntervalMarker();

	while( IPXReceiveECB.inUseFlag )
	{
		IPXRelinquishControl();              /* if node does not respond */
		endTicks = IPXGetIntervalMarker();   /* in 4 seconds....         */
		if( endTicks - startTicks > 72 )
			break;
	}

	IPXCloseSocket( tempSocket );          /* ....then cancel send */

	if( IPXSendECB.completionCode != 0 )
		return IPXSendECB.completionCode;

	if( IPXReceiveECB.inUseFlag || IPXReceiveECB.completionCode )
		return IPXReceiveECB.completionCode;   /* no response */

	return 0;
}   // end PingNode


/**************************************************************************
** Reattach to the fileserver
**************************************************************************/
void ReConnectServer ( int entries )
{
	BYTE netAddress[12];
	char objName[48],			// string containing bindery name
		 dirPath[255],			// string containing path specification
		 passWord[48],			// string containing object's password
		 ch;					// char holder for getch()
	int  i,						// index for passWord[]
		 cCode;					// status code from NW functions
	WORD defaultConnectionID,	// connection ID of default file server
		 preferredConnectionID;	// connectionID of primary file server
	//

	memmove ( netAddress, &serverInfo[entries].network, 12 );

	cCode = AttachToFileServerWithAddress
			( serverInfo[entries].fileServerName,
			  &preferredConnectionID, netAddress );

	if ( ( cCode ) && ( cCode != 248 ) )
		printf ( "AttachToFileServer Failed. cCode = %d\n", cCode );
	else
	{
		printf ( "FSName in Reconnect %s\n", serverInfo[entries].fileServerName );


		/* get the new connection ID since it could have changed */
		SetPreferredConnectionID ( preferredConnectionID );

		printf ( "Enter User Name and Password to Login to File Server\n" );
		printf ( "----------------------------------------------------\n" );
		printf ( "User Name : " );
		strupr ( gets ( objName ) );
		printf ( "\nPassword  : " );
		i = 0;
		do
		{
			ch = getch ();
			passWord[i++] = toupper ( ch );
			if ( ch == CR )
			{
				passWord[i - 1] = '\0';
			}
		} while ( ch != CR );
		printf ( "\n\n" );
		//
		cCode = LoginToFileServer ( objName, OT_USER, passWord );
		if ( cCode )
		{
			printf ( "LoginToFileServer returned a [%X]\n", cCode );
			DetachFromFileServer ( preferredConnectionID );
			exit ( -1 );
		}
		else
		{
			serverInfo[entries].connID = preferredConnectionID;
			serverInfo[entries].down = 0;
			ResetDriveMappings ( &serverInfo[entries].fileServerName,
								 preferredConnectionID );
		}
	}	// end if-else
}	// end ReconnectServer () */

/********************************************************************
** Maps the supplied drive and path as a Mapped Root
** Input Parameters:
**    int drv - A = 0, B = 1...
**    char far *rpath - must be FAR pointer to string
********************************************************************/
int MapRoot ( int drv, char far *rpath )
{
	union   REGS    regs;
	struct  SREGS   sregs;

	regs.x.ax = 0xE905;             /* Map Root function code - AX = E905h  */
	regs.x.bx = drv + 1;            /* A = 1, B = 2....                     */
	regs.x.dx = FP_OFF(rpath);      /* DX - offset of path                  */
	sregs.ds  = FP_SEG(rpath);      /* DS - segment of path                 */

	intdosx(&regs,&regs,&sregs);
	return(regs.h.al);               /* error code return in AL */
}  /* end MapRoot() */

/*******************************************************************
** Restore the the drive mappings saved in the conrol structure
********************************************************************/
void ResetDriveMappings ( char *serverName, WORD newConnID )
{
	int drv, len;
	char drvl, *pntr;
	unsigned sdrv, dummy;
	//

	/* 1st reset a the non-search drives.  Actually all mapped drives */
	/* are reset, since search drives are only mapped drives that are */
	/* specified in the PATH environment variable.                    */


	for ( drv = LASTDOSDRIVE; drv < MAXMAPPINGS; drv++ )
	{
		/* if connection ID specified for drive, then reset it,  */
		/* otherwise it's a local mapping only                   */

		len = strlen ( serverName );

		if ( strncmp ( serverName,maps.drive[drv].path,len ) == 0 )
		{
			/* if MAPped ROOT, then set the root and then modify the */
			/* path off of that root if necessary                    */

			if ( maps.drive[drv].rootEnd )
			{

				/* display only non-search drives at this time */

				if ( maps.drive[drv].search != SEARCHDRIVE )
				{
					printf ( "\nDrive:  %c := %s \\%s\\",'A' + (char)drv,
							 maps.drive[drv].path,
							 &maps.drive[drv].path[maps.drive[drv].rootEnd]
						   );
				}

				SetPreferredConnectionID ( newConnID );

				cCode = MapRoot ( drv, (char far *)maps.drive[drv].path );
				if (cCode)
				{
					printf ("\nError MapRoot: %d",cCode );
					exit (1);
				}

				/* update the structure with new connection ID */
				maps.drive[drv].connID = newConnID;

				/* if not at root, then set the path off of the root */

				if ( maps.drive[drv].path[maps.drive[drv].rootEnd] != NULL )
				{
					_dos_getdrive ( &sdrv );
					_dos_setdrive ( drv, &dummy );
					chdir( &maps.drive[drv].path[maps.drive[drv].rootEnd] );
					_dos_setdrive ( sdrv, &sdrv );
				} /* if */
			} /* if */
			else
			{
				/* display only non-search drives at this time */

				if ( maps.drive[drv].search != SEARCHDRIVE )
				{
					printf( "\nDrive:  %c := %s ",'A' + (char)drv,
							maps.drive[drv].path );
				}

				drvl = (char)( drv + 'A' );
				cCode = MapDrive( newConnID, NO_BASE_DRIVE,
								  maps.drive[drv].path,
								  DRIVE_ADD, 0, &drvl);

				if ( cCode )
				{
					printf ( "\nError MapDrive: %d", cCode );
					exit(1);
				} /* if */

				/* update the structure with new connection ID */
				maps.drive[drv].connID = newConnID;

			} /* else */

		} /* end if */

	} /* for */

	/* now display the search drives & create the PATH variable */

	printf("\n-----");

	pntr = thePath;

	for ( drv = 0; ( maps.vector[drv] != ENDMARKER) &&
				   ( drv < MAXSEARCHDRIVES ); drv++ )
	{
		if ( maps.vector[drv] < MAXMAPPINGS )
		{
			/* only reset the a NetWare mapped drives */
			/* NOTE: local search drives set only via */
			/* the PATH variable                      */

			if (maps.drive[maps.vector[drv]].connID )

			{
				drvl = maps.vector[drv] + 'A';

				printf ( "\nSearch %2d := [%c:%s",drv + 1, drvl,
						 maps.drive[maps.vector[drv]].path );

				if ( maps.drive[maps.vector[drv]].rootEnd )
				{
					printf (" \\%s\\ ",
							&maps.drive[drv].path[maps.drive[drv].rootEnd] );
				}
				printf("]\n");

				/* place the drive letter into the path followed by ':.;' */
				sprintf ( pntr,"%c:.;",
						  (char)(maps.vector[drv] + 'A' ) );
				pntr += 4;
			}
			else if ( drv <= LASTDOSDRIVE )
			{
			   /* force local drive & path mapping into PATH */

				strcpy ( pntr,maps.drive[maps.vector[drv]].path );
				if ( pntr = strchr ( pntr,NULL ) )
				{
					*pntr++ = ';';
					*pntr = NULL;
				}
			} /* else */
		} /* if */
	} /* for */

	/*-- UPDATE THE DOS PATH VARIABLE --*/

	PutEnvironmentVariable( "PATH", thePath );

} /* end ResetDriveMappings () */


void main ( void )
{
	char ret,strdrv[2];
	int fh,i,entries;
	WORD connectionID;
	BYTE dirHandle;


	GetServerInfo ();
	defaultConnID = GetDefaultConnectionID();
	SaveDriveMappings();
	harderr ( Handler24 );

	printf ( "Go down server\n" );
	printf ( "Press Any Key After Servers Are Down\n" );
	getch();
	printf ( "Searching...\n\n" );

	ret = 0x00;

	while (ret != 's')
	{
		for (drv = LASTDOSDRIVE; drv < MAXMAPPINGS; drv ++)
		{
			entries = 1;

			while ( ( maps.drive[drv].connID ==  serverInfo[entries].connID )
					 && serverInfo[entries].down != 0 )
				entries++;

			strdrv[0] = (char)( drv + 'A' );
			strdrv[1] = ':';
			chdir ( strdrv );

		}
		PingServers ();    /* check to see if any servers have returned */
		printf ( "Hit any key to continue; s to quit\n" );
		ret = getch ();
		printf ( "\nSearching...\n" );
	}

	SetPreferredConnectionID(defaultConnID);

}  /* main */
