@echo off
rem                         Don Olson 72066,101  1-94
rem
rem           WANT SMOOTHER DOOM GRAPHICS ON YOUR DOOM MACHINE?
rem
rem       (Requires 5-12MB free disk space and 8-16MB system memory.)
rem
rem This batch file will work with either the shareware or registered versions
rem   of DOOM v1.1, caching the appropriate file.  The greater values shown
rem   above are for the registered version.
rem
rem This batch file will cache the Doom data file for hesitation free blood
rem   letting (a lot of the 'jumpiness' during play is disk access to the
rem   .WAD file).  You can eliminate all physical disk access to the .WAD
rem   file during play by caching the whole .WAD file prior to play...
rem
rem This batch file resides in the DOOM directory (NOT C:\DOOMDATA) and is
rem   used to RUN DOOM.  You must type DOOM.BAT instead of just DOOM, because
rem   DOS will execute an .EXE before a .BAT file!
rem
rem It assumes that you have the 8-16MB of memory, 4MB for DOOM and 4-12MB for 
rem   Smartdrv, and enough free disk space (4.2MB free for shareware DOOM v1.1,
rem   10.2MB free for the registered DOOM v1.1 file) to copy the .WAD data file
rem   so that Smartdrv can read cache the entire file it as it copies it before
rem   running DOOM.
rem
rem You must set up Smartdrv to be 4-12MB+ prior to executing this file, or if
rem   you aren't using it allready, add it to the beginning of this file.
rem For best results:
rem   Initialize Smartdrv in AUTOEXEC.BAT and optimize your system it using MEMMAKER
rem   or OPTIMIZE, etc, for best memory management.  The basic line should
rem   be something like DRIVE:\PATH\SMARTDRV 4096 or DRIVE:\PATH\SMARTDRV 12288.
rem   If you have the memory, a little overkill on the Smartdrv value doesn't
rem   hurt much either...  there is disk access on startup to other DOOM files
rem   that will bump some (or all?) the .WAD file out of the cache buffer.
rem   Using DOS 6's menuing system makes different start-ups pretty easy if you
rem   aren't allready using them, also.
rem
rem
rem
rem The scoop:
rem   This setup below is for a system with an A, C, and D drives with DOOM on
rem   the D: drive.  You can change the drives as needed for your system.  The
rem   key to the whole deal is to have Smartdrv READ CACHE ONLY the DOOM drive,
rem   disable caching on all other drives.
rem
rem Note that in the following Smartdrv status examples, the 'buffering' value
rem   doesn't really matter, it is dependent on your system...  it can be YES
rem   or NO, it doesn't matter.
rem
rem
rem Do it...
rem
rem Make sure we are in the DOOM directory...
if not exist doom.exe goto ERROR
rem
rem Reset Smartdrv to be READ CACHE on Doom drive only (D in this case),
rem   all other drives disabled.  You can check to see if Smartdrv is set
rem   correctly by deleting the /Q on the command line.  The Smartdrv display
rem   should then show the following BEFORE DOOM RUNS:
rem
rem                        Disk Caching Status
rem            drive   read cache   write cache   buffering
rem            --------------------------------------------
rem              D:       yes           no           no
rem
rem Turn off all caching on the A and C drives, D is read only...
smartdrv a- c- d /q
rem
rem Copy .WAD to some place with enough space so the copy is complete,
rem   then delete it.  Smartdrv will 'read cache' the .WAD file as it copies it.
rem   In this case, it's just copied to a file named junk.jnk in the DOOM
rem   directory.  You can copy it to any directory/drive that has enough
rem   free space.
echo Caching Doom data...
if exist doom1.wad set wad=doom1.wad
if exist doom.wad set wad=doom.wad
copy %wad% junk.jnk > nul
set wad=
del junk.jnk > nul
rem
rem Now run DOOM.  Watch the DEMO and the disk LED on your system.  The LED
rem   shouldn't light at all AFTER the demo starts.  Notice that the display
rem   is much more smooth, especially when entering an area for the first 
rem   time...
doom.exe
rem
rem Done playing, so reset Smartdrv to its initial state.
rem
rem Again, you can ommit the /Q from the command line to see how Smartdrv
rem   is actually set.  Your system should have caching status something like
rem   this (your usage may vary)...
rem 
rem                        Disk Caching Status
rem            drive   read cache   write cache   buffering
rem            --------------------------------------------
rem              A:       yes           no           no
rem              C:       yes           yes          no
rem              D:       yes           yes          no
rem 
smartdrv a c+ d+ /q
echo Now there's a good use for all that extra RAM, eh?
goto END
:ERROR
echo DOOM.BAT must reside in the DOOM directory...
:END

