/*
 * tutor5.c - Turbo C version of Jack Crenshaw's compiler cradle lesson #5.
 *
 */
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include <string.h>
#include <stdarg.h>

#define TAB	9
#define IsAlpha(c) isalpha ((c))
#define IsDigit(c) isdigit ((c))
#define UpCase(c)  toupper ((c))
#define IsAddop(c) (c) == '+' || (c) == '-'
#define IsMulop(c) (c) == '*' || (c) == '/'
#define IsAlNum(c) isalnum ((c))
#define IsWhite(c) (c) == ' ' || (c) == TAB

char Look;	/* lookahead character */
int  LCount;	/* label counter */

/* forward definitions for certain items */
void Block (char *l);

/*
 * Read New Character From Input Stream
 */
void GetChar (void) {
    Look = getchar ();
}

/*
 * Report an Error
 */
void Error (char *fmt, ...) {
    va_list (args);

    printf ("\n\007Error: ");
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
    printf ("\n");
}

/*
 * Report Error and Halt
 */
void Abort (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    Error (fmt, args);
    va_end (args);
    exit (1);
}

/*
 * Report What Was Expected
 */
void Expected (char *fmt, ...) {
    va_list args;
    char f[81];

    va_start (args, fmt);
    strcpy (f, fmt);
    Abort (strcat (f, " Expected"), args);
    va_end (args);
}

/*
 * Match a Specific Input Character
 */
void Match (char x) {
    char s[4];

    if (Look == x)
        GetChar ();
    else {
        sprintf (s, "'%c'", x);
        Expected (s);
    }
}

/*
 * skip over leading white space
 */
void SkipWhite (void) {
    while (IsWhite (Look))
	GetChar ();
}

/*
 * Get an Identifier
 */
char GetName (void) {
    char c;

    if (! IsAlpha (Look))
        Expected ("Name");
    c = UpCase (Look);
    GetChar ();
    return (c);
}

/*
 * Get a Number
 */
char GetNum (void) {
    char c;
    if (! IsDigit (Look))
        Expected ("Integer");
    c = Look;
    GetChar ();
    return (c);
}

/*
 * Generate a unique label
 */
char *NewLabel (void) {
    char s[80];
    sprintf (s, "L%d", LCount++);
    return (s);
}

/*
 * Post a label to output
 */
void PostLabel (char *L) {
    printf ("%s:\n", L);
}

/*
 * Output a String with Tab
 */
void Emit (char *fmt, ...) {
    va_list args;

    printf ("%c", TAB);
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
}

/*
 * Parse and Translate a Boolean Condition
 */
void Condition (void) {
    Emit ("<condition>\n");
}

/*
 * Parse and Translate a Math Expression
 */
void Expression (void) {
    Emit ("<expr>\n");
}

/*
 * Recognize and Translate an IF Construct
 */
void DoIf (char *L) {
    char L1[10], L2[10];

    Match ('i');
    Condition ();
    strcpy (L1, NewLabel ());
    strcpy (L2, L1);
    Emit ("JNZ %s\n", L1);
    Block (L);
    if (Look == 'l') {
	Match ('l');
	strcpy (L2, NewLabel ());
	Emit ("JMP %s\n", L2);
	PostLabel (L1);
	Block (L);
    }
    Match ('e');
    PostLabel (L2);
}

/*
 * Parse and Translate a WHILE Statement
 */
void DoWhile (void) {
    char L1[10], L2[10];

    Match ('w');
    strcpy (L1, NewLabel ());
    strcpy (L2, NewLabel ());
    PostLabel (L1);
    Condition ();
    Emit ("JNZ %s\n", L2);
    Block (L2);
    Match ('e');
    Emit ("JMP %s\n", L1);
    PostLabel (L2);
}

/*
 * Parse and Translate a LOOP Statement
 */
void DoLoop (void) {
    char L1[10], L2[10];

    Match ('p');
    strcpy (L1, NewLabel ());
    strcpy (L2, NewLabel ());
    PostLabel (L1);
    Block (L2);
    Match ('e');
    Emit ("JMP %s\n", L1);
    PostLabel (L2);
}

/*
 * Parse and Translate a REPEAT Statement
 */
void DoRepeat (void) {
    char L1[10], L2[10];

    Match ('r');
    strcpy (L1, NewLabel ());
    strcpy (L2, NewLabel ());
    PostLabel (L1);
    Block (L2);
    Match ('u');
    Condition ();
    Emit ("JNZ %s\n", L1);
    PostLabel (L2);
}

/*
 * Parse and Translate a FOR Statement
 */
void DoFor (void) {
    char L1[10], L2[10], Name;

    Match ('f');
    strcpy (L1, NewLabel ());
    strcpy (L2, NewLabel ());
    Name = GetName ();
    Match ('=');
    Expression ();
    Emit ("DEC AX\n");
    Emit ("MOV %c, AX\n", Name);
    Expression ();
    Emit ("PUSH AX\n");
    PostLabel (L1);
    Emit ("INC %c\n", Name);
    Emit ("POP AX\n");
    Emit ("CMP AX, %c\n", Name);
    Emit ("JNC %s\n", L2);
    Emit ("PUSH AX\n");
    Block (L2);
    Match ('e');
    Emit ("JMP %s\n", L1);
    PostLabel (L2);
}

/*
 * Parse and Translate a DO Statement
 */
void DoDo (void) {
    char L1[10], L2[10];

    Match ('d');
    strcpy (L1, NewLabel ());
    strcpy (L2, NewLabel ());
    Expression ();
    Emit ("DEC AX\n");
    PostLabel (L1);
    Emit ("PUSH AX\n");
    Block (L2);
    Emit ("POP AX\n");
    Emit ("DEC AX\n");
    Emit ("JNZ %s\n", L1);
    Emit ("PUSH AX\n");
    PostLabel (L2);
    Emit ("POP AX\n");
}

/*
 * Recognize and Translate a BREAK
 */
void DoBreak (char *L) {
    Match ('b');
    Emit ("JMP %s\n", L);
}

/*
 * Recognize and Translate an "Other"
 */
void Other (void) {
    Emit ("%c\n", GetName ());
}

/*
 * Recognize and Translate a Statement Block
 */
void Block (char *L) {
    while (strchr ("elu", Look) == NULL) {
	switch (Look) {
	    case 'i' : DoIf (L); 	break;
	    case 'w' : DoWhile (); 	break;
	    case 'p' : DoLoop (); 	break;
	    case 'r' : DoRepeat ();	break;
	    case 'f' : DoFor ();	break;
	    case 'd' : DoDo ();		break;
	    case 'b' : DoBreak (L);	break;
	    default  : Other ();	break;
	}
    }
}

/*
 * Parse and Translate a Program
 */
void DoProgram (void) {
    Block ("");
    if (Look != 'e')
	Expected ("End");
    Emit ("END\n");
}

/*
 * Initialize
 */
void Init (void) {
    LCount = 0;
    GetChar ();
}

/*
 * Main Program
 */
void main (void) {
    Init ();
    DoProgram ();
}
