/*
 * tutor4.c - Turbo C version of Jack Crenshaw's compiler lesson 4.
 *
 */
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include <string.h>
#include <stdarg.h>

#define	CR	'\n'
#define TAB	9
#define IsAlpha(c) isalpha ((c))
#define IsDigit(c) isdigit ((c))
#define UpCase(c)  toupper ((c))
#define IsAddop(c) (c) == '+' || (c) == '-'
#define IsMulop(c) (c) == '*' || (c) == '/'
#define IsAlNum(c) isalnum ((c))

char Look;			/* lookahead character */

int Table[26];                  /* Table of Variables */

int Expression (void);

/*
 * Read New Character From Input Stream
 */
void GetChar (void) {
    Look = getchar ();
}

/*
 * Report an Error
 */
void Error (char *fmt, ...) {
    va_list (args);

    printf ("\n\007Error: ");
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
    printf ("\n");
}

/*
 * Report Error and Halt
 */
void Abort (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    Error (fmt, args);
    va_end (args);
    exit (1);
}

/*
 * Report What Was Expected
 */
void Expected (char *fmt, ...) {
    va_list args;
    char f[81];

    va_start (args, fmt);
    strcpy (f, fmt);
    Abort (strcat (f, " Expected"), args);
    va_end (args);
}

/*
 * Match a Specific Input Character
 */
void Match (char x) {
    char s[4];

    if (Look == x)
        GetChar ();
    else {
        sprintf (s, "'%c'", x);
        Expected (s);
    }
}

/*
 * Recognize and Skip Over a Newline
 */
void NewLine (void) {
    if (Look == CR)
	GetChar ();
}

/*
 * Get an Identifier
 */
char GetName (void) {
    char c;

    if (! IsAlpha (Look))
        Expected ("Name");
    c = UpCase (Look) - 'A';
    GetChar ();
    return (c);
}

/*
 * Get a Number
 */
int GetNum (void) {
    int Value = 0;

    if (! IsDigit (Look))
        Expected ("Integer");
    while (IsDigit (Look)) {
	Value = 10 * Value + Look - '0';
        GetChar ();
    }
    return (Value);
}

/*
 * Output a String with Tab
 */
void Emit (char *fmt, ...) {
    va_list args;

    printf ("%c", TAB);
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
}
/*
 * Initialize the Variable Array
 */
void InitTable (void) {
    memset (Table, 0, sizeof (Table));
}

/*
 * Initialize
 */
void Init (void) {
    InitTable ();
    GetChar ();
}

/*
 * Parse and Translate a Math Factor
 */
int Factor (void) {
    int Value;

    if (Look == '(') {
	Match ('(');
	Value = Expression ();
	Match (')');
    }
    else if (IsAlpha (Look))
	Value = Table [GetName ()];
    else
	Value = GetNum ();
    return (Value);
}

/*
 * Parse and Translate a Math Term
 */
int Term (void) {
    int Value;

    Value = Factor ();
    while (IsMulop (Look)) {
	switch (Look) {
	    case '*' : {
		Match ('*');
		Value *= Factor ();
		break;
	    }
	    case '/' : {
		Match ('/');
		Value /= Factor ();
		break;
	    }
	}
    }
    return (Value);
}

/*
 * Parse and Translate an Expression
 */
int Expression (void) {
    int Value;

    if (IsAddop (Look))
	Value = 0;
    else
	Value = Term ();
    while (IsAddop (Look)) {
	switch (Look) {
	    case '+' : {
		Match ('+');
		Value += Term ();
		break;
	    }
	    case '-' : {
		Match ('-');
		Value -= Term ();
		break;
	    }
	}
    }
    return (Value);
}

/*
 * Parse and Translate an Assignment Statement
 */
void Assignment (void) {
    char Name;

    Name = GetName ();
    Match ('=');
    Table [Name] = Expression ();
}

/*
 * Input Routine
 */
void Input (void) {
    char c;

    Match ('?');
    c = GetName ();
    Table [c] = GetNum ();
}

/*
 * Output Routine
 */
void Output (void) {
    Match ('!');
    printf ("%d\n", Table [GetName ()]);
}

/*
 * Main Program
 */
void main (void)
{
    Init ();
    do {
        switch (Look) {
	    case '?' : Input (); break;
	    case '!' : Output (); break;
	    default  : Assignment (); break;
	}
	NewLine ();
    } while (Look != '.');
}
