#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <time.h>
#include "global.h"
#include "mbuf.h"
#include "socket.h"
#include "telnet.h"
#include "session.h"
#include "proc.h"
#include "tty.h"
#include "mailbox.h"
#include "commands.h"
#include "cmdparse.h"
#include "netuser.h"

static char Motd[85];
int Attended = TRUE;
static int16 Bell = 2;

int
dobell(int argc,char **argv,void *p)
{
	return setintrc(&Bell,"Bell",argc,argv,0,10);
}

/* if flag is set - restrict ax25, telnet and maybe other sessions */
int
doattended(int argc,char **argv,void *p)
{
	return setbool(&Attended,"Attended",argc,argv);
}

int
domotd(int argc,char **argv,void *p)
{
	int i;

	if(argc < 2) {
		if(Motd[0] != '\0')
			tputs(Motd);
	} else {
		Motd[0] = '\0';

		for(i = 1; i < argc; i++) {
			strcat(Motd,argv[i]);
			if(strlen(Motd) > 80)
				break;
			strcat(Motd," ");
		}
		if(strlen(Motd) > 2)
			strcat(Motd,"\n\0");
		else
			Motd[0] = '\0';
	}
	return 0;
}

/* This function handles all incoming "chat" sessions, be they TCP,
 * NET/ROM or AX.25
 */
void
ttylhandle(int s,void *t,void *p)
{
	struct session *sp;
	char addr[MAXSOCKSIZE];
	struct telnet tn;
	char *cp, *cp1;
	int len = MAXSOCKSIZE, type = (int) t;

	sockowner(s,Curproc);	/* We own it now */
	sockmode(s,SOCK_ASCII);

	/* Allocate a session descriptor */
    if((sp = newsession(NULLCHAR,type,SPLIT)) == NULLSESSION) {
		usputs(s,Nosess);
		close_s(s);
		return;
	}

	log(s,9983,"%4.4s open",Sestypes[type]);

	/* Initialize a Telnet protocol descriptor */
	memset(&tn,0,sizeof(struct telnet));

	tn.session = sp;			/* Upward pointer */
	sp->cb.telnet = &tn;		/* Downward pointer */
	sp->s = s;
	sp->proc = Curproc;

	getpeername(sp->s,addr,&len);
	cp1 = strxdup(psocket(addr));

    if((cp = strchr(cp1,':')) != NULLCHAR) {
		*cp = '\0';
    }
	tprintf("Incoming %s session from %s at %s",
		Sestypes[type],cp1,ctime(&currtime));

	if(strcmp(cp1,inet_ntoa(Ip_addr)) == 0) {
		xfree(cp1);
		sp->name = strxdup("Chat");
	} else {
		sp->name = cp1;
	}

    if(Attended && Bell) {
        if(Mtasker) {
			putch(7);
        } else {
            int val = Bell;
            
            while(val-- > 0) {
                sound(320);
                delay(160);
                sound(480);
                delay(160);
                sound(640);
                delay(160);
                nosound();
                pwait(NULL);
            }
        }
    }
    if(Motd != NULLCHAR) {
		usputs(s,Motd);
    }
	usprintf(s,"%s - I'm %s...\n",Hostname,
		Attended ? "here" : "absent. Pse leave msg");

	tnrecv(&tn);
}

