#ifndef	_PROC_H
#define	_PROC_H

#include <setjmp.h>

#ifndef _MBUF_H
#include "mbuf.h"
#endif

#ifndef	_TIMER_H
#include "timer.h"
#endif

#define	PHASH	16				/* Number of wait table hash chains */

/* Kernel process control block */
struct proc {
	struct proc *next;			/* linked list pointer */
	jmp_buf env;				/* Process state */
	int i_state;				/* Process interrupt state */
	unsigned short state;
#define	READY	0
#define	WAITING	1
#define	SUSPEND	2
	void *event;				/* Wait event */
	int16 *stack;				/* Process stack */
	unsigned int stksize;		/* Size of same */
	char name[20];				/* Arbitrary user-assigned name */
	void *retval;				/* Return value from next pwait() */
	struct timer alarm;			/* Alarm clock timer */
	int input;					/* standard input socket */
	int output;					/* standard output socket */
	int iarg;					/* Copy of iarg */
	void *parg1;				/* Copy of parg1 */
	void *parg2;				/* Copy of parg2 */
	int freeargs;				/* Free args on termination if set */
};
#define NULLPROC (struct proc *)0

extern int Stkchk;				/* Stack checking flag */

extern struct proc *Curproc;	/* Currently running process */
extern struct proc *Rdytab;		/* Head of ready list */
extern struct proc *Waittab;	/* Head of wait list */
extern struct proc *Susptab;	/* Suspended processes */

/* In  kernel.c: */
void alert __ARGS((struct proc *pp,void *val));
void chname __ARGS((struct proc *pp,char *newname));
void killproc __ARGS((struct proc *pp));
void killself __ARGS((void));
struct proc *mainproc __ARGS((char *name));
struct proc *newproc __ARGS((char *name,unsigned int stksize,
	void (*pc) __ARGS((int,void *,void *)),
	int iarg,void *parg1,void *parg2,int freeargs));
int psignal __ARGS((void *event,int n));
void *pwait __ARGS((void *event));
void resume __ARGS((struct proc *pp));
void semwait __ARGS((int *sema,int req));
void semrel  __ARGS((int *sema));
void suspend __ARGS((struct proc *pp));

/* In ksubr.c: */
void chkstk __ARGS((void));
void kinit __ARGS((void));
void psetup __ARGS((struct proc *pp,int iarg,void *parg1,void *parg2,
	void  __ARGS(((*pc) __ARGS((int,void *,void *)) )) ));

/* Stack background fill value for high water mark checking */
#define	STACKPAT	0x55aa

#endif	/* _PROC_H */
