/* Miscellaneous format conversion subroutines */
#include <ctype.h>
#include <stdio.h>
#include "global.h"
#include "netuser.h"
#include "socket.h"
#include "domain.h"

/* Convert Internet address in ascii dotted-decimal format (44.0.0.1) to
 * binary IP address
 */
int32
aton(char *s)
{
	int i;
	int32 n = 0;

	if(s == NULLCHAR)
		return 0;

	for(i = 24; i >= 0; i -= 8) {
		/* Skip any leading stuff (e.g., spaces, '[') */
		while(*s != '\0' && !isdigit(*s))
			s++;
		if(*s == '\0')
			break;
		n |= (int32)atoi(s) << i;

		if((s = strchr(s,'.')) == NULLCHAR)
			break;
		s++;
	}
	return n;
}

/* Convert an internet address (in host byte order) to a dotted decimal ascii
 * string, e.g., 255.255.255.255\0
 */
char *
inet_ntoa(int32 a)
{
	static char buf[20], *name;

	if(DTranslate && (name = resolve_a(a,!DVerbose)) != NULLCHAR) {
		sprintf(buf,"%.16s",name);
	} else {
		sprintf(buf,"%u.%u.%u.%u",
			hibyte(hiword(a)),lobyte(hiword(a)),
			hibyte(loword(a)),lobyte(loword(a)) );
	}
	return buf;
}

/* Convert hex-ascii string to long integer */
long
htol(char *s)
{
	long ret = 0;
	char c;

	while((c = *s++) != '\0'){
		c &= 0x7f;
		if(c == 'x')
			continue;	/* Ignore 'x', e.g., '0x' prefixes */
		if(c >= '0' && c <= '9')
			ret = ret * 16 + (c - '0');
		else if(c >= 'a' && c <= 'f')
			ret = ret * 16 + (10 + c - 'a');
		else if(c >= 'A' && c <= 'F')
			ret = ret * 16 + (10 + c - 'A');
		else
			break;
	}
	return ret;
}

/* Return character string corresponding to a TCP well-known port,
 * or the decimal number if unknown.
 */
char *
tcp_port(int16 n)
{
	switch(n){
	/* tcp ports */
	case IPPORT_ECHO:
		return "echo";
	case IPPORT_DISCARD:
		return "discard";
	case IPPORT_FTPD:
		return "ftp_data";
	case IPPORT_FTP:
		return "ftp";
	case IPPORT_TELNET:
		return "telnet";
	case IPPORT_SMTP:
		return "smtp";
	case IPPORT_FINGER:
		return "finger";
	case IPPORT_TTYLINK:
		return "chat";
	case IPPORT_POP:
		return "pop2";
	case IPPORT_NNTP:
		return "nntp";
	case IPPORT_CONVERS:
		return "convers";
	case IPPORT_XCONVERS:
		return "xconvers";

	/* udp ports */
    case IPPORT_TIME:
        return "time";
	case IPPORT_DOMAIN:
		return "domain";

	/* self-defined ports */
	case 9980:
		return "bbs";
	case 9981:
		return "node";
	case 9982:
		return "sys";
	case 9983:
		return "wnos";
	case 9984:
		return "modem";
	case 9985:
		return "event";
	default:
		return "";
	}
}

char *
pinet(struct socket *s)
{
	static char buf[40];
	char *cp;

	sprintf(buf,"%s:%s",inet_ntoa(s->address),tcp_port(s->port));

	if(*(cp = strchr(buf,':') + 1) < 'a')
		sprintf(cp,"%u\0",s->port);

	return buf;
}

