#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "internet.h"
#include "netuser.h"
#include "icmp.h"
#include "trace.h"
#include "ip.h"

/* Dump an ICMP header */
void
icmp_dump(FILE *fp,struct mbuf **bpp,int32 source,int32 dest,int check)
{
	struct icmp icmp;
	int16 csum = 0;

	if(bpp == NULLBUFP || *bpp == NULLBUF) {
		return;
	}
	if(check) {
		csum = cksum(NULLHEADER,*bpp,len_p(*bpp));
	}
	ntohicmp(&icmp,bpp);

	trprintf(fp,"ICMP: type %s",Icmptypes[uchar(icmp.type)]);

	switch(uchar(icmp.type)){
	case ICMP_DEST_UNREACH:
		trprintf(fp," code %s",Unreach[uchar(icmp.code)]);
		break;
	case ICMP_REDIRECT:
		trprintf(fp," code %s",Redirect[uchar(icmp.code)]);
		trprintf(fp," new gateway %s",inet_ntoa(icmp.args.address));
		break;
	case ICMP_TIME_EXCEED:
		trprintf(fp," code %s",Exceed[uchar(icmp.code)]);
		break;
	case ICMP_PARAM_PROB:
		trprintf(fp," pointer %u",icmp.args.pointer);
		break;
	case ICMP_ECHO:
	case ICMP_ECHO_REPLY:
	case ICMP_INFO_RQST:
	case ICMP_INFO_REPLY:
	case ICMP_TIMESTAMP:
	case ICMP_TIME_REPLY:
		trprintf(fp," id %u seq %u",icmp.args.echo.id,icmp.args.echo.seq);
		pullup(bpp,NULLCHAR,sizeof(int32));
		break;
	}
	if(csum) {
		trprintf(fp," CHECKSUM ERROR (%u)",csum);
	}
	trprintf(fp,"\n");

	/* Dump the offending IP header, if any */
	switch(icmp.type){
	case ICMP_DEST_UNREACH:
	case ICMP_TIME_EXCEED:
	case ICMP_PARAM_PROB:
	case ICMP_QUENCH:
	case ICMP_REDIRECT:
		trprintf(fp,"Returned ");
		ip_dump(fp,bpp,0);
	}
}

