#include <stdio.h>
#include <io.h>
#include "global.h"
#include "mbuf.h"
#include "ftp.h"
#include "files.h"
#include "server.h"

/* Send a file (opened by caller) on a network socket.
 * Normal return: count of bytes sent
 * Error return: -1
 */
long
sendfile(FILE *fp,int s,int mode,int hash)
{
	struct mbuf *bp;
	static char bsent[] = "Bytes sent: %ld\n";
	long total = 0, hmark = 0;
	int fileclose = (hash & 0x80);

	hash &= 0x7f;

	switch(mode){
	default:
	case IMAGE_TYPE:
	case LOGICAL_TYPE:
		sockmode(s,SOCK_BINARY);
		for(;;){
			bp = alloc_mbuf(BLKSIZE);
			if((bp->cnt = fread(bp->data,1,BLKSIZE,fp)) == 0){
				free_p(bp);
				break;
			}
			total += bp->cnt;
			if(send_mbuf(s,bp,0,NULLCHAR,0) == -1) {
				total = -1L;
				break;
			}
			while(hash == V_HASH && total >= hmark+1000){
				tputs("#");
				hmark += 1000;
			}
			while(hash == V_BYTE && total >= hmark+1000){
				tprintf(bsent,total);
				hmark += 1000;
			}
		}
		break;
	case ASCII_TYPE: {
		int c, oldf = setflush(s,-1);
		char line[LINELEN];

		/* Let the newline mapping code in usput.() do the work */
		sockmode(s,SOCK_ASCII);

		while(fgets(line,LINELEN,fp) != NULL) {
			if((c = usputs(s,line)) == EOF) {
				total = -1L;
				break;
			}
			total += c + 1;

			while(hash == V_HASH && total >= hmark + 1000) {
				tputs("#");
				hmark += 1000;
			}
			while(hash == V_BYTE && total >= hmark + 1000) {
				tprintf(bsent,total);
				hmark += 1000;
			}
		}
		usflush(s);
		setflush(s,oldf);
		break;
	  }
	}
	if(hash) {
		tputs("\n");
	}
	if(fileclose) {
		Fclose(fp);
	}
	return total;
}

/* Receive a file (opened by caller) from a network socket.
 * Normal return: count of bytes received
 * Error return: -1
 */
long
recvfile(FILE *fp,int s,int mode,int hash)
{
	struct mbuf *bp;
	static char brecv[] = "Bytes recv: %ld\n";
	int c, cnt;
	long total = 0, hmark = 0;

	switch(mode){
	default:
	case IMAGE_TYPE:
	case LOGICAL_TYPE:
		sockmode(s,SOCK_BINARY);

		while((cnt = recv_mbuf(s,&bp,0,NULLCHAR,0)) != 0) {
			if(cnt == -1) {
				return -1;
			}
			total += cnt;

			while(hash == V_HASH && total >= hmark+1000){
				tputs("#");
				hmark += 1000;
			}
			while(hash == V_BYTE && total >= hmark+1000){
				tprintf(brecv,total);
				hmark += 1000;
			}
			if(fp != NULLFILE) {
				struct mbuf *tbp = bp;
				while(bp != NULLBUF) {
					if(fwrite(bp->data,1,bp->cnt,fp) != bp->cnt) {
						free_p(bp);
						return -1;
					}
					bp = bp->next;
				}
				free_p(tbp);
			} else {
				send_mbuf(Curproc->output,bp,0,NULLCHAR,0);
			}
		}
		break;
	case ASCII_TYPE:
		sockmode(s,SOCK_ASCII);

		while((c = recvchar(s)) != EOF) {
			if(c == '\n') {
				total++;
			}
			if(fp != NULLFILE){
				if(fputc(c,fp) == EOF) {
					total = -1;
					break;
				}
			} else {
				usputc(Curproc->output,c);
			}
			total++;

			while(hash == V_HASH && total >= hmark+1000){
				tputs("#");
				hmark += 1000;
			}
			while(hash == V_BYTE && total >= hmark+1000){
				tprintf(brecv,total);
				hmark += 1000;
			}
		}
		/* Detect an abnormal close */
		if(socklen(s,0) == -1)
			total = -1L;
		break;
	}
	if(hash) {
		tputs("\n");
	}
	return total;
}

/* Determine if a file appears to be binary (i.e., non-text).
 * Return 1 if binary, 0 if ascii text after rewinding the file pointer.
 *
 * Used by FTP to warn users when transferring a binary file in text mode.
 */
int
isbinary(FILE *fp)
{
	int c, i, rval = 0;

	for(i = 0; i < 512; i++) {
		if((c = fgetc(fp)) == EOF) {
			break;
		}
		if(c & 0x80) {
			/* High bit is set, probably not text */
			rval = 1;
			break;
		}
	}
	/* Assume it was at beginning */
	rewind(fp);
	return rval;
}

/* Return 1 if the file operation is allowed, 0 otherwise */
int
permcheck(char *path,int perms,int op,char *file)
{
	if(file == NULLCHAR || path == NULLCHAR) {
		return 0;	/* Probably hasn't logged in yet */
	}
	if(chkbaddoschars(file)) {
		return 0;
	}
	/* The target file must be under the user's allowed search path */
	if(strncmp(file,path,strlen(path)) != 0) {
		return 0;
	}
	switch(op){
	case RETR_CMD:
		/* User must have permission to read files */
		return (perms & FTP_READ);
	case DELE_CMD:
	case RMD_CMD:
		/* User must have permission to (over)write files */
		return (perms & FTP_WRITE);
	case STOR_CMD:
	case MKD_CMD:
		/* User must have permission to (over)write files, or permission
		 * to create them if the file doesn't already exist
		 */
		if(perms & FTP_WRITE) {
			return 1;
		}
		if(access(file,2) == -1 && (perms & FTP_CREATE)) {
			return 1;
		}
		return 0;
	}
	return 0;	/* "can't happen" -- keep lint happy */
}

