#ifndef _FTP_H
#define _FTP_H

#ifndef _SOCKET_H
#include "socket.h"
#endif

#ifndef _SESSION_H
#include "session.h"
#endif

#define	BLKSIZE			2048	/* Chunk size for file I/O */
#define CTLZ			26		/* EOF for CP/M systems */

#define	ASCII_TYPE		0
#define	IMAGE_TYPE		1
#define	LOGICAL_TYPE	2

#define DELE_CMD 6
#define RETR_CMD 9
#define STOR_CMD 10
#define MKD_CMD  15
#define RMD_CMD  18

#define	FTPLINE			512		/* Length of user command buffer */

struct ftpserv {
	int control;				/* Control socket */
	int data;					/* Data socket */
	char type;					/* Transfer type */
	int logbsize;				/* Logical byte size for logical type */
	FILE *fp;					/* File descriptor being transferred */
	struct sockaddr_in port;	/* Remote port for data connection */
	char *username;				/* Arg to USER command */
	char *path;					/* Allowable path prefix */
	char *cd;					/* Current directory name */
	int16 perms;				/* Permission flag bits */
	int states;
#define USER	0
#define PASS	1
#define LOG		2
#define CLOSED	4
	char *line;					/* input line */
};
#define NULLFTPS (struct ftpserv *)0

/* Per-session FTP client control block */
struct ftpcli {
	int control;				/* Control socket */
	int data;					/* Data socket */
	char state;
#define	COMMAND_STATE	0		/* Awaiting user command */
#define	SENDING_STATE	1		/* Sending data to user */
#define	RECEIVING_STATE	2		/* Storing data from user */
#define CLOSED			4
	int16 verbose;				/* Transfer verbosity level */
#define	V_QUIET			0		/* Error messages only */
#define	V_SHORT			1		/* Final message only */
#define	V_NORMAL		2		/* display control messages */
#define	V_HASH			3		/* control messages, hash marks */
#define V_BYTE			4		/* control messages, byte count */
	int batch;					/* Command batching flag */
	int abort;					/* Aborted transfer flag */
	char type;					/* Transfer type */
	char typesent;				/* Last type command sent to server */
	int logbsize;				/* Logical byte size for logical type */
	FILE *fp;					/* File descriptor being transferred */
	struct session *session;
	char *buf;					/* input buffer */
	char *username;
	char *password;
};
#define	NULLFTPC (struct ftpcli *)0


int permcheck __ARGS((char *path,int perms,int op,char *file));

/* In ftpsubr.c: */
long sendfile __ARGS((FILE *fp,int s,int mode,int hash));
long recvfile __ARGS((FILE *fp,int s,int mode,int hash));
int isbinary __ARGS((FILE *fp));

/* in ftpserv.c */
void ftpserv __ARGS((int s,void *unused,void *p));

#endif	/* _FTP_H */

