/*
** $Source: dh1:network/parnet/Sana2/Sources/Spar_device.h,v $
** $State: Exp $
** $Revision: 37.2 $
** $Date: 93/12/17 22:13:33 $
** $Author: S.A.Pechler $
**
** SANA-II Example device driver C include file
**
** Based on the Amiga SANA-II Example SLIP device driver code by bj and the
** rhslip.device by rhialto@mbfys.kun.nl (Olaf Seibert)
**
** Portions (C) Copyright 1992 Commodore-Amiga, Inc.
*/

#include <exec/types.h>
#include <exec/devices.h>
#include <exec/ports.h>
#include <exec/semaphores.h>
#include <exec/memory.h>
#include <dos.h>
#include <devices/sana2.h>
#include <devices/parnet.h>

/*
** Stacksize and Priority of the Unit Process
*/
#define SPAR_STACKSIZE 4000
#define SPAR_PRI 5

/*
** Maximum Transmission Unit
*/
#define SPAR_MTU 8192+256

/* Hmm, I still need to determine the *real* PARnet bps
 */
#define SPAR_SPEED 28672

/* Use PARnet port 1024 for TCP/IP communications
 * WARNING: don't change this value when you want to stay compatible 
 * with the PARnet-PC packet driver.
 */
#define SPAR_PORT 1024

/* Length of an IP address in bytes. */
#define IADDR_LEN 4

/* Length of a Spar address in bytes. */
#define SADDR_LEN 1

/* Length of an Ethernet address in bytes. */
#define EADDR_LEN 6

/*
** Spar frame header structure.
*/
struct Spar_Hdr
       {
         UBYTE SDstAddr; /* Destination hardware address */
         UBYTE SSrcAddr; /* Source hardware address */
         UWORD SFrmType; /* Frame type (Using Ethernet frame type) */
       };
/*
** Length of a Spar frame header in bytes.
*/
#define SHDR_LEN sizeof(struct Spar_Hdr)

/*
** Max # of Units allowed
*/
#define SD_MAXUNITS 8

/*
** Message passed to the Unit Process at
** startup time.
*/
struct StartupMessage
{
  struct Message  Msg;
  struct Unit     *Unit;
  struct Device   *Device;
};

/*
** Device Data Structure
*/
struct SPARDevice
{
    struct Library          sd_Device;
    UBYTE                   sd_Flags;
    UBYTE                   sd_Pad1;
    struct Library         *sd_SysBase;
    struct Library         *sd_DOSBase;
    ULONG                   sd_DosTag[10];
    BPTR                    sd_SegList;
    struct Unit            *sd_Units[SD_MAXUNITS];
    struct SignalSemaphore  sd_Lock;
    struct StartupMessage   sd_Startup;
};

/*
** Typedef's for the SANA-II callback functions.
** Rhialto: It would be nice to specify the registers explicitly,
** instead of hoping the compiler options include ARGS=REGS, and that
** the compiler selected registers would match the requirements.
*/
#ifdef __SASC
# define ASM          __asm
# define REG(x)       register __ ## x
#else
# error Please define ASM and REG for your compiler
#endif

typedef BOOL (*ASM SANA2_CFB)(REG(a0) APTR to, REG(a1) APTR from, REG(d0) LONG length);
typedef BOOL (*ASM SANA2_CTB)(REG(a0) APTR to, REG(a1) APTR from, REG(d0) LONG length);

struct BufferManagement
{
   struct MinNode   bm_Node;
   SANA2_CFB        bm_CopyFromBuffer;
   SANA2_CTB        bm_CopyToBuffer;
};

struct SuperS2PTStats
{
   struct MinNode               ss_Node;
   ULONG                        ss_PType;
   struct Sana2PacketTypeStats  ss_Stats;
};

/*
** Unit Data Structure
*/
struct SPARDevUnit
{
    struct Unit              sdu_Unit;            /* Standard Unit Structure */
    UBYTE                    sdu_UnitNum;         /* Unit number */
    UBYTE                    sdu_StAddr;          /* Our current address */
    struct Device           *sdu_Device;          /* Pointer to our device node */
    UBYTE                    sdu_HwAddr;          /* Our "hardware" address (Rhialto)*/
    UBYTE                    sdu_DestAddr;        /* Destination address when point-to-point */
    ULONG                    sdu_ParUnitNum;      /* PARnet driver unit number */
    BOOL                     sdu_NoMore;          /* Flag: work to do for Unit process */
    ULONG                    sdu_State;           /* Various state information */
    struct IOParReq         *sdu_ParRx;           /* PARnet IORequest for CMD_READ's */
    struct IOParReq         *sdu_ParTx;           /* PARnet IORequest for CMD_WRITE's */
    struct MsgPort          *sdu_RxPort;          /* PARnet CMD_READ IORequest reply port */
    struct MsgPort          *sdu_TxPort;          /* PARnet CMD_WRITE IORequest reply port */
    UBYTE                   *sdu_RxBuff;          /* Buffer for holding packets */
    UBYTE                   *sdu_TxBuff;          /* Temporary buffer for hold outgoing packets */
    struct Process          *sdu_Proc;            /* NB: This points to the Task, not the MsgPort */
    struct SignalSemaphore   sdu_ListLock;        /* A Semaphore for access to all of our queues. */
    struct MinList           sdu_Rx;              /* Pending CMD_READ's */
    struct MinList           sdu_RxOrph;          /* Pending CMD_READORPHAN's */
    struct MinList           sdu_Tx;              /* Pending CMD_WRITE's */
    struct MinList           sdu_Events;          /* Pending S2_ONEVENT's */
    BOOL                     sdu_TrackP;          /* Flag: a packet to track is present */
    struct MinList           sdu_Track;           /* List of packet types being tracked */
    struct MinList           sdu_BuffMgmt;        /* List of Callback routines */
    struct Sana2DeviceStats  sdu_Stats;           /* Global device statistics */
    UBYTE                    sdu_ParDevName[32];  /* Name of the PARnet driver to use */
};

/*
** State bits for sdu_State
*/

#define SPARUB_ONLINE 0
#define SPARUB_CONFIG 1
#define SPARUB_CONTROL 2
#define SPARUB_DGRAM 3
#define SPARUB_STREAM 4

#define SPARUF_ONLINE       (1<<SPARUB_ONLINE)
#define SPARUF_CONFIG       (1<<SPARUB_CONFIG)
#define SPARUF_CONTROL      (1<<SPARUB_CONTROL)
#define SPARUF_DGRAM        (1<<SPARUB_DGRAM)
#define SPARUF_STREAM       (1<<SPARUB_STREAM)

/*
** ARP definitions
** Spar does not support packet broadcast, therefor it processes ARP
** requests from the local host internally. 
*/

/* Spar frame type (using Ethernet frame types) */
#define ETHERTYPE_IP    0x0800          /* IP protocol */
#define ETHERTYPE_ARP   0x0806          /* ARP packet */

/* ARP frame packet content for 6 byte ethernet hardware addresses */
struct ARPframePacket
       { UBYTE ar_dstaddr;   /* frame target hardware address (myself) */
         UBYTE ar_srcaddr;   /* frame source hardware address (fake!) */
         UWORD ar_ftype;     /* frame type field (0x0806 = ARP_TYPE) */
         UWORD ar_hrd;       /* hardware type: */
#define  ARPHRD_ETHER    1   /* ethernet hardware address */
#define  ARPHRD_ARCNET   7   /* ARCNET hardware address */
         UWORD ar_pro;       /* protocol type (0x0800 = IP) */
         UBYTE ar_hln;       /* hardware address length (6 for Ethernet) */
         UBYTE ar_pln;       /* higher level address length (4 = IP) */
         UWORD ar_op;        /* operation: */
#define  ARPOP_REQUEST   1   /* request to resolve address */
#define  ARPOP_REPLY     2   /* response to previous request */

/* These fields are normally variable in size, but Spar only works with
 * six-byte hardware addresses and 4 octet IP addresses. */
         UBYTE ar_sha[6];       /* sender hardware address */
         ULONG ar_spa;          /* sender protocol address */
         UBYTE ar_tha[6];       /* target hardware address */
         ULONG ar_tpa;          /* target protocol address */
       };
/*
** Device Name
*/
#ifdef DEBUG
# define SPARDEVNAME "spardebug.device"
#else
# define SPARDEVNAME "spar.device"
#endif
extern char SPARName[];

/*
** Compiler Magic
**
** (Rhialto) This is terrible!!! That people write code like this!
** How can you be sure the compiler won't use A6 for a register variable
** somewhere and make it unusable in the functions that it calls?
** (in fact, SAS/C 6.2 does something that, in ReadConfig..., when it
** first calls an Exec function and then a DOS function)
**
*/

#ifdef notdef
/* SPARBase must be in register a6 */
# define SPARBase ((struct SPARDevice *)__builtin_getreg(14))      /* Avoid the pre-processor problem */
#else
#define SPARBase	ExtDeviceBase
#endif

/* pointer to exec (initialized in DevInit(), see spar_device.asm) */
#define SysBase      (SPARBase->sd_SysBase)
#define DOSBase      (SPARBase->sd_DOSBase)
