/*
 *	Name:				xferqglue.c
 *
 * Description:	Varargs glue routines for taglist functions
 *
 * Copyright:		1992 by David Jones.
 *
 * Distribution:
 *		This source file is released with no restrictions in its use
 *		whatsoever, provided that it is included free of charge in the
 *		source and binary distributions of xferq.library.
 *
 *		In particular, you may use the functions in this file to interface
 *		to the taglist routines in xferq.library without subjecting your
 *		application to the terms and conditions of the GNU General Public
 *		License or the General Library Public License.  The intent is
 *		to prevent the fact that xferq.library is copylefted from being
 *		a deterrent to its use by non-copylefted programs.
 *
 *		Please note that this distribution notice applies only to those
 *		source files having this notice at the top of the file.  All other
 *		source files are subject to the terms and conditions of the
 *		General Public License.
 *
 *		This program is distributed in the hope that it will be useful,
 *		but WITHOUT ANY WARRANTY; without even the implied warranty of
 *		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *		GNU General Public License for more details.
 *
 *		You should have received a copy of the GNU General Public License
 *		along with this program; if not, write to:
 *
 *				The Free Software Foundation		David Jones
 *				675 Mass Ave							6730 Tooney Drive
 *				Cambridge, MA							Orleans, Ontario
 *				02139										K1C 6R4
 *				USA										Canada
 *
 *	Usenet:	gnu@prep.ai.mit.edu					dej@qpoint.ocunix.on.ca
 *	Fidonet:												1:163/109.8
 *
 *		$Log: $
 *
 */

#include <utility/tagitem.h>
#include <exec/lists.h>
#include <exec/nodes.h>
#include "xferq/xferq.h"
#include "xferq/xferq_pragmas.h"

extern struct Library *XferqBase;

struct WorkNode *XfqFindWorkTags(Tag tag, ...)
{

	return XfqFindWork((struct TagItem *)&tag);
}


ULONG XfqAnyWorkTags(void *object, Tag tag, ...)
{

	return XfqAnyWork(object, (struct TagItem *)&tag);
}


struct WorkNode *XfqGetWorkTags(void *object, Tag tag, ...)
{

	return XfqGetWork(object, (struct TagItem *)&tag);
}


void XfqWalkQueueCallBackTags(struct NetAddress *addr, Tag tag, ...)
{

	XfqWalkQueueCallBack(addr, (struct TagItem *)&tag);
}


ULONG XfqBeginSessionTags(struct Session *session, Tag tag, ...)
{

	return XfqBeginSession(session, (struct TagItem *)&tag);
}


void XfqSortSessionTags(struct Session *session, Tag tag, ...)
{

	XfqSortSession(session, (struct TagItem *)&tag);
}


void XfqWalkSessionCallBackTags(struct Session *session, Tag tag, ...)
{

	XfqWalkSessionCallBack(session, (struct TagItem *)&tag);
}


void *XfqHookTags(Tag tag, ...)
{

	return XfqHook((struct TagItem *)&tag);
}


struct NetAddress *XfqGetAddressTags(char *buf, struct NetAddress *addr,
	Tag tag, ...)
{

	return XfqGetAddress(buf, addr, (struct TagItem *)&tag);
}


char *XfqPutAddressTags(void *addr, Tag tag, ...)
{

	return XfqPutAddress(addr, (struct TagItem *)&tag);
}


LONG XfqCmpAddressTags(void *left, void *right, Tag tag, ...)
{

	return XfqCmpAddress(left, right, (struct TagItem *)&tag);
}


struct NetAddress *XfqMapTags(struct NetAddress *addr, Tag tag, ...)
{

	return XfqMap(addr, (struct TagItem *)&tag);
}


ULONG XfqFilterTags(void *object, Tag tag, ...)
{

	return XfqFilter(object, (struct TagItem *)&tag);
}


void *XfqCreateObjectTags(ULONG type, Tag tag, ...)
{

	return XfqCreateObject(type, (struct TagItem *)&tag);
}


void XfqExamObjectTags(void *object, Tag tag, ...)
{

	XfqExamObject(object, (struct TagItem *)&tag);
}


void *XfqModifyObjectTags(void *object, Tag tag, ...)
{

	return XfqModifyObject(object, (struct TagItem *)&tag);
}

