
#include <stdio.h>
#include <exec/types.h>
#include <exec/execbase.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/devices.h>
#include <exec/io.h>
#include <exec/libraries.h>
#include <devices/serial.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <utility/hooks.h>
#include <stdlib.h>
#include <string.h>

#include "xferq/xferq.h"
#include "xferq/xferq_pragmas.h"

#ifdef TRAPLIST
#include "h/trap.h"
#define NODELIST_NAME TRAPLIST_NAME
#define NODELIST_VER TRAPLIST_VER
#endif

#ifdef IGEN
#include "h/igen.h"
#endif

extern struct Library *XferqBase;

void lookup(struct structup *lookupstruct);
void scanlist(char *list, struct structup *lookupstruct);

struct structup {
    char found;
    char nodelist[50];
    char address[50];
    char phone[50];
    char sysop[50];
    char type[6];
    char password[20];
    char city[20];
    char flags[30];
    char system[40];
    char baud[10];
    char hub[10];
    char region[10];
    char cost[10];
};

struct Library *NodelistBase;

const char *const nl_keys[] =
    { "Node", "Host", "Hold", "Hub", "Pvt", "Point", "Zone", "Region", "Down" };

void lookup(struct structup *lookupstruct)
{

    NodeList the_nodelist;
    NodeDesc *node_desc;

    static char temp[255], address[50];

    if(!(NodelistBase = OpenLibrary(NODELIST_NAME, NODELIST_VER)))
    {
        printf("Can't open library\n");
        exit(5);
    }

    if(the_nodelist = NLOpen(lookupstruct->nodelist, 0))
    {
         Addr find_me;

         int i,j;

         strcpy(address, lookupstruct->address);

         for(i=0;address[i]>35;i++);

         i++;
         for(j=0;address[i]<58;j++,i++)
            temp[j]=address[i];
         temp[j]=0;
         find_me.Zone = atoi(temp);

         i++;
         for(j=0;address[i]>47;j++,i++)
            temp[j]=address[i];
         temp[j]=0;
         find_me.Net = atoi(temp);

         i++;
         for(j=0;address[i]>46;j++,i++)
            temp[j]=address[i];
         temp[j]=0;
         find_me.Node = atoi(temp);

         i++;
         for(j=0;address[i];j++,i++)
            temp[j]=address[i];
         temp[j]=0;
         find_me.Point= atoi(temp);

         if(node_desc = NLFind(the_nodelist, &find_me, 0))
         {
             lookupstruct->found = 1;
             strcpy(lookupstruct->phone, node_desc->Phone);
             strcpy(lookupstruct->sysop, node_desc->Sysop);
             strcpy(lookupstruct->type, "FIDO");
             for (i=0;lookupstruct->password[i]=toupper(node_desc->Passwd[i]);i++);

             strcpy(lookupstruct->city, node_desc->City);
             strcpy(lookupstruct->flags, node_desc->Flags);
             strcpy(lookupstruct->system, node_desc->System);
             sprintf(lookupstruct->baud, "%ld", node_desc->BaudRate);
             sprintf(lookupstruct->hub, "%ld", node_desc->Hub);
             sprintf(lookupstruct->region, "%ld", node_desc->Region);
             sprintf(lookupstruct->cost, "%ld", node_desc->Cost);

             for (i=0;i<strlen(lookupstruct->city);i++)
                if (lookupstruct->city[i]==' ')
                   lookupstruct->city[i]='_';

             for (i=0;i<strlen(lookupstruct->sysop);i++)
                if (lookupstruct->sysop[i]==' ')
                   lookupstruct->sysop[i]='_';

             for (i=0;i<strlen(lookupstruct->flags);i++)
                if (lookupstruct->flags[i]==' ')
                   lookupstruct->flags[i]='_';

             if (strlen(lookupstruct->password) <2) strcpy(lookupstruct->password, "-");
             if (strlen(lookupstruct->city) <2) strcpy(lookupstruct->city, "-");
             if (strlen(lookupstruct->sysop) <2) strcpy(lookupstruct->sysop, "-");

         }
         NLClose(the_nodelist);
    }
    else
    {   
        printf("Library Can't Open Nodelist\n");
    }
    CloseLibrary(NodelistBase);
    return;
}

void scanlist(char *list, struct structup *lookupstruct)
{
    FILE *fp;

    static char temp[255], addres[50], phone[50], type[6], password[10];
    static char flags[40], city[40], sysop[40], source[50];

    int i;
 
    fp = fopen(list, "r");
    if (fp)
    { 

      while ((fgets(temp, 253, fp) != NULL) && (lookupstruct->found!=1))
      {

        if ((temp[0]=='#') || (temp[0]==';')) continue;

        sscanf(temp, "%s %s %s %s %s %s %s", source, phone, type, password,
           flags, city, sysop);
/*

        if(addr=XfqGetAddressTags(source,NULL,XQ_Mandatory,XQADDR_NODE,
                XQ_Optional,XQADDR_ANYTHING,TAG_DONE))
        {
           if(address=XfqPutAddressTags(addr, XQ_Mandatory,XQADDR_ANYTHING,
                XQ_Optional,XQADDR_ANYTHING,TAG_DONE))
           {
              XfqExamObjectTags(addr,XQ_Domain,&domain,TAG_DONE);
              for(i=0;addres[i]=toupper(address[i]);i++);
              XfqDropObject(address);
              XfqDropObject(addr);
           }
        }
        else
*/
           for(i=0;addres[i]=toupper(source[i]);i++);

        if (!strcmp(addres, lookupstruct->address))
        {
            lookupstruct->found = 1;
            strcpy(lookupstruct->phone, phone);
            strcpy(lookupstruct->type, type);

            if (password[0]!='-')
               strcpy(lookupstruct->password, password);
            if ((sysop[0]!='-') && (sysop[0]))
               strcpy(lookupstruct->sysop, sysop);
            if ((city[0]!='-') && (city[0]))
               strcpy(lookupstruct->city, city);
            strcpy(lookupstruct->flags, flags);
	}
     }
   }

   return;
}

