/*

   TPDEM2.PRG
   Demo of TEXTPAD 2.0 w/ multiple TEXTPADs per screen and multiple pictures.
   Steve Kolterman  76320,37

*/

#include "setcurs.ch"
#include "inkey.ch"
#include "getexit.ch"

#ifdef CSY
 #include "textpad.ch"
#else
 #include "tpclip.ch"
#endif

#define ORDPOS   cargo[4]

FUNCTION Test()
  LOCAL cStr1:= Declaration(1),getlist:= {},cVar:= "our first GET",cVar2
  LOCAL cStr2:= Declaration(2)
  LOCAL cStr3:= Declaration(3),cStr4,cScrn
          
  cVar2:= "our Sixth GET"
  SetBlink(.F.)
  cScrn:= SaveScreen( 0,0,maxrow(),maxcol() )

  SET SCOREBOARD OFF
  SetColor("+gr/b") ; Scroll()

  // how to hotkey to next or previous GET, always wrapping at limits.
  Setkey( K_F5,   {|p,l,v,g,n| g:= GetActive(), ;
                               n:= IIF( g==Atail(getlist),GE_TOP,;
                               GE_DOWN), g:exitstate:= n} )

  Setkey( K_SH_F5,{|p,l,v,g,n| g:= GetActive(), ;
                               n:= IIF( g==getlist[1],GE_BOTTOM,;
                               GE_UP), g:exitstate:= n} )

  Setpos( 0,3 )
  DispOut( "TEXTPAD 2.0 Demo.  Steve Kolterman CIS:76320,37","+gr/b" )

  @ 2,40 SAY "First GET" GET cVar PICTURE "@KA"
      
  @ 4,3 SAY "Declaration1" SCOLOR "+w/b" ;
        TEXTPADGET cStr1 PICTURE "@!" COLOR "w/b,+w/r" ;
        WHEN  {|g| PrePost(g,.T.)} ;
        VALID {|g| PrePost(g,.F.)} ;
        MAXCOLUMN maxcol()-7
                
  // demo of NODISPLAY

  @ 8,13 SAY "Declaration2: '@!A'" SCOLOR "+r/b" ;
        TEXTPADGET cStr2 PICTURE "@!A" COLOR "w/b,+w/gr" ;
        WHEN  {|g| PrePost(g,.T.)} ;
        VALID {|g| PrePost(g,.F.)} ;
        MAXCOLUMN maxcol()-5 ;
	NODISPLAY
        
  @ 14,23 SAY "Declaration3: '@KA'" ABOVE SCOLOR "+w/b" ;
        TEXTPADGET cStr3 PICTURE "@KA" COLOR "w/b,+w/g" ;
        WHEN  {|g| PrePost(g,.T.)} ;
        VALID {|g| PrePost(g,.F.)} ;
        MAXCOLUMN maxcol()-3

  cStr4:= Replic("123654",15)

  // notice below:  TEXTWRAPGET will still work because I translate it to
  // TEXTPADGET.  Also, demo of ABOVE.
  
  @ 19,23 SAY "String o' Ints: '@NK'" ABOVE SCOLOR "+w/b" ;
        TEXTWRAPGET cStr4 PICTURE "@NK" COLOR "w/b,+w/g" ;
        WHEN  {|g| PrePost(g,.T.)} ;
        VALID {|g| PrePost(g,.F.)} ;
        MAXCOLUMN maxcol()-1

  @ 23,5 SAY "Sixth GET" GET cVar2

READ

RestScreen(cScrn)
SetBlink(.T.)

RETURN NIL

FUNCTION Declaration( nStr )
LOCAL cStr
DO CASE
CASE nStr==1
   cStr:= "When in the course of human events it becomes necessary for "+;
       "one people to dissolve the political bands which have connected "+;
       "them with another, and to assume among the powers of the earth "
CASE nStr==2
   cStr:= "the separate and equal station to which the laws of nature "+;
       "and of nature's god entitle them, a decent respect to the "+;
       "opinions of mankind requires that they should declare the causes "+;
       "which compel them to the separation."
CASE nStr==3
   cStr:= "We hold these truths to be self-evident.  That all men are "+;
       "created equal.  That they are endowed by their creator with "+;
       "certain inalienable rights.  And that among these are life, "+;
       "liberty"  //, and the pursuit of happiness..."
ENDCASE
RETURN cStr

FUNCTION PrePost( oGet,lWhich )
STATIC cScrn
LOCAL nRow:= row(),nCol:= col(),cMsg,nCurs:= SetCursor(SC_NONE)

IF cScrn==NIL
   cScrn:= Savescreen( 2,3,2,maxcol() )
ENDIF

Restscreen( 2,3,2,maxcol(),cScrn )
cMsg:= IIF(lWhich,"Preblock","Postblock")+" a.k.a. " +;
       IIF(lWhich,"WHEN","VALID")+ "   "
   
@ 2,3 say cMsg color "+gr/b"

// change 5th GET's color, just for demo.
#ifdef CSY
IF oGet:ordPos == 5
#else
IF oGet:ORDPOS == 5
#endif

#ifdef CSY
   oGet:dispTitle( "+gr/n" )
#else
   dispTitle( oGet,"+gr/n" )
#endif

ENDIF

SetCursor(nCurs)

RETURN .T.
