/*
 Ŀ
  Module....: MVC.prg                                                     
  Author....: Ken Trock                                                   
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: August 1993                                                 
 Ĵ
  Notes.....: Multiple Virtual Context display                            
 
*/

/***************************************************************************
   Include file headers.
***************************************************************************/

#include "objectdb.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "odbdemo.ch"
#include "mb.ch"

/***************************************************************************
   Manifest constants.
***************************************************************************/

#define STATUS_LINE   " F2 : Source  Tab/Shift Tab : Switch  Alt-F : Set Filter  ESC : Exit "

/***************************************************************************
   FUNCTION mvc()
***************************************************************************/

FUNCTION mvc()
  LOCAL cColor := setColor( "w+/b*" )
  LOCAL getList := {}
  LOCAL oCust1, oCust2, oCust3
  LOCAL oTBcust1, oTBcust2, oTBcust3
  LOCAL aCon
  LOCAL aTB
  LOCAL aDesc
  LOCAL cStatLine

  CREATE CONTEXT oCust1 FOR TABLE Cus 
  CREATE CONTEXT oCust2 FOR TABLE Cus USING INDEX cusname
  CREATE CONTEXT oCust3 FOR TABLE Cus USING INDEX city

  /*****
  * Configure browses
  *****/

  oTBcust1 := oCust1:browser( { 1, 2 }, 3, 1, 20, 26 ) 
  oTBcust2 := oCust2:browser( { 2, 3 }, 3, 28, 20, 52 )
  oTBcust3 := oCust3:browser( { "state", "city" }, 3, 54, 20, 79 )

  /*****
  * Prepare the browse
  *****/

  CLS

  aCon  := { oCust1, oCust2, oCust3 }
  aTB   := { oTBcust1, oTBcust2, oTBcust3 }
  aDesc := { "Cust ID", "Lname, Fname", "State, City" }

  aeval( aTB, { |o| o:colorSpec := BR_COLORS, o:headSep := SING_HEADSEP } )

  MULTIBROWSE KEY K_ALT_F CALLS setFilter 
  MULTIBROWSE KEY K_F2    CALLS readSource

  topLine( "M u l t i p l e    V i r t u a l    C o n t e x t s" )
  cStatLine := statusLine( STATUS_LINE )
  @ 1, 27 TO 23, 27  
  @ 4, 27 SAY ""
  @ 1, 53 TO 23, 53  
  @ 4, 53 SAY ""

  MULTIBROWSE aTB WITH CONTEXTS IN aCon  ;
    CAPTION HEADERS aDesc                ;
    CAPTION COLOR "w+/r, w/b"            

  restScreen( 24, 0, 24, 79, cStatLine )
  setColor( cColor )

  /****
  * Can't forget these.
  ****/

  DESTROY CONTEXT oCust1 
  DESTROY CONTEXT oCust2  
  DESTROY CONTEXT oCust3 

  RETURN nil

/***************************************************************************
   FUNCTION setFilter()
***************************************************************************/

FUNCTION setFilter( oTB, oCon )
  LOCAL cExp, bExp, lRet := TRUE

  cExp := getValue()

  IF ! ( "U" $ type( cExp ) )
     bExp := &( "{||" + cExp + "}" )
     oCon:setFilter( bExp )
     lRet := FALSE
  ELSE
     tellUser( "Error", "The specified filter condition is invalid." )
  ENDIF

  RETURN lRet

/***************************************************************************
   FUNCTION getValue()
***************************************************************************/

FUNC getValue()
  LOCAL nTop, nLeft, nBottom, nRight
  LOCAL cScr
  LOCAL nCurs
  LOCAL cColor
  LOCAL cValue := space( 30 )
  LOCAL getList := {}

  nTop := 10
  nLeft := 35
  nBottom := 14
  nRight := 68

  cScr := saveScreen( nTop, nLeft, nBottom + 1, nRight + 1 )

  cColor := setColor( "w+/br" )
  dispBox( nTop, nLeft, nBottom, nRight, 2 )
  @ nTop + 1, nLeft + 1 CLEAR TO nBottom - 1, nRight - 1
  @ nTop + 1, nLeft + 2 SAY "Filter Expression:"  COLOR "gr+/br"
  @ nTop + 2, nLeft + 2 GET cValue  COLOR "w+/br, n/w" PICT "@!"
  nCurs := setCursor( SC_NORMAL )
  READ
  setCursor( nCurs )

  restScreen( nTop, nLeft, nBottom + 1, nRight + 1, cScr )

  RETURN iif( lastkey() <> K_ESC, trim( cValue ), "" )

