/*
 Ŀ
  Module....: DOMAIN.prg                                                  
  Author....: Brian Marasca                                               
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: February 1994                                               
 Ĵ
  Notes.....: Domain functions.                                           
 
*/

/*****************************************************************************
   Include file headers.
*****************************************************************************/

#include "objectdb.ch"
#include "setcurs.ch"
#include "odbdemo.ch"
#include "inkey.ch"

/*****************************************************************************
  DOMAIN FUNCTION parts()
*****************************************************************************/

FUNCTION parts( xVal, oCon, n )
  LOCAL cScr := saveScreen( 9, 39, 21, 63 )
  LOCAL xRet := FALSE
  LOCAL oTBparts
  LOCAL oParts
  
  CREATE CONTEXT oParts FOR parts

  oTBparts := oParts:browser( { "desc" }, 10, 40, 20, 62, .F. )
  oTBparts:colorSpec := "w+/n, n/w"

  IF ! ( xRet := oParts:seek( { xVal } ) )
     dispBox( 9, 39, 21, 63, B_SINGLE, "w+/n" )

     IF browseModal( oTBparts )
        xRet := { oParts..part_no }
     ENDIF

     restScreen( 9, 39, 21, 63, cScr )
  ENDIF

  DESTROY CONTEXT oParts

  RETURN xRet

/*****************************************************************************
  DOMAIN FUNCTION salesmen
*****************************************************************************/

FUNCTION salesmen( xVal, oCon, n )
  LOCAL cScr := saveScreen( 6, 19, 16, 51 )
  LOCAL xRet := FALSE
  LOCAL oTBsales
  LOCAL oSM
  
  CREATE CONTEXT oSM FOR TABLE salesmen

  oTBsales := oSM:browser( { "lname", "fname" }, 7, 20, 15, 50, .F. )
  oTBsales:colorSpec := "w+/n, n/w"

  IF ! ( xRet := oSM:seek( { xVal } ) )
     dispBox( 6, 19, 16, 51, B_SINGLE, "w+/n" )

     IF browseModal( oTBsales )
        xRet := { oSM..sm_code }
     ENDIF

     restScreen( 6, 19, 16, 51, cScr )
  ENDIF

  DESTROY CONTEXT oSM

  RETURN xRet

/*****************************************************************************
  FUNCTION browseModal()
*****************************************************************************/

STATIC FUNCTION browseModal( oTB )
  LOCAL lExit := FALSE
  LOCAL lRet := FALSE
  LOCAL nCursor
  LOCAL nKey

  nCursor := setCursor( SC_NONE )

  WHILE ! lExit
     WHILE nextKey() == 0 .AND. ! oTB:stabilize(); END

     nKey := inkey( 0 )

     DO CASE
     CASE nKey == K_UP
        oTB:up()
     CASE nKey == K_DOWN 
        oTB:down()
     CASE nKey == K_PGUP
        oTB:pageUp()
     CASE nKey == K_PGDN
        oTB:pageDown()
     CASE nKey == K_CTRL_PGUP
        oTB:goTop()
     CASE nKey == K_CTRL_PGDN
        oTB:goBottom()
     CASE nKey == K_ENTER
        lRet := lExit := TRUE
     CASE nKey == K_ESC
        lExit := TRUE
     ENDCASE
  END

  setCursor( nCursor )

  RETURN lRet
