/*
 Ŀ
  Module....: DATADICT.prg                                                
  Author....: Brian Marasca and Ken Trock                                 
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: August 1993                                                 
 Ĵ
  Notes.....: ObjectDB Demo Data Dictionary.                              
 
*/

/***************************************************************************
   Include file headers.
***************************************************************************/

#include "ddl.ch"
#include "objectdb.ch"
#include "odbdemo.ch"

/***************************************************************************
   Pseudofunctions.
***************************************************************************/

#xtrans custCode( <o> )                                                    ;
     => left( <o>..lname, 3 ) + strzero( <o>..cust_id, 3 )

/***************************************************************************
   Data Dictionary.
***************************************************************************/

  DATA DEFINITION MODULE

  DEFINE DATABASE sample USING INDEX ntx   ;
    TEST STRUCTURE ON OPEN

  WHEN INDEXING CALL idxProgress EVERY 10

  DEFINE TABLE parts      ALIAS prt                     DESC "Parts"
    COLUMN part_no        NUM  ( 04, 00 )   AUTOINC     DESC "Number"
    COLUMN desc           CHAR ( 20 )                   DESC "Description"
    COLUMN price          NUM  ( 06, 02 )   NOT NULL    DESC "Price"

    PRIMARY KEY part_no


  DEFINE TABLE customer   ALIAS cus                               DESC "Customers"
    COLUMN cust_id        NUM  ( 04, 00 )                         DESC "ID"
    COLUMN lname          CHAR ( 15 )       NOT NULL   PICT "@!"  DESC "Last Name"
    COLUMN fname          CHAR ( 10 )       NOT NULL   PICT "@!"  DESC "First Name"
    COLUMN vtest          VIRTUAL AS custCode( o )                DESC "Virtual"
    COLUMN addr1          CHAR ( 30 )                  PICT "@!"  DESC "Address Line 1"
    COLUMN addr2          CHAR ( 30 )                  PICT "@!"  DESC "Address Line 2"
    COLUMN city           CHAR ( 20 )       NOT NULL   PICT "@!"  DESC "City"
    COLUMN state          CHAR ( 02 )       NOT NULL   PICT "@!"  DESC "State"
    COLUMN zip            CHAR ( 05 )       NOT NULL              DESC "Zip"

    PRIMARY KEY cust_id

    DEFINE UNIQUE INDEX cusname ON lname, fname
    DEFINE INDEX city ON state, city

    DEFINE TRIGGER noWay AS o:flds:lname:preimage != "MARASCA" ;
       FIRE BEFORE DELETE 


  DEFINE TABLE salesmen   ALIAS sm                       DESC "Salesmen"
    COLUMN sm_code        NUM  ( 02, 00 )   AUTOINC      DESC "Code"
    COLUMN lname          CHAR ( 15 )       NOT NULL     DESC "Last Name"
    COLUMN fname          CHAR ( 10 )                    DESC "First Name"
    COLUMN hired          DATE                           DESC "Hire Date"
    COLUMN comments       VLF                            DESC "Comments"

    PRIMARY KEY sm_code


  DEFINE TABLE invoice    ALIAS inv                                DESC "Invoices"
    COLUMN cust_id        NUM  ( 04, 00 )                          DESC "Cust ID"
    COLUMN inv_no         NUM  ( 06, 00 )   AUTOINC                DESC "Number"
    COLUMN date           DATE              NOT NULL               DESC "Invoice Date"
    COLUMN sm_code        NUM  ( 02, 00 )   DOMAIN FUNC salesmen   DESC "Salesman"

    PRIMARY KEY cust_id, inv_no
    DEFINE INDEX sales ON cust_id, date DESC

    FOREIGN KEY cust_id REFERENCES TABLE cus  ;
      CASCADE UPDATES                         ;
      CASCADE DELETES                         ;
      USE INDEX

    FOREIGN KEY sm_code REFERENCES TABLE sm   ;
      CASCADE UPDATES                         ;
      NULLIFY DELETES                         ;
      USE INDEX


  DEFINE TABLE lineitem   ALIAS line                            DESC "Lineitems"
    COLUMN cust_id        NUM  ( 04, 00 )                       DESC "Cust ID"
    COLUMN inv_no         NUM  ( 06, 00 )                       DESC "Invoice Number"
    COLUMN line_no        NUM  ( 03, 00 )  AUTOINC BY inv_no    DESC "Line Number"
    COLUMN part_no        NUM  ( 04, 00 )  DOMAIN FUNC parts    DESC "Part Number"

    PRIMARY KEY cust_id, inv_no, line_no

    FOREIGN KEY cust_id, inv_no REFERENCES TABLE inv   ;
      CASCADE UPDATES                                  ;
      CASCADE DELETES                                  ;
      USE INDEX

    FOREIGN KEY part_no REFERENCES TABLE prt           ;
      RESTRICT UPDATES                                 ;
      RESTRICT DELETES                                 ;
      USE INDEX


  /****
  * This table is for the demo information.
  ****/

  DEFINE TABLE demoinfo   ALIAS info
    COLUMN screen         CHAR ( 10 )
    COLUMN text           VLF

    PRIMARY KEY screen


 END DATA DEFINITION MODULE

