* ͸
*  Program:       Info.prg                                               
*  Date Created:  Wed  03-16-1994                                        
*  Author:        Clifford Wiebe                                         
*  Note:          Copyright (c) 1994 Clifford Wiebe                      
*                 CI$: 71726,1642                                        
*                 19026 - 117A AVE                                       
*                 Pitt Meadows, BC, Canada, V3Y 1Y3                      
*                 Voice: (604) 465-3000                                  
*                                                                        
* Ĵ
*  Purpose:       Runtime Debugging / System Snapshot                    
* Ĵ
*                                                                        
* If you would like to see a stand-alone demo, compile with              
* CLIPPPER INFO /N /W /DTEST                                             
* and link with your favourite linker.                                   
*                                                                        
* Somewhere in your startup code, set a hotkey to Info(), I use          
* ALT-F10. You can then press this hotkey in any wait state to see a     
* snapshot of your system. Info does change tag orders, current alias,   
* but IT DOES RESTORE THEM. The Heart library mentioned in the code is   
* my own udf library. To include the code specific to a 3rd party lib,   
* uncomment the #define for that lib. Efforts have been made to use the  
* vanilla Clipper functions instead of specific third-party function     
* calls. For example, I couldn't find a function to return the total     
* number of open tags/indexes, so I wrote a small function to do it. This
* function is available in the Six Driver, sx_indexcount() and           
* sx_keycount(). The replacement function is TotalTags().                
*                                                                        
* Ĵ
* Before you jump all over me, I know initializing the aMessage to 500   
* and not doing any bounds checking is the lazy way out, but hey, why    
* don't *you* write the local error checking routine to bump up the array
* size and recover from the error!                                       
*                                                                        
*                                                                        
* The first time you run Info, it primes some static variables with      
* memory(x) values. The next time you invoke info, it compares these     
* values to current to report memory differences.                        
*                                                                        
* Feel free to use Info and include it with your applications, but you   
* are not allowed to charge for it, or re-sell it.                       
*                                                                        
*                                                                        
* ͵
*  Revision History                                                      
*  Date            Author           Notes                                
*                                                                        
*                                                                        
*                                                                        
*                                                                        
*                                                                        
*                                                                        
* ;

// uncomment out the defines for the modules you have
//  ͻ
//         If you are not using the Heart library,          
//       ****   MAKE SURE HEART IS NOT DEFINED  ****        
//  ͼ


#ifdef HEART
   #include "version.ch"      // include file for all version define's
   #include "tbwin.ch"        // required for array browsing
   #include "commands.ch"     // the usual default command etc.
#endif

#ifndef HEART
   #include "box.ch"          // include box drawing for the array browse
#endif

// Uncomment out any lines below for the 3rd-party libraries you are
// using. The function references are not extensive, I'm sure you can
// come up with some information you need, but isn't displayed.

//#define SIX15                  // SixDriver
//#define NETLIB2                // Pinnacle's Publishing Netlib 5.2x
//#define IDL2                   // IDC's IDL(2) Lib (not referenced)
//#define NOVLIB                 // Novlib ( version 2.1 used )
//#define NANFOR                 // Nanforum real-time library
//#define NANFORX                // Nanforum extended mode
//#define BLINKER2               // Blinker 2.x
//#define BLINKER3               // Blinker 3.x
//#define FUNCKY15               // Funcky version 1.5

#include "inkey.ch"

#ifdef BLINKER3
   #include "blinker.ch"
#endif

#ifdef SIX15
   #include "machsix.ch"
#endif

static nSub                      // subscript into current message slot
static aMessage                  // this is where everything is stored.


#ifndef HEART

   // we don't have heart.lib, duplicate some of the translates
   // found in cast.ch

   #xtranslate getkey(<x>)    => inkey(<x>)
   #xtranslate lstrim(<n>)    => ltrim(str(n))
   #xtranslate IsChar(<x>)    => (valtype(<x>) == 'C')
   #xtranslate IsNum(<x>)     => (valtype(<x>) == 'N')
   #xtranslate IsDate(<x>)    => (valtype(<x>) == 'D')
   #xtranslate IsArray(<x>)   => (valtype(<x>) == 'A')
   #xtranslate IsBool(<x>)    => (valtype(<x>) == 'L')
   #xtranslate IsNil(<x>)     => (valtype(<x>) == 'U')
   #xtranslate IsMemo(<x>)    => (valtype(<x>) == 'M')
   #xtranslate IsObject(<x>)  => (valtype(<x>) == 'O')
   #xtranslate IsBlock(<x>)   => (valtype(<x>) == 'B')

   #xtranslate Num2Logical ( <nValue> )   => iif(<nValue> == 0,.F.,.T.)
   #xtranslate Logical2Char( <lValue> )   => iif(<lValue>,".T.",".F.")
   #xtranslate Logical2Num ( <lValue> )   => iif(<lValue>,1,0)
   #xtranslate Num2Char    ( <nValue> )   => ltrim(str(<nValue>))
   #xtranslate Char2Block  ( <cValue> )   => &(<cValue>)

#endif

#define INFO_ARRAY_SIZE                 500


#ifdef TEST
function main()
   ? 'Starting Info'
   info()
   quit
return ( nil )
#endif

function Info()
   Local nMsg
   local n
   local n1, cMsgLine := savescreen(maxrow(),0,maxrow(),maxcol() )
   local oTb, nHotKey := lastkey()

   // save memory settings to track memory leakage
   static nStmemTot,       ;        // Total memory
          nStMemChar,      ;        // Memory avail to characters
          nStMemVir                 // Total virtual memory


   setkey(nHotKey,nil)              // NOT re-entrant

   nSub := 1
   aMessage := array(INFO_ARRAY_SIZE)

   aMessage := afill(aMessage,'')
   CallStack()                // Load CallStack Info
   LoadConfig()               // Load System Configuration
   #ifdef HEART
      LoadPaths()                // Load directory/path info
   #endif
   LoadMemory()               // Load Memory Information
   if nStMemTot != nil        // Load Memory Leakage information
      LoadLeakage(nStMemTot,nStMemChar, nStMemVir)
   endif
   #ifdef BLINKER3
      LoadBlink3()            // Load Blinker 3.x information
   #endif
   #ifdef BLINKER2
      LoadBlink2()            // Load Blinker 2.x information
   #endif
   LoadDBStat()               // Load Database Status
   CleanUp()                  // Clean up array, get ready to browse

   #ifdef HEART
      // code I use to browse the array
      // you can use your own routine, or contact Clifford Wiebe if
      // you want my routines
      oTb := artbwinNew(0,1,maxrow() - 2,78,aMessage,'[ System Information ]')
      // oTb:freezetext   := 10 // freeze first 10 characters
      oTb:title  := '[ System Information Snapshot ]'
      oTb:getcolumn(1):width := 80
      ClockOff()

      :oTb:browse()
      :oTb:tbkill()
      ClockOn()
   #endif
   #ifndef HEART
      // arbrowse is a static function found at the end of this
      // program
      ArBrowse( aMessage,'[ System Snapshot ]')
   #endif
   setkey(nHotkey, {|| info() })
   restscreen(maxrow(),0,maxrow(),maxcol(),cMsgLine)

   // if statics are nil, save memory values for comparison
   // later to detect memory leakage
   if nStMemTot == nil
      nStMemTot   := memory(0)
      nStMemChar  := memory(1)
      nStMemVir   := memory(3)
   endif

return ( NIL )

static function CallStack( )
   Local n := 0

   aMessage[nSub++] := padc('CallStack',79,'')

   while !(procname(n) == '')
      aMessage[nSub++] := procname(n)+ '(' + lstrim(procline(n++)) + ')'
   enddo
return ( nil )

static function LoadConfig( )
   aMessage[nSub++] := padc('Configuration Information',79,'')
   aMessage[nSub++] := '           RDD Driver Name: '+dbsetdriver()
   aMessage[nSub++] := '   Default Index Extension: '+ordbagext()
   #ifdef SIX15
      aMessage[nSub++] := '            sixcdx Version: '+ sx_version(3)
      aMessage[nSub++] := '           MachSix Version: '+ m6_version(3)
   #endif
   aMessage[nSub++] := '           Clipper Version: '+ version()
   #ifdef NOVLIB
      aMessage[nSub++] := '            NovLib Version: '+ NovLibVer()
   #endif
   aMessage[nSub++] := '           Blinker Version: '+ transform(BliVerNum()/100,'99.99')
   #ifdef FUNCKY15
      aMessage[nSub++] := '                  CPU Type: '+ str(cputype())
   #endif
   #ifdef NANFOR
      aMessage[nSub++] := '                  CPU Type: '+ 'NA'
   #endif
   #ifdef FUNCKY15
      aMessage[nSub++] := '    Math Coprocessor Found: '+ iif(ndptype()>0,'Yes','No')
   #endif
   #ifdef NANFORX
      aMessage[nSub++] := '               DOS Version: '+ ft_dosver()
   #endif
   aMessage[nSub++] := ''
   aMessage[nSub++] := '       Free Diskspace(): '+               ;
               transform(diskspace(),'9,999,999,999')
   aMessage[nSub++] := '          Color Setting: '+setcolor()
   aMessage[nSub++] := '        CLIPPER setting: '+GetEnv('CLIPPER')
   aMessage[nSub++] := '           TEMP setting: '+GetEnv('TEMP')
   aMessage[nSub++] := '            TMP setting: '+GetEnv('TMP')
   #ifdef NANFOR
      // don't use the ft_handcnt function with Blinker 3.x
      #ifndef BLINKER3
         aMessage[nSub++] := '     Config.sys handles: '+ str(Ft_HandCnt(),5)
         aMessage[nSub++] := '          Default Drive: '+ Ft_default()
      #endif
   #endif
   #ifdef NETLIB52
      aMessage[nSub++] := '       Netware Login ID: '     +n_whoami()
      aMessage[nSub++] := '              Full Name: '     +n_fullname()
      aMessage[nSub++] := ' Logical Station Number: '    +str(n_stanum(),5)
      aMessage[nSub++] := '   Max Handles from Net: '+str(n_handles(),5)
      aMessage[nSub++] := '      Available Handles: '+str(n_handles() - n_handles(-1),5)
   #endif
   #ifdef NOVLIB
      aMessage[nSub++] := '       Netware Login ID: '     +Any2Char(LoginName())
      aMessage[nSub++] := ' Logical Station Number: '    +str(ConnNo(),5)
   #endif
   #ifdef NANFOR
      aMessage[nSub++] := '       Netware Login ID: '     +ft_nwuid()
      aMessage[nSub++] := ' Logical Station Number: '    +str(ft_nwlstat(),5)
   #endif

return ( nil )

static function LoadDbStat()
   local nArea, nSaveArea, cAlias, n

   aMessage[nSub++] := padc('[ Database Status ]',79,'')
   aMessage[nSub++] := 'Current Work Area: '+str(select(),3 )
   aMessage[nSub++] := '    Current Alias: ' + alias()
   nArea := 1
   nSaveArea := select( alias() )
   DO WHILE nArea < 256
      IF LEN(ALIAS(nArea)) <> 0
         select( nArea )
         aMessage[nSub++] := padc('[ Database: '+alias()+' ]',79,'')
         aMessage[nSub++] := padl('Area:',16) +                      ;
                             str(nArea,2) + ' ' + space(5) +         ;
                           + '    Curr/Total: '+                     ;
                        transform( recno(),"999,999")+ "/"  +        ;
                        ltrim(transform( lastrec(),"999,999"))

         aMessage[nSub++] := padl('Record Size: ',16) +              ;
                              transform( recsize(),'9,999') +        ;
                             '      Header Size: '+                  ;
                             transform( header(),'9,999') +          ;
                             ' File Size: '+                         ;
                             transform( (recsize() * lastrec()) +    ;
                                         header() + 1,'99,999,999')
         if len( dbrlocklist() ) > 0
            aMessage[nSub++] := transform(len(dbrlocklist()),'999') + ;
                           ' LOCK(s) ACTIVE.    Record Numbers: '
            for n := 1 to len( dbrlocklist() )
               aMessage[nSub-1] += transform(dbrlocklist()[n],'9,999,999')
            next
         endif
         aMessage[nSub++] := padl('Bagname: ',16)+ordbagname() +     ;
                             '   Total Tags: '+str(TotalTags())
         aMessage[nSub++] := padl('Current Tag: ',16)+               ;
                              str(ordnumber() ) +                    ;
                             '    Tag Name: ' + ordname( ordnumber() )
         aMessage[nSub++] := padl("Deleted: ",16)+iif(deleted(),"Y","N")
         if !empty( dbfilter() )
            aMessage[nSub++] := ' Active Filter: '+dbfilter()
         else
            aMessage[nSub++] := 'Active Filter: *No Active Filter*'
         endif
         #ifdef SIX15
            SixFilterInfo()
         #endif
         LoadIndex( )
      ENDIF
      nArea++
   ENDDO
   Select ( nSaveArea )       // restore original area
return ( nil )

#ifdef SIX15
static function SixFilterInfo()
   local nHandle, aFiltInfo
   local aOptimize := {' Not Optimizable',' Partially Optimized',' Fully Optimized'}

   nHandle := m6_GetAreaFilter()
   if nHandle > 0
      aFiltInfo := m6_filtInfo( nHandle )
      aMessage[nSub++] := 'Six Driver Filter Info'
      aMessage[nSub++] := '     Filter Expression: ' + aFiltInfo[INFO_EXPR]
      aMessage[nSub++] := 'Non-Indexed Expression: ' + aFiltInfo[INFO_NONEXPR]
      aMessage[nSub++] := '    Optimization Level: ' +               ;
                           ltrim(str(aFiltInfo[INFO_OPTLVL])) +      ;
                           aOptimize[ aFiltInfo[INFO_OPTLVL]+1 ]
   endif
return ( nil )
#endif

static function TotalTags()
   local nBagCount := 0, n := 1
   local nSaveOrder := ordnumber()
   local cOrdSavTag

   ordsetfocus( 1 )

   if !empty( ordsetfocus() )
      // at least one tag active
      nBagCount++
      do while .T.
         // who came up with this ordsetfocus name anyway!
         cOrdSavTag := ordsetfocus(++n )
         if cOrdSavTag == ordsetfocus()
            exit
         endif
         nBagCount++
      enddo
   endif
   ordsetfocus( nSaveOrder )
return ( nBagCount )

static function LoadIndex()
   local nTagCount := TotalTags()
   local n

   aMessage[nSub++] := padc('[ Index Status for '+alias()+' ]',79,'')

   for n := 1 to nTagCount
      aMessage[nSub++] := "Tag "+str(n,2)+"    Name: "+padr(ordname( n ),12)
      aMessage[nSub++] := "          Expr: "+ordkey(n)
      aMessage[nSub++] := "         Value: "+any2char(&(ordkey(n)))

      if !empty( ordfor( n ) )
         aMessage[nSub++] := "    Tag Filter: "+ordfor(n)
      else
         aMessage[nSub++] := "    Tag Filter: NONE"
      endif
      #ifdef SIX15
         LoadSixInfo( n )
      #endif
      aMessage[nSub++] := ''
   next

return ( nil )

#ifdef SIX15
static function LoadSixInfo( n )
   local aTagInfo := {}

   aTagInfo := sx_taginfo()
   if len( aTagInfo ) >= n
      aMessage[nSub++] := "        Unique: "+iif(aTaginfo[n,4],'Y','N')
      aMessage[nSub++] := "       Descend: "+iif(aTaginfo[n,5],'Y','N')
      aMessage[nSub++] := "  Roll You Own: "+iif(aTaginfo[n,5],'Y','N')
   endif
return ( nSub )
#endif

#ifdef HEART
static function LoadPaths()
   // These are standard paths that are available to all systems
   // using Heart.lib
   aMessage[nSub++] := ''
   #ifdef NANFORX
      aMessage[nSub++] := '    Program Origin Path: '+ft_origin()
   #endif
   aMessage[nSub++] := ' Main Defined Data Path: '+DataPath()
   aMessage[nSub++] := '    Defined Report Path: '+ReportPath()
   aMessage[nSub++] := '    Defined Import Path: '+ImportPath()
   aMessage[nSub++] := '    Defined Export Path: '+ExportPath()
return ( nil )
#endif

static function LoadMemory()

   aMessage[nSub++] := padc('Memory Status',79,'')
   aMessage[nSub++] := '   Mem(0)=Total Char Space  Mem(1)  =Largest Avail Block'
   aMessage[nSub++] := '   Mem(2)=Avail to DOS      Mem(3)  =Total VMM'
   aMessage[nSub++] := '   Mem(4)=Avail EMS to VMM  Mem(101)=Fixed Heap Size(?)'
   aMessage[nSub++] := ''
#ifdef FUNCKY15
   aMessage[nSub++] := '    Installed Conv. Memory: '+ str(dosmem(),5)+'k'
   aMessage[nSub++] := '      Installed EMS Memory: '+ iif(isems(),str(expmem(),5)+'k','    0k')
   aMessage[nSub++] := '      Installed XMS Memory: '+ str(extmem(),5)+'k'
#endif
#ifdef NANFORX
   aMessage[nSub++] := '    Installed Conv. Memory: '+ str(ft_sysmem(),5)+'k'
   aMessage[nSub++] := '      Installed EMS Memory: '+ 'NA'
#endif

   aMessage[nSub++] := '        Memory(0): '+str(memory(0),7)+ 'k'+ space(3) + ;
                    '   Memory(1): '+str(memory(1),7)+ 'k'
   aMessage[nSub++] := '        Memory(3): '+str(memory(3),7)+ 'k'+ space(3) + ;
                    '   Memory(2): '+str(memory(2),7)+ 'k'
   aMessage[nSub++] := '        Memory(4): '+str(memory(4),7)+ 'k'+ space(3) + ;
                    ' Memory(101): '+str(memory(101),7)+'k'

   aMessage[nSub++] := 'Total (0,1,2,3,4): '+      ;
      transform(memory(0)+memory(1)+memory(2)+memory(3)+memory(4),'999,999')+'k'

return ( nil )

static function LoadLeakage(nStMemTot,nStMemChar, nStMemVir)
   aMessage[nSub++] := padc('Memory Leakage',79,'')
   aMessage[nSub++] := '      Lost Total Memory(0): '+str(nstMemTot - memory(0),7)+ 'k'
   aMessage[nSub++] := '  Lost Character Memory(1): '+str(nStMemChar - memory(1),7)+ 'k'
   aMessage[nSub++] := '    Lost Virtual Memory(3): '+str(nStMemVir - memory(3),7)+ 'k'
return ( nil )


#ifdef BLINKER3
static function LoadBlink3()
   local n
   aMessage[nSub++] := ''
   aMessage[nSub++] := padc('Blinker Extended Mode Information',79,'')

   n := BliMgrsts(BliMachineMode)
   if n < 0
      n := n + 1
   endif
   aMessage[nSub++] := '                Running In: '+{'Real','Protected'}[n+1]+' mode'
   n := BliMgrSts(BliCacheLoc) + 1
   aMessage[nSub++] := '  Overlay Cache Located In: '+{'*NO CACHE*','EMS Memory','XMS Memory'}[n]
   n := BliMgrSts(BliHostMode) + 1
   aMessage[nSub++] := '      DOS Extender Host is: '+{'*NO HOST*','DPMI','VCPI','XMS'}[n]
   n := BliMgrSts(BliRealMemAvail)
   aMessage[nSub++] := '     Real Memory Available: '+transform(int(n / 1024),'99,999,999k')
   n := BliMgrSts(BliVirMemAvail)
   aMessage[nSub++] := '  Virtual Memory Available: '+ transform(int(n / 1024),'99,999,999k')
   n := BliMgrSts(BliOverlaySize)
   aMessage[nSub++] := 'Overlay Pool Operating Sze: '+ transform(int(n / 1024),'99,999,999k')

return ( nil )
#endif

#ifdef BLINKER2
static function LoadBlink2()
   aMessage[nSub++] := ''
   aMessage[nSub++] := padc('Blinker 2.10 Real Mode Information',79,'')
   aMessage[nSub++] := ' Overlay Pool Current Size: '+ transform(BliOvlSiz(),'999,999')
   aMessage[nSub++] := '     Total Loaded Overlays: '+ transform(BliTotLod(),'999')
   aMessage[nSub++] := '     Total Active Overlays: '+ transform(BliTotAct(),'999')
#endif
return ( nil )

static function CleanUp()
   aMessage[nSub++] := '*end of informaton*'
   aMessage[nSub] := replicate('',79)
   // Resize the array to strip off the nil elements
   aMessage := asize(aMessage,nSub)
   keyboard chr( 0 )            // clear keyboard
return ( nil )

#ifndef HEART

static function arbrowse ( aPass, cTitle )
   // I gotta be honest with ya, I'm sure this code was swiped from
   // somewhere. Personally, I don't care for it because it uses two
   // private variables.
   // This is a quick 'plunk-in' just so Info() is self-contained.
   // You might want to use your own array browser instead
   local oTb, oTbc, n, k := 0, nMaxRow, c
   Local lExit := .f., nKey, aWindow
   local bBlock, cBlock, bSavError, cSav := savescreen(1,1,maxrow(),maxcol() )
   local nTop := 1
   local nLeft := 1
   local nRight := maxcol() - 2
   local nBott  := maxrow() - 2
   local cColor := setcolor('W+/B')
   memvar aR, nPos
   private aR, nPos

   nRowSub := 1
   nPos := 1
   aR := aclone(aPass)

   nMaxRow := len(aR)

   dispbox(nTop-1,nLeft-1,nBott+1,nRight+1,B_SINGLE)
   @ nTop-1,2 say cTitle
   scroll(nTop,nLeft,nBott,nRight,0)
   oTb := tbrowsenew(nTop,nLeft,nBott,nRight)
   oTb:skipBlock := {|x| ;
                  k := IF(ABS(x) >= IF(x >= 0,;
                  nMaxRow - nRowSub, nRowSub - 1),;
                  IF(x >= 0, nMaxRow - nRowsub,1 - nRowSub),;
                  x), nRowSub += k,;
                  k }

   oTb:gobottomblock = {|| nRowSub := nMaxRow}
   oTb:gotopblock    = {|| nRowSub := 1}

   oTb:addcolumn( tbcolumnNew( '',{|| substr(aR[nRowSub],nPos) } ) )
   oTb:getcolumn(1):width := nRight - nLeft   + 1
   lExit = .F.
   while !lExit

      while nextkey() = 0 .AND. !oTb:stabilize()
      enddo

      nkey = getkey(0)
      if nKey == K_RIGHT .and. nPos < len( ar[nRowSub] )
         nPos++
         oTb:right()
         oTb:refreshall()
         loop
      endif
      if nKey == K_LEFT .and. nPos > 1
         nPos--
         oTb:left()
         oTb:refreshall()
         loop
      endif

      if !StdMethods ( nKey, oTb )
         do case
            case nKey = K_ESC
               lExit = .T.
               oTb:configure()
               oTb:refreshall()

            case nKey = K_ENTER
               lExit = .T.
          * Other exception handling ...
         endcase
      endif
   enddo
   restscreen(nTop-1,nLeft-1,nBott+1,nRight+1,cSav )
   setcolor( cColor )
RETURN nRowSub


static function StdMethods ( nKey, b )
   Local nKeyHandled := .t.

   do case
      case nKey == K_DOWN        ;     b:down()
      case nKey == K_UP          ;     b:up()
      case nKey == K_PGDN        ;     b:pagedown()
      case nKey == K_PGUP        ;     b:pageup()
      case nKey == K_CTRL_PGUP   ;     b:gotop()
      case nKey == K_CTRL_PGDN   ;     b:gobottom()
      case nKey == K_RIGHT       ;     b:right()
      case nKey == K_LEFT        ;     b:left()
      case nKey == K_CTRL_LEFT   ;     b:panleft()
      case nKey == K_CTRL_RIGHT  ;     b:panright()
      case nKey == K_CTRL_HOME   ;     b:panhome()
      case nKey == K_CTRL_END    ;     b:panend()
      otherwise                  ;     nKeyHandled := .f.
   endcase
return ( nKeyHandled )

STATIC FUNCTION ABrowseBlock( a, x )

RETURN ( {|p| IF( PCOUNT() == 0, a[nRowSub, x], a[nRowSub, x] := p ) } )

static function Any2Char( value )
      Local rvalue
      do case
         case value == nil
            rValue := 'nil'
         case ischar(value)
            rValue := value
         case isnum(value)
            rValue := Num2Char(Value)
         case isdate(value)
            rvalue := dtoc(value)
         case isBool(value)
            rvalue := Logical2Char( value )
         case isMemo(value)
            rvalue := MemoRead ( Value )
         case isObject(value)
            rvalue := '*Object*'
         case isBlock(value)
            rvalue := '*Block*'
         case IsArray(value)
            rvalue := Array2Char(value)
         case IsNil(value)
            rvalue := 'NIL'
      endcase
   return (rvalue)

static function Array2Char( aValue )
   local c := '{'
   aeval(aValue,{|a| c += "" + Any2Char(a) + "," })
   c += '}'
return ( c )

#endif
