*  Function Name:		ASinglCh()
*  Written By:			George Sexton, 11/20/92
*  Description:			ASinglCh() (Array Single Choice) is a popup
*						screen function designed to display an array
*						and allow the user to select one item
*						from it.  The display window auto-sizes itself
*						with an option to override the default behavior.
*
*  Parameters:
*
*		AList			This is the array to use for the display.  The
*						column to select must be of type character.
*
*
*		<CTitle>		This is the optional title to use on the pop-up window.
*						If this option is ommitted, the default title is CHOOSE 1.
*
*
*		<Column>		This is the column of the array to display.  You can use
*						This function to display a multiple column array.  The default
*						operation is that column 1 is displayed, but by passing
*						<Column>, you can override this behavior.
*
*		<NRow1>, <NCol1>	This is the optional coordinates for the upper right
*		<nRow2>, <nCol2>	and lower left corners of the popup.  If you pass one
*						pair of parameters, you must pass all.
*
*  Returns:				The element number selected, or 0 if the user
*						pressed escape.
*
*
*  Sample Usage:
*
*		Select L10, acctName+l10 from detacct into array aAccts
*		nChoice=aSinglCh(@aAccts, "Select Account", 2)
*		if nChoice > 0
*			cAcctNo=aAccts[nChoice, 1]
*		else
*			wait window "user pressed escape"
*		endif
*

parameters aChArray , cTitle , nAColumn , nY1 , nX1 , nY2 , nX2
private naWidth , lOneDimension , nWorkArea , nCounter , nAnswer , ;
		nxCtr , nYCtr , nHeight , cLastConfirm , n
external array aChArray
nWorkArea = select()
cLastConfirm = set('CONFIRM')
set confirm on
push key clear
if empty(nAColumn)
	nAColumn = 1
endif
if empty(cTitle)
	CTitle = "Choose 1"
endif
nAWidth = 0
lOneDimension = (alen(aChArray , 2) = 0)

for n = 1 to alen(aChArray , 1)
	if lOneDimension
		nAWidth = max(nAWidth , len(aChArray[n]) + 3)
	else
		nAWidth = max(nAWidth , len(aChArray[n , nAColumn]) + 3)
	endif
endfor

create cursor aPop (Field1 C(nAWidth) )
if lOneDimension
	for nCounter = 1 to alen(aChArray , 1)
		append blank
		replace field1 with aChArray[nCounter]
	endfor
else
	for nCounter = 1 to alen(aChArray , 1)
		append blank
		replace field1 with aChArray[nCounter , nAColumn]
	endfor
endif
if type('nY1') <> 'N'
	*  We Need to calculate the location and size of the popup
	nxCtr = scols() / 2
	nYCtr = srows() / 2
	nX1 = max(0 , nxCtr - nAWidth / 2)
	nX2 = min(scols() - 1 , nXCtr + nAWidth / 2)
	nHeight = min(srows() - 4 , reccount() + 1)
	nY1 = max(1 , nYCtr - nHeight / 2)
	nY2 = min(srows() - 4 , nYCtr + nHeight / 2)
endif
define popup ASinglCh ;
		from nY1 , nX1 to nY2 , nX2 ;
		prompt field Field1 ;
		scroll shadow ;
		color scheme 6 ;
		title cTitle
on selection popup ASinglCh deactivate popup aSinglCh
activate popup aSingLCh
if lastkey() = 27
	nAnswer = 0
else
	nAnswer = recno()
endif
release popup ASinglCh
set confirm &cLastConfirm
use
select (nWorkArea)
pop key
return nAnswer
