//
//        Program: EvalTime.c
//     Written by: Christopher A. Zielinski,  (CIS: 72723,2701)
//                 (416) 767-9674  9am-5pm  EST  voice/fax
//           Date: 94.01.01
//
//        Compile: CL /c /AL /FPa /Gs /Zl EvalTime.c
//
//                 Copyright (c) 1994  Christopher A. Zielinski
//


#include "Extend.api"
#include "Item.api"
#include <dos.h>


// Interrupt generated on each clock tick
#define INT_TICKS       0x1C

// Number of clock ticks per second
#define TICKS_PER_SEC   18.2  

void ( _cdecl _interrupt _far *old_int )( void );
void _cdecl _interrupt _far ISR_Routine( void );
char _far *_getindosAddress( void );

// Initialized with NULL pointer!
char _far *indos = 0;
         
// Largest code block string is 255 characters
char CodeBlockStr[256];       
int Ticks = 0;
int TickerCount = 0;
int tHooked = 0;

union REGS ir, or;

CLIPPER _MnTmEval()
{
  char *CodeBlock;
  int i = 0;

  if (PCOUNT == 2 && ISNUM( 1 ) && ISCHAR(2)) {
    if ( ( Ticks = _parni( 1 ) * TICKS_PER_SEC ) >= 1 ) {
      TickerCount = Ticks;

      // Clear previous code block string
      while (CodeBlockStr[ i ])
        CodeBlockStr[ i++ ] = '\0';

      // Move transfer code block string from Clipper to a global variable
      i = 0;
      CodeBlock = _parc( 2 );
      while (CodeBlock[ i ])
      {
        CodeBlockStr[ i ] = *( CodeBlock + i );
        i++;
      }

      // Reduce programming error controlling access to clock hooking logic
			if (! tHooked) {

        // If indos is a NULL pointer
        if  ( ! indos )

          // Get indos's address (pointer)
          indos = _getindosAddress(); 

        // Get current ISR
        old_int = (void _far *) _dos_getvect( INT_TICKS );

        // Don't allow calls until ISR is fully installed
        _disable();

        // Hook in our Clipper code
        _dos_setvect( INT_TICKS, (void (_cdecl _interrupt _far *)(void)) ISR_Routine );

        // Re-enable ISR's
        _enable();  
				tHooked = 1;
			}
		}
	}
  else {

    // Make sure there is a hook to remove, before we remove it
    if (old_int != NULL) {

      _disable();

      // Set ISR back, a MUST before terminating the program!!!
      _dos_setvect( INT_TICKS, (void (_cdecl _interrupt _far *)(void)) old_int );

      _enable();
      old_int = NULL;
			tHooked = 0;
    }
  }
  _ret();
}


void _cdecl _interrupt _far ISR_Routine()
{
  EVALINFO evalInfo;
  ITEM itemRet;

  // Gate logic based on time passed
  if ( ++TickerCount >= Ticks ) {

    //  InDOS is a flag used by DOS itself.  When DOS enters an Int 21h
    //  function DOS increments the InDOS flag; when DOS leaves, it
    //  decrements the flag.  This flag is required because the operating
    //  system kernal is not fully reentrant!
    //
    //  Some times this flag can be misleading, but better safe than sorry.

    if (! *indos) {


      _disable();

      // Create an evalInfo for the macro compiler procedure in CtrlTime.prg
      _evalNew( &evalInfo, _itemPutC( NULL, "__MacroCl" ) );

      // Pass the single parameter to the macro compiler __MacroCl
      _evalPutParam( &evalInfo, _itemPutC( NULL, CodeBlockStr ) );

      // Call function and save the resulting compiled code block
      itemRet = _evalLaunch( &evalInfo );

      // Reuse the &evalInfo structure for the compilted code block
      _evalNew( &evalInfo, itemRet );

      // Execute the code block
      itemRet = _evalLaunch( &evalInfo );

      // Release &evalInfo structure
      _evalRelease( &evalInfo );

      // Toss away the return item -- we don't care about return values
      _itemRelease( itemRet );

      TickerCount = 0;  
      _enable();
    }
  }
  // Return control to the computer's original timer vector
  _chain_intr( old_int ); 
}


char _far *_getindosAddress( void )
{
  union REGS in, out;
  struct SREGS sregs;

  in.h.ah = 0x34;
  segread( &sregs );
  intdosx( &in, &out, &sregs );

  // Int 21h Function 34h -- Return address of InDOS Flag
  //
  // Calling Registers:  AH      34h
  //  Return Registers:  ES:BX   Pointer to InDOS Flag

  return(
    (char _far *)
    ( ((unsigned long)(sregs.es)<<16) | (unsigned long)(out.x.bx) ) );
}


