/* ===================================================================
   The purpose of this example code is to demonstrate the use of the
   ClipXMS() function.  You can compile this code and run it under a
   variety of computer configurations and test the effect of using the
   NOEMS and NOXMS environment settings.

   Compile this test program using the /n switch:
      CLIPPER example1 /n
   Link this test program with the ClipXMS .OBJ files:
      RTLINK file example1, clipxms1, clipxms2
   =================================================================== */


FUNCTION Test()
/* -------------------------------------------------------------------
   This function simply calls the other three example functions.
   ------------------------------------------------------------------- */
	LOCAL GetList := {}
	LOCAL lTestVMM := .F.

	CLEAR SCREEN

	// See if there is unmanaged extended memory.
	IF !CheckExtMem()
		ALERT("Unmanaged Extended Memory Was Not Detected", {"Continue"})
	ENDIF

	// Print out ClipXMS() information
	ClipXMSInfo()
	?
	? "Press any key to continue..."
	INKEY(0)

	// Test Clipper's VMM system if requested
	CLEAR SCREEN
	@ 1, 0 SAY "Test Clipper's VMM system (Y/N)?" GET lTestVMM PICTURE "Y"
	READ
	IF lTestVMM
		TestVMM()
	ENDIF

	?
	? "Example code is finished."

	RETURN(NIL)



FUNCTION CheckExtMem()
/* -------------------------------------------------------------------
   This example function can be used at the beginning of your Clipper
	application to test for the presence of a memory manager when
	available extended memory is present.  If a memory manager is not
	present, but extended memory is available, this example function
	will display ALERT() boxes informing the user they can enhance
	performance of the Clipper application by loading a memory manager.
   ------------------------------------------------------------------- */
   LOCAL nExtMem

   nExtMem := ClipXMS(6)

   IF nExtMem > 200
      // If there is more than 200K of unmanaged extended memory,
      // inform the user they could enhance performance by loading
      // a memory manager.  200K is an arbitrary but reasonable cutoff.

      ALERT( ;
         "Unmanaged Extended Memory Has Been Detected!;" + ;
         "Your computer has available extended memory,;" + ;
         "but no memory manager loaded.", ;
         {"Continue"})

      ALERT( ;
         "For best performance of this application;" + ;
         "you should load a memory manager such as;" + ;
         "HIMEM.SYS in your CONFIG.SYS file.", ;
         {"Continue"})

      ALERT( ;
         "Loading a memory manager would make nearly;" + ;
         LTRIM(STR(nExtMem)) + "K of extended memory available to this;" + ;
         "application, enhancing its performance!", ;
         {"OK"})

   ENDIF

   RETURN(nExtMem > 200)



FUNCTION ClipXMSInfo()
/* -------------------------------------------------------------------
   This example function prints out ClipXMS info returned by the ClipXMS()
   function.  If you do not load a memory manager in your CONFIG.SYS, this
	function will print out a warning message.
   ------------------------------------------------------------------- */
	LOCAL cExtMem

   ? "ClipXMS(1) (version number) = " + LTRIM(STR(ClipXMS(1) / 100))
   ? "ClipXMS(2) (serial number)  = " + LTRIM(STR(ClipXMS(2)))
   ? "ClipXMS(3) (EMS memory at startup) = " + LTRIM(STR(ClipXMS(3)))
   ? "ClipXMS(4) (XMS memory at startup) = " + LTRIM(STR(ClipXMS(4)))
   ? "ClipXMS(5) (Using EMS:1, XMS:2, Protected Mode:3)  = " + LTRIM(STR(ClipXMS(5)))
   ? "ClipXMS(6) (extended memory if no EMS/XMS present) = " + LTRIM(STR(ClipXMS(6)))

   IF ClipXMS(6) > 0
		cExtMem := LTRIM(STR(ClipXMS(6)))
		?
		? "******************************************************************"
	   ? "* Neither an EMS nor an XMS memory manager was found, but this   *"
	   ? "* computer does have " + cExtMem + "K of extended memory installed.  Use a" + SPACE(6 - LEN(cExtMem)) + "*"
	   ? "* memory manager such as HIMEM.SYS to improve the performance of *"
	   ? "* your Clipper applications !!!                                  *"
		? "******************************************************************"
		?
   ENDIF

	RETURN(NIL)



FUNCTION TestVMM()
/* -------------------------------------------------------------------
   This function provides a simple test of Clipper's VM system, verifying
	that ClipXMS is swapping memory properly.  For testing purposes you
	can call this function in a test program and run the test program
	using the //NOEMS and //NOXMS switches separately and together to see
	their affect on program performance.

   In a memory swapping intensive test such as this, you may notice XMS
	memory swapping is slightly slower than EMS memory swapping, but in
	a real world program that difference is not noticeable.
   ------------------------------------------------------------------- */
   LOCAL MyArray[1000]
   LOCAL nTemp1
   LOCAL cChar

   FOR nTemp1 := 1 TO 1000
   	cChar := CHR(nTemp1 % 256)
   	MyArray[nTemp1] := REPLICATE(cChar, 1000)
   	? nTemp1
   NEXT nTemp1

   ?
   ? "Press any key to test integrity of swapped memory..."
   INKEY(0)

   FOR nTemp1 := 1 TO 1000
   	cChar := CHR(nTemp1 % 256)
   	IF !(MyArray[nTemp1] == REPLICATE(cChar, 1000))
   		? "Error in array element" + LTRIM(STR(nTemp1))
   	ENDIF
   NEXT nTemp1

	? "Test completed."

	RETURN(NIL)



