//----------------------------------------------------------------------------
//           Name: DirExist()
//        Purpose: Check if a directory exist
//
//         Author: Wilson H. Yuen
//   Date created: 03-27-93
//   Time created: 01:50:59am
//      Copyright: Wilson H. Yuen
//
//         Syntax: DirExist( cDir ) --> lRetVal
//
//       Argument: cDir - directory path
//
//   Return Value: lRetVal - TRUE directory exist
//
//    Description: If the directory does not exist the system will prompt
//                 the user to create it.
//
//        Example: If ! DirExist("C:\DOS")
//                    ErrMsg("Directory C:\DOS does not exist")
//                 Endif
//
//----------------------------------------------------------------------------
#include "Backup.ch"

Function DirExist(cDir)
  Local lRetVal := .f.

  //-- if the last character is a "\" strip it out
  cDir := alltrim(cDir)
  If substr(cDir,-1,1) == "\"
     cDir := substr(cDir,1,len(cDir)-1)
  Endif

  If IsDir( cDir := alltrim(cDir) )
     lRetVal := .t.
  ElseIf ALERT({"The sub-directory "+cDir+" does not exist.",;
                "Do you want to create it?"},;
               {"Yes","No"},;
               {"W+/BR", "GR+/BR", "BG+/BR, W+/B"}) == 1
     //-- create subdirectory
     If ! mkdir(cDir)
        ErrMsg("Unable to create subdirectory")
     Else
        lRetVal := .t.
     Endif
  Endif

Return(lRetVal)
* eof DirExist()
*
*
