#include "adl.ch"

STATIC nRow

FUNCTION MakeADL (file)
   LOCAL cCode, cBlocks

   QOUT('')
   nRow = ROW()

   cCode = MEMOREAD (file)
   SetADL (ADL_PARSE, .T.)
   SetADL (ADL_COMPBLK, {|nL, cT| PreProcess(nL, cT)} )

   cBlocks = COMPILE (cCode)

   IF empty( SetADL (ADL_ERROR) )
      MEMOWRIT(LEFT(file, AT('.',file))+'ADL', cBlocks)
   ELSE
      QOUT (setADL(ADL_ERROR) )
   ENDIF

   QOUT('')
   RETURN NIL


FUNCTION PreProcess (nLine, cText)
  LOCAL cNewText

  IF alltrim(upper(cText)) = 'SET TRACE OFF'
     cNewText = 'SetADL(2, .F.)'
  ENDIF

  devpos(nRow, 0)
  qout('Compiling line '+str(nLine, 5))
  RETURN cNewText



