/*****************************************
 *************   structs.h   *************
 *****************************************/

#include <intuition/intuition.h>   /* struct IntuiMessage */

typedef struct project *prjptr;

struct project
   {
   int no_notes;
   int no_notes_visable;

   struct ndnode *notes_start;
   struct ndnode *notes_end;

   struct ndnode *currnode;
   struct ndnode *copybuffernode;

   /***   Data to be read from tooltypes   ***/

   BOOL editnotes;         /* FALSE if showing notes */
   BOOL showedit;          /* Do we show edit window if no notes on startup */
   BOOL startedit;         /* If no notes, TRUE will show edit window */
   BOOL abouttoclose;      /* Set TRUE if user clicks on About window */
   BOOL quit;              /* Remains FALSE until you want to quit */

   BOOL titlechanged, notechanged, filechanged;

   ULONG delay;            /* In seconds */

   char notefile[STRLEN_FNAME];
   int backcolour;
   int textcolour;

   /***********************************************/

   int nextx,nexty;

   struct TextAttr notefont;

   char fontname[STRLEN_FONTNAME];

   struct MsgPort *msgport;
   struct IntuiMessage currmessage;

   struct TextFont *notefontptr;

   UWORD noteheight, notewidth;   
   };

typedef struct note *nteptr;

struct note
   {
   int xpos, ypos;

   char title[STRLEN_TITLE];
   char note[STRLEN_NOTE];

   struct Window *win;

   /***   DoubleClick info   ***/

   ULONG leftseconds,leftmicros;
   ULONG rightseconds,rightmicros;

   BOOL show;
   };

/*** Linked list "min" node ***/

struct ndnode
   {
   struct ndnode *next;
   struct ndnode *prev;
       
   void *data;
   };
 
