/*********************************************
 ***************  linkedlist.c  **************
 *********************************************/

#include <exec/types.h>
#include <graphics/text.h>

#include <stdio.h>
#include <stdlib.h>

#include "consts.h"
#include "structs.h"
#include "prototype.h"

/***   lle == linked list element   ***/

struct ndnode *llealloc(void)
   {
   struct ndnode *temp;

   temp = (struct ndnode *)malloc(sizeof(struct ndnode));

   if (temp == NULL)
      error ("Linked list error",ERR_MALLOC);

   temp->data = NULL;

   return (temp);
   }

/* Add new node after here */

void lleadd(struct ndnode *here,struct ndnode *new)
   {
   new->next = here->next;
   new->prev = here;
   here->next = new;
   new->next->prev = new;
   }

void llfree(struct ndnode *here)
   {
   struct ndnode *temp;

   do
      {
      temp=here->next;

      /* If there's any data connected to the node, free it first */

      if (here->data)
         free((void *)here->data);

      free((void *)here);

      here=temp;
      } while (here!=NULL);
   }

/***   Frees from here to end, not freeing tail node   ***/

void llfreemid(struct ndnode *here)
   {
   struct ndnode *temp,*store;

   if ((here->next == NULL) || (here->prev == NULL))    /* If at head or tail */
      return;

   store = here->prev;

   do
      {
      temp=here->next;

      /* If there's any data connected to the node, free it first */

      if (here->data)
         free((void *)here->data);

      free((void *)here);

      here=temp;
      } while (here->next != NULL);

   /***   Patch links   ***/

   store->next = here;
   here->prev = store;
   }

void lleremove(struct ndnode *here)
   {
   here->prev->next = here->next;
   here->next->prev = here->prev;

   if (here->data != NULL)
      free((void *)here->data);

   free((void *)here);
   }

void llstart(struct ndnode *start,struct ndnode *end)
   {
   start->prev =
      end->next = NULL;

   start->data =
      end->data = NULL;

   start->next = end;
   end->prev = start;
   }

/***   StickIt routines *******************************************************/

extern prjptr prj;

/******************************************************************************
Function : void initlists(void)
Purpose : Initialises the linked lists.
*******************************************************************************/

void initlists()
	{
	prj->notes_start = llealloc();
	prj->notes_end = llealloc();

	llstart(prj->notes_start,prj->notes_end);
	}
