/***************************************
 *************   edit.c   **************
 ***************************************/

#include <dos/dos.h>
#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/classes.h>
#include <intuition/classusr.h>
#include <intuition/imageclass.h>
#include <intuition/gadgetclass.h>
#include <libraries/gadtools.h>
#include <graphics/displayinfo.h>
#include <graphics/gfxbase.h>
#include <graphics/text.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/graphics_protos.h>
#include <clib/utility_protos.h>
#include <clib/diskfont_protos.h>
#include <clib/dos_protos.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "stickit.h"

#include "consts.h"
#include "structs.h"
#include "prototype.h"

extern prjptr prj;
extern struct Window *aboutWnd;
extern struct Window *editWnd;

extern struct Gadget *editGadgets[];

void openedit()
   {
   ULONG signals;
   int running = TRUE;

   if(OpeneditWindow())
      error("Can't open edit window\n",ERR_FATAL);

   if (prj->no_notes != 0)
      {
      displaynote();
      updatebuttons();
      }
   else
      {
      prj->currnode = NULL;

      andysselectgadget(editGadgets[GDX_show],editWnd);

      updatebuttons();

      ActivateGadget(editGadgets[GDX_title],editWnd,NULL);
      }

   /***   Show number of notes   ***/

   changeno_notes(0);

   while(running)
      {
      if (aboutWnd)
         {
         signals = Wait((1L << editWnd->UserPort->mp_SigBit) |
                        (1L << aboutWnd->UserPort->mp_SigBit));

         if (signals & (1L << editWnd->UserPort->mp_SigBit))
            running = HandleeditIDCMP();
         else if (signals & (1L << aboutWnd->UserPort->mp_SigBit))
            running = HandleaboutIDCMP();
         }
      else
         {
         Wait(1L << editWnd->UserPort->mp_SigBit);

         running = HandleeditIDCMP();
         }

      /***   Do we close about window ?   ***/

      if ((aboutWnd) && (prj->abouttoclose))
         {
         CloseaboutWindow();
         prj->abouttoclose = FALSE;
         }
         
      }

   /***   Close window here, not in stickit_fns.c   ***/

   CloseeditWindow();

   if (aboutWnd)
      CloseaboutWindow();

   prj->editnotes = FALSE;
   }

void displaynote()
   {
   nteptr currnote;

   if (prj->currnode)
      {
      currnote = prj->currnode->data;

      /***   Copy strings into string gadgets   ***/

      strncpy(GetString(editGadgets[GDX_title]),currnote->title,STRLEN_TITLE);
      strncpy(GetString(editGadgets[GDX_note]),currnote->note,STRLEN_NOTE);

      /***   Refresh text gadgets   ***/

      RefreshGList(editGadgets[GDX_title],editWnd,NULL,1);
      RefreshGList(editGadgets[GDX_note],editWnd,NULL,1);
      }
   }

void updatebuttons()
   {
   if (prj->currnode)
      {
      andysongadget(editGadgets[GDX_show],editWnd);

      andysongadget(editGadgets[GDX_notes],editWnd);

      /***   Test for ends of list   ***/

      if (prj->currnode->next->next == NULL)
         {
         andysoffgadget(editGadgets[GDX_toend],editWnd);
         andysoffgadget(editGadgets[GDX_next],editWnd);
         }
      else
         {
         andysongadget(editGadgets[GDX_toend],editWnd);
         andysongadget(editGadgets[GDX_next],editWnd);
         }

      if (prj->currnode->prev->prev == NULL)
         {
         andysoffgadget(editGadgets[GDX_tostart],editWnd);
         andysoffgadget(editGadgets[GDX_prev],editWnd);
         }
      else
         {
         andysongadget(editGadgets[GDX_tostart],editWnd);
         andysongadget(editGadgets[GDX_prev],editWnd);
         }

      if (((nteptr)prj->currnode->data)->show)
         andysselectgadget(editGadgets[GDX_show],editWnd);
      else
         andysunselectgadget(editGadgets[GDX_show],editWnd);
      }
   else
      {
      andysoffgadget(editGadgets[GDX_show],editWnd);
      andysoffgadget(editGadgets[GDX_notes],editWnd);

      andysoffgadget(editGadgets[GDX_tostart],editWnd);
      andysoffgadget(editGadgets[GDX_prev],editWnd);
      andysoffgadget(editGadgets[GDX_next],editWnd);
      andysoffgadget(editGadgets[GDX_toend],editWnd);
      }
   }

void changeno_notes(int no)
   {
   prj->no_notes += no;

   GT_SetGadgetAttrs(editGadgets[GDX_notetotal],editWnd,NULL,
      GTNM_Number,(LONG)prj->no_notes,TAG_END);
   }
