/*
   CreateEmptyFile.rexx         1993 Andy Dean
   ~~~~~~~~~~~~~~~~~~~~         ~~~~~~~~~~~~~~~
   Opens an file for writing which it then promptly closes. This results
in a file of length 0 bytes.

*/

say "CreateEmptyFile 1993 Andy Dean"

if (arg() ~= 1) then do
   options prompt "Enter filename for empty file : "
   parse pull fname
   end
else do
   fname = arg(1)
   end

if (fname = "") then do
   say "Error : Invalid filename"
   exit
   end

result = open(temp,fname,"Write")

if (result ~= 1) then do
   say "Can't open file "fname
   exit
   end

result = close(temp)

if (result ~= 1) then do
   say "Can't close file "fname
   exit
   end

say "Empty file ``"fname"'' created..."
exit
