/*
 *	File:					Iffconfig.h
 *	Description:	Defines the structure of the configuration and events.
 *								Reads and writes the project as an IFF-FORM.
 *
 *	(C) 1993 Ketil Hunn
 *
 */

#include <clib/iffparse_protos.h>
#include <libraries/iffparse.h>

#define  ID_PREF	MAKE_ID('P','R','E','F')
#define  ID_CONF	MAKE_ID('C','O','N','F')
#define  ID_EVNT	MAKE_ID('E','V','N','T')
#define  ID_ETXT	MAKE_ID('E','T','X','T')

extern APTR app,window,editwin;
extern Object *eventlist, *textlist;

struct FileRequester *aslreq=NULL;

char    *ifferrormsgs[] = {"End of file (not an error).",
													"End of context (not an error).",
													"No lexical scope.",
													"Insufficient memory.",
													"Stream read error.",
													"Stream write error.",
													"Stream seek error.",
													"File is corrupt.",
													"IFF syntax error.",
													"Not an IFF file.",
													"Required call-back hook missing.",
													"Return to client.  You should never see this."};

struct Config {
	BOOL	centrerequesters;
	BOOL	groupevents;
	BOOL	flashscreen;
	BOOL	ack_events;
	BOOL	ack_alerts;
	BOOL	autodelete;
	BOOL	confirm;
	BOOL	autoopencalendar;
	BOOL	usereqtools;
	int		sortby;
} config;

struct EventNode {
	char				name[30];
	short				whendate;
	short				day;
	short				month;
	int					year;
	short				whentime;
	short				hour;
	short				minutes;
	int					days;
	int					repeat;
	short				type;
	short				show;
	short				calc;
	long				datestamp;
	short				display;
	short				expansion1;
	short				expansion2;
	struct List	*textlist;
};

BOOL ReadIFF(Object *list, char *file)
{
	struct IFFHandle		*iff=NULL;
	struct ContextNode	*cn=NULL;
	struct EventNode		*eventnode=NULL,tmpnode;
	char 								tmp[256];
	long								error=0;

	set(window, MUIA_Window_Sleep, TRUE);
	set(list, MUIA_List_Quiet, TRUE);
	if(iff=AllocIFF())
	{
		if(iff->iff_Stream=Open(file, MODE_OLDFILE))
		{
			InitIFFasDOS (iff);
			if(!(error=OpenIFF(iff, IFFF_READ)))
			{
				ParseIFF(iff, IFFPARSE_RAWSTEP);
				cn=CurrentChunk(iff);
				if(cn->cn_ID!=ID_FORM && cn->cn_Type!=ID_PREF)
					MUI_Request(app, window, 0, NULL, "*OK","'%s'\nis not a " PROGNAME " IFF-file!", file);
				else
				{
					ParseIFF(iff, IFFPARSE_RAWSTEP);
					cn=CurrentChunk(iff);
					if(cn->cn_ID!=ID_CONF)
						MUI_Request(app, window, 0, NULL, "*OK","'%s'\nis not a " PROGNAME " IFF-file!", file);
					else
					{
						ReadChunkBytes(iff,(APTR)&config,cn->cn_Size);

						while(TRUE)
						{
							error=ParseIFF(iff, IFFPARSE_RAWSTEP);
							if(error==IFFERR_EOC)
								continue;
							else if(error)
								break;

							if(cn=CurrentChunk(iff))
							{
								switch(cn->cn_ID)
								{
									case ID_EVNT:
										if(ReadChunkBytes(iff,(APTR)&tmpnode,cn->cn_Size)==sizeof(struct EventNode)) {
											eventnode=AddEvent(eventlist, tmpnode.name, MUIV_List_Insert_Bottom);
											eventnode->whendate	=tmpnode.whendate;
											eventnode->day			=tmpnode.day;
											eventnode->month		=tmpnode.month;
											eventnode->year			=tmpnode.year;
											eventnode->whentime	=tmpnode.whentime;
											eventnode->hour			=tmpnode.hour;
											eventnode->minutes	=tmpnode.minutes;
											eventnode->days			=tmpnode.days;
											eventnode->repeat		=tmpnode.repeat;
											eventnode->type			=tmpnode.type;
											eventnode->show			=tmpnode.show;
											eventnode->calc			=tmpnode.calc;
											eventnode->datestamp=tmpnode.datestamp;
										}
										break;

									case ID_ETXT:
										if(ReadChunkBytes(iff,(APTR)&tmp,cn->cn_Size)==cn->cn_Size & eventnode!=NULL)
											AddText(eventnode->textlist, tmp, MUIV_List_Insert_Bottom);
										break;
								}
							}
						}
						if(error!=IFFERR_EOF)
							MUI_Request(app, window, 0, NULL, "*OK",
													"IFFfile scan aborted: %s",ifferrormsgs[-error - 1]);
					}
				}
				CloseIFF (iff);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_CENTRE_REQUESTERS, config.centrerequesters);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_GROUP_EVENTS, config.groupevents);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_FLASH_SCREEN,config.flashscreen);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_ACK_EVENTS, config.ack_events);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_ACK_ALERTS, config.ack_alerts);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_AUTODELETE, config.autodelete);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_CONFIRM, config.confirm);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_AUTOOPEN_CALENDAR, config.autoopencalendar);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_REQTOOLS, config.usereqtools);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_SORTBY_NAME, config.sortby);
				DoMethod(window,MUIM_Window_SetMenuCheck,ID_SORTBY_DATE, !config.sortby);
			}
			Close (iff->iff_Stream);
		}
		FreeIFF (iff);
	}
	set(list, MUIA_List_Quiet, FALSE);
	eventnode=ActivateFirst((Object *)list);
	set(window, MUIA_Window_Sleep, FALSE);

	return TRUE;
}

BOOL WriteIFF(Object *elist, char *file) {
	struct IFFHandle *iff;
	struct EventNode	*eventnode;
	struct Node				*node;
	struct List				*list;
	int pos=0;

	set(window, MUIA_Window_Sleep, TRUE);
	config.groupevents=DoMethod(window,MUIM_Window_GetMenuCheck,ID_GROUP_EVENTS);
	config.flashscreen=DoMethod(window,MUIM_Window_GetMenuCheck,ID_FLASH_SCREEN);
	config.ack_events=DoMethod(window,MUIM_Window_GetMenuCheck,ID_ACK_EVENTS);
	config.ack_alerts=DoMethod(window,MUIM_Window_GetMenuCheck,ID_ACK_ALERTS);
	config.usereqtools=DoMethod(window,MUIM_Window_GetMenuCheck,ID_REQTOOLS);
	config.centrerequesters=DoMethod(window,MUIM_Window_GetMenuCheck,ID_CENTRE_REQUESTERS);
	config.confirm=DoMethod(window,MUIM_Window_GetMenuCheck,ID_CONFIRM);
	config.autoopencalendar=DoMethod(window,MUIM_Window_GetMenuCheck,ID_AUTOOPEN_CALENDAR);
	config.autodelete=DoMethod(window,MUIM_Window_GetMenuCheck,ID_AUTODELETE);
	config.sortby=DoMethod(window,MUIM_Window_GetMenuCheck,ID_SORTBY_NAME);
	if(DoMethod(window, MUIM_Window_GetMenuCheck, ID_REQTOOLS))
		DoMethod(app, MUIM_Application_SetMenuState, ID_CENTRE_REQUESTERS, TRUE);
	else
		DoMethod(app, MUIM_Application_SetMenuState, ID_CENTRE_REQUESTERS, FALSE);

	iff=AllocIFF();
	iff->iff_Stream=Open(file, MODE_NEWFILE);
	InitIFFasDOS(iff);
	OpenIFF(iff,IFFF_WRITE);

	PushChunk(iff, ID_PREF, ID_FORM, IFFSIZE_UNKNOWN);

	PushChunk(iff, 0, ID_CONF, IFFSIZE_UNKNOWN);
	WriteChunkBytes(iff, &config, sizeof(struct Config));
	PopChunk(iff);

	while(TRUE) {
		DoMethod(elist, MUIM_List_GetEntry, pos++, &eventnode);
		if(eventnode==NULL)
		  break;
		PushChunk(iff, 0, ID_EVNT, IFFSIZE_UNKNOWN);
		WriteChunkBytes(iff, eventnode, sizeof(struct EventNode));
		PopChunk(iff);

		list=eventnode->textlist;
		for(every_node) {
			PushChunk(iff, 0, ID_ETXT, IFFSIZE_UNKNOWN);
			WriteChunkBytes(iff, node->ln_Name, strlen(node->ln_Name)+1);
			PopChunk(iff);
		}
	}

	PopChunk(iff);

	CloseIFF(iff);
	Close(iff->iff_Stream);
	FreeIFF(iff);

	set(window, MUIA_Window_Sleep, FALSE);

	return TRUE;
}


BOOL OpenProject(Object *list, char *file)
{
	if(GetFile(	GetWinPtr(window),
							aslreq,
							"Select Project to Open",
							file,
							""))
	{
		set(list, MUIA_List_Quiet, TRUE);
		FreeEventList();
		ReadIFF(list, file);
		set(list, MUIA_List_Quiet, FALSE);
		return TRUE;
	}
	return FALSE;
}

BOOL MergeProject(Object *list, char *file)
{
	if(GetFile(	GetWinPtr(window),
							aslreq,
							"Select Project to Merge",
							file,
							""))
	{
		ReadIFF(list, file);
		return TRUE;
	}
	return FALSE;
}

BOOL SaveAsProject(Object *list, char *file)
{
	if(GetFile(	GetWinPtr(window),
							aslreq,
							"Save Project as...",
							file,
							""))
	{
		WriteIFF(list, file);
		return TRUE;
	}
	return FALSE;
}
