/*
 *	File:					GUI.h
 *	Description:	Sets up the user interface
 *
 *	(C) 1993, Ketil Hunn
 *
 */

#include "GetWinPtr().h"
#include "Active().h"

// Listviews
#define LOAD_ASCII							0
#define LOAD_V1X								1
#define LOAD_V20								2

#define SAVE_ASCII							0
#define	SAVE_V20								1

// Menu and buttons
#define ID_ABOUT								101
#define ID_SOURCELISTVIEW				102
#define ID_DESTINATIONLISTVIEW	103
#define ID_GETSOURCE						104
#define ID_GETDESTINATION				105
#define ID_SOURCESTRING					106
#define ID_DESTINATIONSTRING		107
#define	ID_CONVERT							108

#define DEFSOURCE					"<source file>"
#define DEFDESTINATION		"<destination file>"

APTR app, window;

Object *sourceListView,	 *destinationListView;

APTR		getSource,				sourceString,
				getDestination,		destinationString,
				convert;

char *inType[]={	"ASCII",
									"Recall V1.x",
									"Recall V2.0",
									NULL };

char *outType[]={	"ASCII",
									"Recall V2.0",
									NULL };

struct NewMenu converterMenu[] = {
	NM_TITLE,	"Project",					NULL,	0,	0L,	NULL,
		NM_ITEM,	"About...",				"?",	0,	0L,	(APTR)ID_ABOUT,
		NM_ITEM,	NM_BARLABEL,			NULL,	0,	0L,	NULL,
		NM_ITEM,	"Quit",						"Q",	0,	0L,	(APTR)MUIV_Application_ReturnID_Quit,
	{NM_END,	NULL,								0,		0,	0,	(APTR)0},
 };

APTR SetupGUI(void)
{
	init();

	/* Setting up the GUI */
	app = ApplicationObject,
		MUIA_Application_Title      , CONVERTERNAME,
		MUIA_Application_Version    , VERSTR2,
		MUIA_Application_Copyright  , COPYRIGHT " "AUTHOR,
		MUIA_Application_Author     , AUTHOR,
		MUIA_Application_Description, DESCRIPTION2,
		MUIA_Application_Base       , "CONVBASE",

		SubWindow, window =   WindowObject,
			MUIA_Window_Title, CONVERTERNAME,
			MUIA_Window_ID,    'EDIT',
			MUIA_Window_Menu,   converterMenu,
			MUIA_Window_Width,	MUIV_Window_Width_Screen(45),
			MUIA_Window_Height,	MUIV_Window_Height_Screen(50),
			MUIA_HelpFile,			"HELP:English/RecallConverter.guide",
			WindowContents, VGroup,
				Child, HGroup, MUIA_Group_SameHeight, TRUE,
					Child, HGroup, GroupFrameT("Source Type"),
						MUIA_HelpNode, "SourceListView",
						Child, sourceListView = ListviewObject,
							MUIA_Listview_Input, TRUE,
							MUIA_Listview_List, ListObject,InputListFrame,
							End,
						End,
					End,

					Child, HGroup, GroupFrameT("Destination Type"),
						MUIA_HelpNode, "DestinationListView",
						Child, destinationListView = ListviewObject,
							MUIA_Listview_Input, TRUE,
							MUIA_Listview_List, ListObject,InputListFrame,
							End,
						End,
					End,
				End,

				Child, HGroup,
					Child, ColGroup(3),
						MUIA_Group_HorizSpacing, 0,
						Child, KeyLabel1("Source:", NULL),
						Child, HGroup,
							MUIA_HelpNode, "SourceString",
							Child, sourceString = StringObject, StringFrame, End,
						End,
						Child, getSource = ImageObject,
								MUIA_Image_Spec,			MUII_PopFile,
								MUIA_Image_FreeVert,	TRUE,
								MUIA_ShowSelState,		TRUE,
								MUIA_Weight,					0,
								MUIA_Frame,						MUIV_Frame_Button,
								MUIA_Background,			MUII_BACKGROUND,
								MUIA_InputMode,				MUIV_InputMode_RelVerify,
								MUIA_HelpNode, "GetSource",
						End,

						Child, KeyLabel1("Destination:", NULL),
						Child, HGroup,
							MUIA_HelpNode, "DestinationString",
							Child, destinationString = StringObject, StringFrame, End,
						End,
						Child, getDestination = ImageObject,
								MUIA_Image_Spec,			MUII_PopFile,
								MUIA_Image_FreeVert,	TRUE,
								MUIA_ShowSelState,		TRUE,
								MUIA_Weight,					0,
								MUIA_Frame,						MUIV_Frame_Button,
								MUIA_Background,			MUII_BACKGROUND,
								MUIA_InputMode,				MUIV_InputMode_RelVerify,
								MUIA_HelpNode, "GetDestination",
						End,
					End,
				End,

				Child, VSpace(6),
				Child, HGroup,
					MUIA_HelpNode, "Convert",
					Child, convert =	KeyButton("Convert", 'c'),
				End,
			End,
		End,
	End;

	if(!app)
		fail(app,"Failed to create Application.");

	DoMethod(sourceListView, MUIM_List_Insert,inType, -1,MUIV_List_Insert_Bottom);
	DoMethod(destinationListView,   MUIM_List_Insert,outType,-1,MUIV_List_Insert_Bottom);
	set(sourceListView, MUIA_List_Active, LOAD_V1X);
	set(destinationListView,   MUIA_List_Active, SAVE_V20);

	DoMethod(	window,MUIM_Window_SetCycleChain,
						sourceListView, destinationListView,
						sourceString, getSource,
						destinationString, getDestination,
						convert,
						NULL);

	DoMethod(window,				MUIM_Notify, MUIA_Window_CloseRequest,TRUE,app,2,
														MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit);
	DoMethod(getSource,					MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_GETSOURCE);
	DoMethod(sourceString,			MUIM_Notify, MUIA_String_Acknowledge, MUIV_EveryTime, app,2,MUIM_Application_ReturnID,ID_SOURCESTRING);
	DoMethod(getDestination,		MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_GETDESTINATION);
	DoMethod(destinationString,	MUIM_Notify, MUIA_String_Acknowledge, MUIV_EveryTime, app,2,MUIM_Application_ReturnID,ID_DESTINATIONSTRING);

	DoMethod(convert,			MUIM_Notify, MUIA_Pressed,FALSE,app,2,MUIM_Application_ReturnID,ID_CONVERT);

	return app;
}
