/*
 *	File:					GetFile.h
 *	Description:	Pop up a standard filerequester to let the user select a
 *								file.  Returns the selected path and file.
 *								NOTE! The pointer to the FileRequester MUST already be
 *											ALLOCATED!
 *
 *	(C) 1993, Ketil Hunn
 *
 */

BOOL GetFile(struct Window *window,
							struct FileRequester *aslreq,
							char *title,
							char *input,
							char *pattern)
{
	char drive[FNSIZE], path[FNSIZE], name[FNSIZE],ext[FESIZE];
	char *file=input;
	BOOL success=FALSE;

	strsfn(input, drive, path, name, ext);
	file+=strlen(drive)+strlen(path);
	while(strchr(file,'/'))
		file++;

	if(success=MUI_AslRequestTags(aslreq,
																ASLFO_InitialLeftEdge,window->LeftEdge,
																ASLFO_InitialTopEdge,	window->TopEdge,
																ASLFO_Window,					window,
																ASLFO_TitleText				,title,
																ASLFR_InitialDrawer		,strcat(drive, path),
																ASLFR_InitialFile			,file,
																ASLFR_InitialPattern	,pattern,
																NULL))
		strmfp(input, aslreq->rf_Dir, aslreq->rf_File);
	return success;
}
