/*
 *	File:					Iffconfig.h
 *	Description:	Defines the structure of the configuration and events.
 *								Reads and writes the project as an V2.0 IFF-FORM.
 *
 *	(C) 1993 Ketil Hunn
 *
 */

#include <libraries/iffparse.h>
#include <clib/iffparse_protos.h>
#include <dos.h>
//#include <string.h>

#define  ID_PREF	MAKE_ID('P','R','E','F')
#define  ID_CONF	MAKE_ID('C','O','N','F')
#define  ID_EVNT	MAKE_ID('E','V','N','T')
#define  ID_ETXT	MAKE_ID('E','T','X','T')

char *ifferrormsgs[] = {"End of file (not an error).",
												"End of context (not an error).",
												"No lexical scope.",
												"Insufficient memory.",
												"Stream read error.",
												"Stream write error.",
												"Stream seek error.",
												"File is corrupt.",
												"IFF syntax error.",
												"Not an IFF file.",
												"Required call-back hook missing.",
												"Return to client.  You should never see this."};


struct Config20 {
	BOOL	centrerequesters;
	BOOL	groupevents;
	BOOL	flashscreen;
	BOOL	ack_events;
	BOOL	ack_alerts;
	BOOL	autodelete;
	BOOL	confirm;
	BOOL	autoopencalendar;
	BOOL	usereqtools;
	int		sortby;
};

struct EventNode20 {
	char				name[30];
	short				whendate;
	short				day;
	short				month;
	int					year;
	short				whentime;
	short				hour;
	short				minutes;
	int					days;
	int					repeat;
	short				type;
	short				show;
	short				calc;
	long				datestamp;
	short				display;
	short				expansion1;
	short				expansion2;
	struct List	*textlist;
};

BOOL ReadIFF(struct List *list, char source[256])
{
	struct IFFHandle		*iff=NULL;
	struct ContextNode	*cn=NULL;
	struct Config20			config;
	struct EventNode20	tmpnode;
	struct GlobalNode		*globalnode;
	long								error=0;
	char 								tmp[FNSIZE];
	BOOL success=FALSE;

	if(iff=AllocIFF())
	{
		if(iff->iff_Stream=Open(source, MODE_OLDFILE))
		{
			InitIFFasDOS (iff);
			if(!(error=OpenIFF(iff, IFFF_READ)))
			{
				ParseIFF(iff, IFFPARSE_RAWSTEP);
				cn=CurrentChunk(iff);
				if(cn->cn_ID!=ID_FORM && cn->cn_Type!=ID_PREF)
					MyRequest("Not a " PROGNAME " IFF-file:\n%s\n%s", "OK", source);
				else
				{
					ParseIFF(iff, IFFPARSE_RAWSTEP);
					cn=CurrentChunk(iff);
					if(cn->cn_ID!=ID_CONF)
						MyRequest("Not a " PROGNAME " IFF-file:\n%s\n%s", "OK", source);
					else
					{
						ReadChunkBytes(iff,(APTR)&config, cn->cn_Size);
						globalConfig.centrerequesters	=config.centrerequesters;
						globalConfig.groupevents			=config.groupevents;
						globalConfig.flashscreen			=config.flashscreen;
						globalConfig.ack_events				=config.ack_events;
						globalConfig.ack_alerts				=config.ack_alerts;
						globalConfig.autodelete				=config.autodelete;
						globalConfig.confirm					=config.confirm;
						globalConfig.autoopencalendar	=config.autoopencalendar;
						globalConfig.sortby						=config.sortby;

						while(TRUE)
						{
							error=ParseIFF(iff, IFFPARSE_RAWSTEP);
							if(error==IFFERR_EOC)
								continue;
							else if(error)
								break;

							success=TRUE;
							if(cn=CurrentChunk(iff))
							{
								switch(cn->cn_ID)
								{
									case ID_EVNT:
										if(ReadChunkBytes(iff,(APTR)&tmpnode,cn->cn_Size)==cn->cn_Size) {
											globalnode=AddEvent(list, tmpnode.name);
											globalnode->whendate	=tmpnode.whendate;
											globalnode->day				=tmpnode.day;
											globalnode->month			=tmpnode.month;
											globalnode->year			=tmpnode.year;
											globalnode->whentime	=tmpnode.whentime;
											globalnode->hour			=tmpnode.hour;
											globalnode->minutes		=tmpnode.minutes;
											globalnode->days			=tmpnode.days;
											globalnode->repeat		=tmpnode.repeat;
											globalnode->type			=tmpnode.type;
											globalnode->show			=tmpnode.show;
											globalnode->calc			=tmpnode.calc;
										}
										break;

									case ID_ETXT:
										if(ReadChunkBytes(iff,(APTR)&tmp,cn->cn_Size)==cn->cn_Size)
											AddText(globalnode->textlist, tmp);
										break;
								}
							}
						}
						if(error!=IFFERR_EOF)
							MyRequest("IFFfile scan aborted: %s", "OK",
											ifferrormsgs[-error - 1]);
					}
				}
				CloseIFF (iff);
			}
			Close (iff->iff_Stream);
		}
		FreeIFF (iff);
	}
	return success;
}



void WriteIFFTexts(struct IFFHandle *iff, struct List *list)
{
	struct Node *node;

	for(every_node)
	{
		PushChunk(iff, 0, ID_ETXT, IFFSIZE_UNKNOWN);
		WriteChunkBytes(iff, node->ln_Name, strlen(node->ln_Name)+1);
		PopChunk(iff);
	}
}

BOOL WriteIFF(struct List *list, char *destination)
{
	struct Config20			config;
	struct EventNode20	*eventnode;
	struct GlobalNode		*globalnode;
	struct Node					*eNode;
	struct IFFHandle		*iff=NULL;

	iff=AllocIFF();
	iff->iff_Stream=Open(destination, MODE_NEWFILE);
	InitIFFasDOS(iff);
	OpenIFF(iff,IFFF_WRITE);

	PushChunk(iff, ID_PREF, ID_FORM, IFFSIZE_UNKNOWN);

	PushChunk(iff, 0, ID_CONF, IFFSIZE_UNKNOWN);

	config.centrerequesters	=globalConfig.centrerequesters;
	config.groupevents			=globalConfig.groupevents;
	config.flashscreen			=globalConfig.flashscreen;
	config.ack_events				=globalConfig.ack_events;
	config.ack_alerts				=globalConfig.ack_alerts;
	config.autodelete				=globalConfig.autodelete;
	config.confirm					=globalConfig.confirm;
	config.autoopencalendar	=globalConfig.autoopencalendar;
	config.sortby						=globalConfig.sortby;
	WriteChunkBytes(iff, &config, sizeof(struct Config20));
	PopChunk(iff);

	eventnode=AllocMem(sizeof(struct EventNode20), MEMF_CLEAR);
	for(eNode=list->lh_Head; eNode->ln_Succ; eNode=eNode->ln_Succ)
	{
		globalnode=(struct GlobalNode *)eNode;

		strcpy(eventnode->name, globalnode->eventname);
		eventnode->whendate	=globalnode->whendate;
		eventnode->day			=globalnode->day;
		eventnode->month		=globalnode->month;
		eventnode->year			=globalnode->year;
		eventnode->whentime	=globalnode->whentime;
		eventnode->hour			=globalnode->hour;
		eventnode->minutes	=globalnode->minutes;
		eventnode->days			=globalnode->days;
		eventnode->repeat		=globalnode->repeat;
		eventnode->type			=globalnode->type;
		eventnode->show			=globalnode->show;
		eventnode->calc			=globalnode->calc;

		PushChunk(iff, 0, ID_EVNT, IFFSIZE_UNKNOWN);
		WriteChunkBytes(iff, eventnode, sizeof(struct EventNode20));
		PopChunk(iff);

		WriteIFFTexts(iff, globalnode->textlist);
	}
	PopChunk(iff);

	CloseIFF(iff);
	Close(iff->iff_Stream);
	FreeIFF(iff);
	FreeMem(eventnode, sizeof(struct EventNode20));
	return TRUE;

}

