

//---------------------------VOBJ.H----------------------------------------//

#ifndef _vobj_h_
#define _vobj_h_


#ifndef __LARGE__
#ifndef __COMPACT__
#error use the LARGE or COMPACT memory model
#endif
#endif

#include <stdlib.h>
#include <mem.h>
#include <generic.h>

#include "flatarry.h"

class VMemory;
class VPtrBase;

typedef long VHANDLE;                // uniquely identifies a VObject

class VObject {
  VHANDLE handle;                    // object stores its own copy of
  size_t size;                       //  virtual memory handle and size
public:
  int i;
  void* operator new(size_t);        // overload new operator for compliance
  friend VMemory;                    //   with virtual memory mechanism
  friend VPtrBase;
  friend  void Delete(VPtrBase& p);  // emulate C++'s delete operator
  virtual ~VObject() {  }  	     // need virtual destructors
};

// define base class for 'smart' pointer that references a VObject,
// 	or any object of a class descended from it.

class VPtrBase {
protected:
  VHANDLE handle;               // object ID (the vital part)
  VObject* OPtr;                // points to memory buffer holding object
				//   (for VEntries only)
  VPtrBase* PNext;      	// next in the pointer chain
  VPtrBase* PLast;              // last in the pointer chain

  void InsertRightOf(VPtrBase& Other_ObjPtr)
  {
    PLast = &Other_ObjPtr;          		// used to insert a VEntry
    Other_ObjPtr.PNext = this;                  // (descended from VPtrBase)
    handle = Other_ObjPtr.handle;               // into LRU stack
    return;
  }

public:
  VPtrBase();
  VPtrBase(VObject* p);        	 	 // create NULL pointer
  VPtrBase& operator=(VObject* p);       // assign to a (usually) new object
  operator VHANDLE() { return handle; }  // for testing a VPtr for NULL

  VPtrBase& VPtrBase::operator=( VPtrBase& Other_ObjPtr )
  {
    if (PNext) PNext->PLast=PLast;   	 // assignment to another VPtr:
    if (PLast) PLast->PNext=PNext;       //  remove from current chain
    PNext = &Other_ObjPtr;
    PLast = Other_ObjPtr.PLast;          //  insert in new chain
    Other_ObjPtr.PLast = this;
    OPtr=NULL;
    handle = Other_ObjPtr.handle;        //  get own copy of handle
    return (*this);
  }

  VPtrBase( VPtrBase& Other_ObjPtr )     //
  {                                      // copy constructor for VPtrs
    PNext = &Other_ObjPtr;               //
    PLast = Other_ObjPtr.PLast;
    Other_ObjPtr.PLast = this;
    handle = Other_ObjPtr.handle;
    OPtr=NULL;
  }

  ~VPtrBase()
  {
     if (PNext) (*PNext).PLast = PLast;  // if VPtr goes out of scope,
     if (PLast) (*PLast).PNext = PNext;  //   take it out of chain before
  }                                      //   its destruction.

  VObject* Lock(int s=1);                // to lock VPtr's object in memory
  void Unlock() { Lock(0); }		 // & unlock it again.

  VPtrBase(VHANDLE);
  VPtrBase& operator=(VHANDLE);
  inline VObject* operator->();          // overloaded dereferencing
  inline VObject& operator*();		 //  operators
  friend VMemory;
  friend void Lock(VObject*, int);       // object lock using simple pointer
  friend void Delete(VPtrBase& p);	 // object destruction via the VPtr

};
    // Descendant of VPtrBase ; designed to point to
    //   TYPEs deriving from VObject
    //   uses GENERIC.H preprocessing type-creation mechanism

#define VPtr(TYPE) _Paste2(VPtr_,TYPE)

#define VPtrdeclare(TYPE)                                               \
class VPtr(TYPE) : public VPtrBase {                                    \
public:                                                                 \
  VPtr(TYPE) (VObject* pO): VPtrBase(pO) {  }   				\
  TYPE & operator*() { return *(TYPE*)(VPtrBase::operator->()); }    	\
  TYPE * operator->() { return (TYPE*)(VPtrBase::operator->()); }    	\
  TYPE* Lock (int s=1) { return (TYPE*)VPtrBase::Lock(s); }  		\
  VPtr(TYPE)() : VPtrBase() { }						\
  VPtr(TYPE)(VHANDLE hnd): VPtrBase(hnd) { }                            \
  VPtr(TYPE)& operator=(VObject *p) {                                   \
    return (VPtr(TYPE)&)(VPtrBase::operator=(p)); }                     \
  VPtr(TYPE)& operator=(VHANDLE hnd) {                                  \
    return (VPtr(TYPE)&)(VPtrBase::operator=(hnd)); }                   \
  VPtr(TYPE)& operator=(VPtr(TYPE)& r) {                                \
    return (VPtr(TYPE)&)(VPtrBase::operator=((VPtrBase&)r)); }          \
}



class VEntry : public VPtrBase
{
  friend VMemory;
  friend VPtrBase;
  friend void Lock(VObject*, int);

  VEntry *up, *down;
  int locked;

public:
  void activate(VPtrBase* , VObject*); // attach VPtr's to memory buffer
  ~VEntry();
  VEntry* FindUnlocked();  // find first unlocked entry, starting with this
  VEntry()
  {
    locked = 0;
    up=down=NULL;
  }
};

class VMemory
{
  friend VPtrBase;
  VHANDLE nBlk,bSiz;            // #blocks, blocksize heap parameters
  FlatArray& VtlArray;          // the array used for the virtual heap
  size_t maxnEntries;           // desired maximum # entries
  size_t nEntries;              // current number of objects resident
  VEntry *HeadEntry,*TailEntry; // to manage LRU stack linked list
  VHANDLE iCurrent;
public:
  VMemory(FlatArray*, size_t numblk, size_t blksize = 32, size_t maxne=4);
  VEntry* CreateEntryFor(VPtrBase* , VObject*);
  long offs(VHANDLE hnd)
  {
    return nBlk * sizeof(size_t) + bSiz * hnd; // translate handle into
  }                                            // virtual array offset

public:
  void AddEntryAtHead(VEntry* p); // put LRU entry on top of stack
  void RemoveEntry(VEntry * p);   // remove LRU entry from stack
  Delete_LRU_Entry();             // remove least recently used
  void DeAllocMem(VHANDLE hnd);	  // deallocate virtual array space
  VHANDLE AllocMem(size_t sz) ;   // find handle, allocate array space
  VEntry *LoadObject(VPtrBase* p); // ensure that object is in memory
  void StoreObject(VPtrBase* p) ;  // remove object's resident status
  friend void Lock(VObject*, int s);
  operator long() {
    return VtlArray ? nBlk : 0L;   // check if invalid: if (!AVMem) ...
  }
  friend  void Delete(VPtrBase& p);
  void flush();      // remove all LRU entries; store all objects
};

extern VMemory AVMem;		// the global virtual memory object
				//  (there can be at most one)


// -- create virtual pointer from plain C++ pointer (returned by 'new') --

inline VPtrBase::VPtrBase(VObject* p)
{
  PLast = PNext = NULL;
  (*this) = p;
}

/** change aug 15 **/

inline VPtrBase::VPtrBase()
{
  PLast = PNext = NULL;
  (*this) = (VObject*) NULL;
}

/****/
//
// function prototypes
//
int PTRS_EQUAL( void far* p0, void far* q0 );
void Lock(VObject* op, int s=1);
void Unlock(VObject* op);
void Delete(VPtrBase& p);

#endif /**_vobj_h_**/

