/*
 * CSplit.h
 * 08/31/93  Fred Cole     original
 * 09/05/93  Fac           update for CRC routines
 * 09/14/93  Fac           update for link list routines
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef __STDC__
#include "portable.h"
#endif

#define VERSION  "1.32"

enum { FALSE = 0, TRUE };
enum { NOERR = 0, HELP, MEMORY, INFILE, OUTFILE, PROCESS, READ, WRITE };

#define FNAME    12   /* 8.3 filespec character count */
#define LINES    90   /* default source lines per section */    /* TS */
#define LENGTH   75   /* default source chars per line */
#define PATHMAX  80   /* maximum path spec length */
#define TABDEF    4   /* default spaces per tab char */
#define TABMAX   16   /* maximum spaces per tab char */
#define TABMIN    2   /* minimum spaces per tab char */
#define SEP_AR   " >>>>>>>>>>"
#define SEP_BF   "Begin file "
#define SEP_BP   "Begin part "
#define SEP_EF   "End file "
#define SEP_EP   "End part "
#define SEP_ID   ">>>>>>>>>> CSplit: "

typedef struct _slst
{
  char srcfile[FNAME+1];          /* no path support */
  struct _slst *next;
} SLST;

void cleanup(void);
void disp_help(void);
int  extract(char *);
char *my_fgets(char *, int, FILE *, int);
unsigned short updcrc( unsigned short, unsigned char *, unsigned int );
void initcrctab(void);
SLST *addlist(char *);
void freelist(void);
int  initlist(int, char **, int);
