/******************************************************************
*
*	AmyGUI++ - AmyWindow.h
*
*	Author: Erkki Tapola
*
*	$Id: amywindow.h 1.2 1994/04/01 12:10:33 Delta stabile $
*
*	AmyWindow simplifies window opening, gadget creation,
*	AppWindow usage (icons dropped into the window),
*	font changing, input handling and drawing.
*
******************************************************************/

#ifndef AMYWINDOW_H
#define AMYWINDOW_H

#include "amymisc.h"
#include "amyfont.h"

struct Window;		// Some dummies just to speed up compilation
struct Screen;
struct Gadget;
struct TextFont;
struct TextAttr;
struct MsgPort;
struct AppWindow;

class AmyGadget;

class AmyWindow {

protected:

    Window *window;	// The system handle
    Screen *pubscreen;	// Windows screen
    void *visualinfo;
    Gadget *gadgets, *lastgadget;
		// These help in creation of gadgets

    MsgPort *iconport;
    AppWindow *appwindow;
		// For AppWindow (icon dropping)

    long signalbits;	// The bits used in signalling to this window
			// including all possible messages from intuition
    TextFont *windowfont;	// Will be thoroughly taken advantage at
				// a later time
    TextAttr *screenfont;	// The font of the screen

    Dimension hold;	// This window's position and size

    Boolean	CloseButton,	// For holding information while
		Sizeable,	// the window is closed
		Draggable;

    char *title;
    // char ShortCuts[27];	// For fast checking of shortkeys in this
				// window
    Boolean GadgetsAttached;	// Just to make sure

    void Init();		// General initializations

	// These virtual functions are implemented in a child class,
	// and the AmyWindow.WaitForAction() calls them when user gives some input

    virtual int GadgetUp(AmyGadget &Gadget) { return 0; }
    virtual int GadgetDown(AmyGadget &Gadget) { return 0; }
    virtual int KeyDown(unsigned char KeyCode) { return 0; }
    virtual int IconDropped(const char *Filename, AmyPoint &DropPoint) { return 0; }

    // void CheckButtons(unsigned char KeyCode);	Later...
    void ActivateNext(AmyGadget &Gadget);	// Not in use

    void AttachGadgets();
    void DeattachGadgets();

public:

    AmyWindow();
    AmyWindow(int Left, int Top, int Width, int Height);
    virtual ~AmyWindow();

	// Booleans for controlling the parameters of the window (before opening !)

    AmyWindow &SetCloseButton(short int truefalse) { CloseButton = truefalse;  return *this; }	// Default: True
    AmyWindow &SetSizeable(short int truefalse) { Sizeable = truefalse; return *this; }		// Default: False
    AmyWindow &SetDraggable(short int truefalse) { Draggable = truefalse; return *this; }	// Default: True
    AmyWindow &SetTitle(char *String) { title = String; return *this; }	// Default: AmyGUI window

	// and after opening
    AmyWindow &EnableIconDrops(short int truefalse = True);

	// Change the font of a window (applicable only when drawing graphics or text with Draw()

    AmyWindow &Set(TextFont *Font) { windowfont = Font; return *this; }
    AmyWindow &Set(AmyFont &Font);

    AmyWindow &Show();	// Open the window
    AmyWindow &Hide();	// Close the window

	// Draw graphics into the window

    AmyWindow &Draw(char *String, int x, int y);
    AmyWindow &DrawColor(int ColorNumber);

    // AmyWindow &Add(AmyGadget &Gadget);

    void	Add(Gadget *Gadget);	// Add a gadget to the window.
					// you should read AmyGadget.h first.

	// Is the window open ?
    Boolean	IsOpen() { return window != NULL; }

    Screen	*GetScreen();	// Get the screen of this window
    void	*GetVI() { return visualinfo; }	// The VisualInfo
    TextAttr	*GetTextAttr();	// The font

	// The last gadget in the list
    Gadget	*GetLastGadget() { return lastgadget; }

    void WaitForAction();

    operator Window *() { return window; }	// Be very careful with this !
};

#endif
