/******************************************************************
*
*	AmyGUI++ - AmyPrinter.h
*
*	Author: Erkki Tapola
*
*	$Id: amyprinter.h 1.2 1994/04/01 11:38:33 Delta stabile $
*
*	AmyPrinter handles the printing of screens (and windows).
*	In the future it will be capable of outputting
*	vector graphics and system fonts on any graphics printer
*	which has an Amiga driver.
*
*	This version of AmyPrinter will not be published in the
*	near future.
*
******************************************************************/

#ifndef AMYPRINTER_H
#define AMYPRINTER_H

#include "amywindow.h"
#include "amymisc.h"

#if 0
extern "C" {
#include <devices/printer.h>
#include <devices/prtbase.h>
}
#endif

struct IODRPReq;	// To speed up compilation
struct MsgPort;
struct PrinterData;
struct PrinterExtendedData;
struct Screen;

class AmyPrinter {

protected:

  struct IODRPReq *iodrp;
  struct MsgPort  *printerPort;
  struct PrinterData *pd;
  struct PrinterExtendedData *ped;

public:
  AmyPrinter();
  ~AmyPrinter();

  int Print(AmyWindow &);
  int screendump(struct Screen *, unsigned short,  unsigned short,
		 unsigned short,  unsigned short, long, unsigned short);

  const char *GetDriver();
  Dimension GetDPI();
  Dimension GetMaxDots();
};

#endif
